/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIAnswersContainer.gtmpl")
public class UIAnswersContainer
extends UIContainer {
    private FAQSetting faqSetting_ = null;
    private String currentUser_;
    private boolean isRenderChild = true;
    private boolean hasPermission = true;
    private FAQService faqService_;

    public UIAnswersContainer() throws Exception {
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)((UIBreadcumbs)this.addChild(UIBreadcumbs.class, null, null)).setRendered(true);
        UIQuestions uiQuestions = (UIQuestions)((UIQuestions)this.addChild(UIQuestions.class, null, null)).setRendered(true);
        UICategories uiCategories = (UICategories)((UICategories)this.addChild(UICategories.class, null, null)).setRendered(true);
        this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.faqSetting_ = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        this.faqSetting_.setCurrentUser(this.currentUser_);
        if (!FAQUtils.isFieldEmpty((String)this.currentUser_)) {
            if (this.faqService_.isAdminRole(this.currentUser_)) {
                this.faqSetting_.setIsAdmin("TRUE");
            } else {
                this.faqSetting_.setIsAdmin("FALSE");
            }
            this.faqService_.getUserSetting(this.currentUser_, this.faqSetting_);
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        this.hasPermission = this.isRenderChild = this.isRenderCategory(Utils.CATEGORY_HOME);
        uiBreadcumbs.setUpdataPath(Utils.CATEGORY_HOME);
        uiQuestions.setFAQService(this.faqService_);
        uiQuestions.setFAQSetting(this.faqSetting_);
        uiQuestions.setCategoryId(Utils.CATEGORY_HOME);
        uiCategories.setFAQSetting(this.faqSetting_);
        uiCategories.setFAQService(this.faqService_);
        if (uiCategories.getCategoryPath() == null) {
            uiCategories.setPathCategory(Utils.CATEGORY_HOME);
        }
    }

    public void setViewRootCate() {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        try {
            UIQuestions questions = (UIQuestions)this.getChild(UIQuestions.class);
            questions.setGetQuestion();
            boolean b = questions.isGetQuestion();
            if (b != this.hasPermission) {
                this.hasPermission = b;
            }
            if (Utils.CATEGORY_HOME.equals(questions.getCategoryId())) {
                this.isRenderChild = this.hasPermission;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRenderCategory(String categoryId) throws Exception {
        try {
            List propetyOfUser = new ArrayList();
            Category category = this.faqService_.getCategoryById(categoryId);
            if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
                this.faqSetting_.setCurrentUser(this.currentUser_);
                this.faqSetting_.setCanEdit(false);
                if (this.faqSetting_.getIsAdmin() != null && this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    this.faqSetting_.setCanEdit(true);
                } else if (category.getModerators() != null && category.getModerators().length > 0 && category.getModerators()[0].trim().length() > 0) {
                    propetyOfUser = FAQServiceUtils.getAllGroupAndMembershipOfUser((String)this.currentUser_);
                    this.faqSetting_.setCanEdit(this.hasPermission(propetyOfUser, Arrays.asList(category.getModerators())));
                }
            }
            if (!this.faqSetting_.isCanEdit() && category.getUserPrivate() != null && category.getUserPrivate().length > 0 && category.getUserPrivate()[0].trim().length() > 0) {
                if (propetyOfUser.isEmpty()) {
                    propetyOfUser = FAQServiceUtils.getAllGroupAndMembershipOfUser((String)this.currentUser_);
                }
                return this.hasPermission(propetyOfUser, Arrays.asList(category.getUserPrivate()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean hasPermission(List<String> listPlugin, List<String> listOfUser) {
        for (String str : listPlugin) {
            if (!listOfUser.contains(str)) continue;
            return true;
        }
        return false;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    public boolean getRenderChild() {
        return this.hasPermission;
    }

    public void updateIsRender(boolean isRender) throws Exception {
        ((UICategories)this.getChild(UICategories.class)).setRendered(isRender);
        ((UIBreadcumbs)this.getChild(UIBreadcumbs.class)).setRendered(isRender);
        ((UIQuestions)this.getChild(UIQuestions.class)).setRendered(isRender);
    }
}

