/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.SelectItem;
import org.exoplatform.faq.webui.SelectOption;
import org.exoplatform.faq.webui.UIFormSelectBoxWithGroups;
import org.exoplatform.faq.webui.popup.UIAddressEmailsForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIAddressEmailsForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressEmailsForm
extends UIForm
implements UIPopupComponent {
    public static final String USER_SEARCH = "user-search".intern();
    public static final String USER_GROUP = "user-group".intern();
    public Map<String, User> checkedList_ = new HashMap();
    public Map<String, User> newCheckedList_ = new HashMap();
    private static final String FILED_ALL_GROUP = "all-group";
    private String selectedAddressId_ = "";
    private String recipientsType_ = "";
    private UIPageIterator uiPageList_;

    public void setRecipientsType(String type) {
        this.recipientsType_ = type;
    }

    public String getRecipientType() {
        return this.recipientsType_;
    }

    public UIAddressEmailsForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER_SEARCH, USER_SEARCH, null));
        UIFormSelectBoxWithGroups uiSelect = new UIFormSelectBoxWithGroups(USER_GROUP, USER_GROUP, this.getOptions());
        uiSelect.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelect);
        this.uiPageList_ = new UIPageIterator();
        this.setUserList(FAQUtils.getAllUser());
    }

    public List<SelectItem> getOptions() throws Exception {
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        options.add((SelectItem)new SelectOption(FILED_ALL_GROUP, FILED_ALL_GROUP));
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group gr : FAQUtils.getAllGroup()) {
            groupIds.add(gr.getId());
        }
        if (!groupIds.isEmpty()) {
            for (String publicCg : groupIds) {
                options.add((SelectItem)new SelectOption(publicCg, publicCg));
            }
        }
        return options;
    }

    private void searchUserProfileByKey(String keyWord) throws Exception {
        try {
            HashSet<User> users = new HashSet<User>();
            OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler handler = service.getUserHandler();
            keyWord = "*" + keyWord + "*";
            Query q = new Query();
            q.setUserName(keyWord);
            for (Object obj : handler.findUsers(q).getAll()) {
                users.add((User)obj);
            }
            q = new Query();
            q.setLastName(keyWord);
            for (Object obj : handler.findUsers(q).getAll()) {
                users.add((User)obj);
            }
            q = new Query();
            q.setFirstName(keyWord);
            for (Object obj : handler.findUsers(q).getAll()) {
                users.add((User)obj);
            }
            q = new Query();
            q.setEmail(keyWord);
            for (Object obj : handler.findUsers(q).getAll()) {
                users.add((User)obj);
            }
            ObjectPageList objPageList = new ObjectPageList(new ArrayList(users), 10);
            this.uiPageList_.setPageList((PageList)objPageList);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIAddressEmailsForm.msg.search-user-failed", null));
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }

    public List<User> getUsers() throws Exception {
        UIFormCheckBoxInput uiInput;
        ArrayList<User> users = new ArrayList<User>(this.uiPageList_.getCurrentPageData());
        for (User c : users) {
            uiInput = this.getUIFormCheckBoxInput(c.getUserName());
            if (uiInput != null) continue;
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(c.getUserName(), c.getUserName(), null));
        }
        for (User c : this.checkedList_.values()) {
            uiInput = this.getUIFormCheckBoxInput(c.getUserName());
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        return users;
    }

    public List<User> getListAllUsers() throws Exception {
        List users = FAQUtils.getAllUser();
        return users;
    }

    public void setUserList(List<User> userList) throws Exception {
        ObjectPageList objPageList = new ObjectPageList(new ArrayList<User>(new HashSet<User>(userList)), 10);
        this.uiPageList_.setPageList((PageList)objPageList);
    }

    public void setAlreadyCheckedUser(List<User> alreadyCheckedUser) throws Exception {
        for (User ct : alreadyCheckedUser) {
            this.checkedList_.put(ct.getUserName(), ct);
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageList_;
    }

    public long getAvailablePage() {
        return this.uiPageList_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageList_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageList_.setCurrentPage(page);
    }

    public List<User> getCheckedUser() throws Exception {
        ArrayList<User> userList = new ArrayList<User>();
        for (User user : new ArrayList(this.uiPageList_.getCurrentPageData())) {
            UIFormCheckBoxInput uiCheckbox = (UIFormCheckBoxInput)this.getChildById(user.getUserName());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            userList.add(user);
        }
        return userList;
    }

    static /* synthetic */ String access$002(UIAddressEmailsForm x0, String x1) {
        x0.selectedAddressId_ = x1;
        return x0.selectedAddressId_;
    }

    static /* synthetic */ String access$000(UIAddressEmailsForm x0) {
        return x0.selectedAddressId_;
    }

    static /* synthetic */ void access$100(UIAddressEmailsForm x0, String x1) throws Exception {
        x0.searchUserProfileByKey(x1);
    }
}

