/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UICategoryForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UISelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIForumUserPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UICategoryForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private String categoryId_ = "";
    private String parentId_;
    private static final String FIELD_NAME_INPUT = "eventCategoryName";
    private static final String FIELD_DESCRIPTION_INPUT = "description";
    private static final String FIELD_USERPRIVATE_INPUT = "userPrivate";
    private static final String FIELD_MODERATOR_INPUT = "moderator";
    private static final String FIELD_INDEX_INPUT = "index";
    private static final String FIELD_MODERATEQUESTIONS_CHECKBOX = "moderatequestions";
    public static final String VIEW_AUTHOR_INFOR = "ViewAuthorInfor".intern();
    private static final String FIELD_MODERATE_ANSWERS_CHECKBOX = "moderateAnswers";
    private static FAQService faqService_;
    private static boolean isAddNew_;
    private String oldName_ = "";
    private Category currentCategory_;
    private static long maxIndex;

    public UICategoryForm() throws Exception {
        faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    }

    public void updateAddNew(boolean isAddNew) throws Exception {
        isAddNew_ = isAddNew;
        UIFormInputWithActions inputset = new UIFormInputWithActions("UIAddCategoryForm");
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME_INPUT, FIELD_NAME_INPUT, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormStringInput index = new UIFormStringInput(FIELD_INDEX_INPUT, FIELD_INDEX_INPUT, null);
        if (isAddNew) {
            maxIndex = faqService_.getMaxindexCategory(this.parentId_) + 1L;
            index.setValue((Object)String.valueOf(maxIndex));
        }
        inputset.addUIFormInput((UIFormInput)index);
        inputset.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_USERPRIVATE_INPUT, FIELD_USERPRIVATE_INPUT, null));
        inputset.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION_INPUT, FIELD_DESCRIPTION_INPUT, null));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX, FIELD_MODERATEQUESTIONS_CHECKBOX, (Object)false));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(VIEW_AUTHOR_INFOR, VIEW_AUTHOR_INFOR, (Object)false));
        inputset.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_MODERATE_ANSWERS_CHECKBOX, FIELD_MODERATE_ANSWERS_CHECKBOX, (Object)false));
        UIFormStringInput moderator = new UIFormStringInput(FIELD_MODERATOR_INPUT, FIELD_MODERATOR_INPUT, null);
        if (isAddNew) {
            moderator.setValue((Object)FAQUtils.getCurrentUser());
        }
        moderator.addValidator(MandatoryValidator.class, new Object[0]);
        inputset.addUIFormInput((UIFormInput)moderator);
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        String[] files = new String[]{FIELD_USERPRIVATE_INPUT, FIELD_MODERATOR_INPUT};
        for (int i = 0; i < files.length; ++i) {
            int j = 0;
            ArrayList<UIFormInputWithActions.ActionData> actionData = new ArrayList<UIFormInputWithActions.ActionData>();
            for (String string : strings) {
                UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
                ad.setActionName(string);
                if (j == 0) {
                    ad.setActionListener("AddValuesUser");
                } else {
                    ad.setActionListener("SelectPermission");
                }
                ad.setActionType(0);
                ad.setCssIconClass(string + "Icon");
                ad.setActionParameter(files[i] + "," + String.valueOf(j));
                actionData.add(ad);
                ++j;
            }
            inputset.setActionField(files[i], actionData);
        }
        this.addChild((UIComponent)inputset);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getParentId() {
        return this.parentId_;
    }

    public void setParentId(String s) {
        this.parentId_ = FAQUtils.isFieldEmpty((String)s) ? Utils.CATEGORY_HOME : s;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        try {
            UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
            String oldValue = (String)fieldInput.getValue();
            oldValue = oldValue != null && oldValue.trim().length() > 0 ? oldValue + "," + value : value;
            fieldInput.setValue((Object)oldValue);
        }
        catch (ClassCastException ex) {
            UIFormStringInput fieldInput = this.getUIStringInput(selectField);
            String oldValue = (String)fieldInput.getValue();
            oldValue = oldValue != null && oldValue.trim().length() > 0 ? oldValue + "," + value : value;
            fieldInput.setValue((Object)oldValue);
        }
    }

    public void setCategoryValue(Category cat, boolean isUpdate) throws Exception {
        if (isUpdate) {
            isAddNew_ = false;
            this.categoryId_ = cat.getPath();
            this.currentCategory_ = cat;
            this.oldName_ = cat.getName();
            if (this.oldName_ != null && this.oldName_.trim().length() > 0) {
                this.getUIStringInput(FIELD_NAME_INPUT).setValue((Object)this.oldName_);
            } else {
                this.getUIStringInput(FIELD_NAME_INPUT).setValue((Object)"Root");
            }
            String userPrivate = null;
            if (cat.getUserPrivate() != null) {
                for (String str : cat.getUserPrivate()) {
                    userPrivate = userPrivate != null ? userPrivate + ", " + str : str;
                }
            }
            this.getUIFormTextAreaInput(FIELD_USERPRIVATE_INPUT).setDefaultValue(userPrivate);
            this.getUIStringInput(FIELD_INDEX_INPUT).setValue((Object)String.valueOf(cat.getIndex()));
            this.getUIFormTextAreaInput(FIELD_DESCRIPTION_INPUT).setDefaultValue((Object)cat.getDescription());
            this.getUIFormCheckBoxInput(FIELD_MODERATEQUESTIONS_CHECKBOX).setChecked(cat.isModerateQuestions());
            this.getUIFormCheckBoxInput(FIELD_MODERATE_ANSWERS_CHECKBOX).setChecked(cat.isModerateAnswers());
            this.getUIFormCheckBoxInput(VIEW_AUTHOR_INFOR).setChecked(cat.isViewAuthorInfor());
            String moderator = "";
            if (cat.getModerators() != null && cat.getModerators().length > 0) {
                for (String str : cat.getModerators()) {
                    if (moderator != null && moderator.trim().length() > 0) {
                        moderator = moderator + ",";
                    }
                    moderator = moderator + str;
                }
            }
            if (moderator.trim().length() > 0) {
                this.getUIStringInput(FIELD_MODERATOR_INPUT).setValue((Object)moderator);
            } else {
                this.getUIStringInput(FIELD_MODERATOR_INPUT).setValue((Object)FAQUtils.getCurrentUser());
            }
        }
    }

    public String cutColonCaret(String name) {
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ':' || c == '/') continue;
            string.append(c);
        }
        return string.toString();
    }

    private String getUserSelect(String vls, String values) throws Exception {
        if (!FAQUtils.isFieldEmpty((String)vls)) {
            values = values + "," + vls;
            ArrayList<String> list = new ArrayList<String>();
            for (String string : Arrays.asList(values.split(","))) {
                if (list.contains(string) || string.trim().length() <= 0) continue;
                list.add(string);
            }
            values = ((Object)list).toString().replace("[", "").replace("]", "").replaceAll(", ", ",");
        }
        return values;
    }

    static /* synthetic */ boolean access$000() {
        return isAddNew_;
    }

    static /* synthetic */ String access$100(UICategoryForm x0) {
        return x0.parentId_;
    }

    static /* synthetic */ FAQService access$200() {
        return faqService_;
    }

    static /* synthetic */ String access$300(UICategoryForm x0) {
        return x0.oldName_;
    }

    static /* synthetic */ long access$402(long x0) {
        maxIndex = x0;
        return maxIndex;
    }

    static /* synthetic */ long access$400() {
        return maxIndex;
    }

    static /* synthetic */ Category access$500(UICategoryForm x0) {
        return x0.currentCategory_;
    }

    static /* synthetic */ String access$600(UICategoryForm x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ String access$700(UICategoryForm x0, String x1, String x2) throws Exception {
        return x0.getUserSelect(x1, x2);
    }

    static {
        isAddNew_ = true;
        maxIndex = 1L;
    }
}

