/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.faq.webui.popup.UIQuestionForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIQuestionForm.gtmpl", events={@EventConfig(listeners={SelectLanguageActionListener.class}), @EventConfig(listeners={DeleteLanguageActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class})})
public class UIQuestionForm
extends UIForm
implements UIPopupComponent {
    private static Log log = ExoLogger.getLogger(UIQuestionForm.class);
    public static final String AUTHOR = "Author";
    public static final String EMAIL_ADDRESS = "EmailAddress";
    public static final String QUESTION_CONTENT = "QuestionTitle";
    public static final String ALL_LANGUAGES = "AllLanguages";
    public static final String QUESTION_DETAIL = "Question";
    public static final String ATTACHMENTS = "Attachment";
    public static final String FILE_ATTACHMENTS = "FileAttach";
    public static final String REMOVE_FILE_ATTACH = "RemoveFile";
    public static final String IS_APPROVED = "IsApproved";
    public static final String IS_ACTIVATED = "IsActivated";
    private UIFormStringInput inputAuthor = null;
    private UIFormStringInput inputEmailAddress = null;
    private UIFormStringInput inputQuestionContent = null;
    private UIFormWYSIWYGInput inputQuestionDetail = null;
    private UIFormSelectBox selectLanguage = null;
    private UIFormCheckBoxInput<Boolean> inputIsApproved = null;
    private UIFormCheckBoxInput<Boolean> inputIsActivated = null;
    private UIFormInputWithActions inputAttachcment = null;
    private static FAQService fAQService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private static Question question_ = null;
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_;
    private List<SelectItemOption<String>> listSystemLanguages = new ArrayList();
    private List<FileAttachment> listFileAttach_ = new ArrayList();
    private Map<String, QuestionLanguage> mapLanguage = new HashMap();
    private String categoryId_ = "";
    private String questionId_ = null;
    private String defaultLanguage_ = "";
    private String lastLanguage_ = "";
    private String link_ = "";
    private String author_ = "";
    private String email_ = "";
    private List<String> questionContents_ = new ArrayList();
    private boolean isApproved_ = true;
    private boolean isActivated_ = true;
    private boolean isMode = false;
    private boolean isChildOfManager = false;
    private boolean isModerate = false;
    private boolean isAddCheckBox = false;
    private Locale currentLocale = null;
    private FAQSetting faqSetting_;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    public UIQuestionForm() throws Exception {
        this.listFileAttach_.clear();
        this.mapLanguage.clear();
        this.questionContents_.clear();
        this.listFileAttach_ = new ArrayList();
        this.actionField_ = new HashMap();
        this.questionId_ = new String();
        question_ = null;
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void refresh() throws Exception {
        this.listFileAttach_.clear();
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    public void setLanguages() throws Exception {
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        if (this.currentLocale == null || !this.currentLocale.getLanguage().equals(currentLocale.getLanguage())) {
            this.currentLocale = currentLocale;
            this.setListSystemLanguages();
        }
    }

    private void setListSystemLanguages() throws Exception {
        try {
            this.listSystemLanguages.clear();
            LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
            for (LocaleConfig localeConfig : localeConfigService.getLocalConfigs()) {
                String lang = localeConfig.getLocale().getDisplayLanguage();
                String displyByLocal = this.capitalizeFirstLetter(localeConfig.getLocale().getDisplayLanguage(this.currentLocale));
                if (lang.equals(this.defaultLanguage_)) {
                    this.listSystemLanguages.add(new SelectItemOption(displyByLocal + " (" + this.getLabel("default") + ") ", (Object)lang));
                    continue;
                }
                this.listSystemLanguages.add(new SelectItemOption(displyByLocal, (Object)lang));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initPage(boolean isEdit) throws Exception {
        this.setLanguages();
        this.inputAuthor = new UIFormStringInput(AUTHOR, AUTHOR, this.author_);
        if (this.author_.trim().length() > 0) {
            this.inputAuthor.setEditable(false);
        }
        this.inputEmailAddress = new UIFormStringInput(EMAIL_ADDRESS, EMAIL_ADDRESS, this.email_);
        this.inputQuestionContent = new UIFormStringInput(QUESTION_CONTENT, QUESTION_CONTENT, null);
        this.selectLanguage = new UIFormSelectBox(ALL_LANGUAGES, ALL_LANGUAGES, this.listSystemLanguages);
        if (this.defaultLanguage_ != null || this.defaultLanguage_.trim().length() > 0) {
            this.selectLanguage.setSelectedValues(new String[]{this.defaultLanguage_});
        }
        this.selectLanguage.setOnChange("SelectLanguage");
        this.inputIsApproved = new UIFormCheckBoxInput(IS_APPROVED, IS_APPROVED, (Object)false);
        this.inputIsActivated = new UIFormCheckBoxInput(IS_ACTIVATED, IS_ACTIVATED, (Object)false);
        this.inputAttachcment = new UIFormInputWithActions(ATTACHMENTS);
        this.inputAttachcment.addUIFormInput((UIFormInput)new UIFormInputInfo(FILE_ATTACHMENTS, FILE_ATTACHMENTS, null));
        try {
            this.inputAttachcment.setActionField(FILE_ATTACHMENTS, this.getActionList());
        }
        catch (Exception e) {
            log.error((Object)"Failed to set attachment into component UIFormInputInfo.", (Throwable)e);
        }
        this.inputQuestionDetail = new UIFormWYSIWYGInput(QUESTION_DETAIL, QUESTION_DETAIL, "");
        if (!this.questionContents_.isEmpty()) {
            String input = (String)this.questionContents_.get(0);
            if (input != null && input.indexOf("<p>") >= 0 && input.indexOf("</p>") >= 0) {
                input = input.replace("<p>", "");
                input = input.substring(0, input.lastIndexOf("</p>") - 1);
            }
            this.inputQuestionDetail.setValue((Object)input);
        }
        this.addChild((UIComponent)this.inputQuestionContent);
        this.addChild((UIComponent)this.inputQuestionDetail);
        this.addChild((UIComponent)this.selectLanguage);
        this.addChild((UIComponent)this.inputAuthor);
        this.addChild((UIComponent)this.inputEmailAddress);
        this.isModerate = fAQService_.isModerateQuestion(this.getCategoryId());
        this.isAddCheckBox = false;
        if (this.getIsModerator()) {
            if (this.questionId_ != null && this.questionId_.trim().length() > 0) {
                this.addChild((UIComponent)this.inputIsApproved.setChecked(this.isApproved_));
                this.addChild((UIComponent)this.inputIsActivated.setChecked(this.isActivated_));
                this.isAddCheckBox = true;
            } else if (this.isModerate) {
                this.addChild((UIComponent)this.inputIsApproved.setChecked(false));
                this.addChild((UIComponent)this.inputIsActivated.setChecked(true));
                this.isAddCheckBox = true;
            }
        }
        this.addUIFormInput((UIFormInputSet)this.inputAttachcment);
        if (question_ != null && !isEdit) {
            this.setListFileAttach(question_.getAttachMent());
            try {
                this.refreshUploadFileList();
            }
            catch (Exception e) {
                log.error((Object)"Failed to refresh file upload list.", (Throwable)e);
            }
        }
    }

    private boolean getIsModerator() throws Exception {
        try {
            if (this.isMode || this.faqSetting_.isAdmin()) {
                this.isMode = true;
            } else if (question_ != null && fAQService_.isCategoryModerator(question_.getPath(), FAQUtils.getCurrentUser())) {
                this.isMode = true;
            }
            return this.isMode;
        }
        catch (Exception e) {
            log.error((Object)"Failed to check user is moderator.", (Throwable)e);
            return false;
        }
    }

    public void setIsChildOfManager(boolean isChild) {
        this.isChildOfManager = isChild;
        this.removeChildById(AUTHOR);
        this.removeChildById(EMAIL_ADDRESS);
        this.removeChildById(QUESTION_CONTENT);
        this.removeChildById(QUESTION_DETAIL);
        this.removeChildById(ATTACHMENTS);
        this.removeChildById(IS_APPROVED);
        this.removeChildById(IS_ACTIVATED);
        this.removeChildById(ALL_LANGUAGES);
        this.listFileAttach_.clear();
        this.mapLanguage.clear();
    }

    public void setQuestion(Question question) throws Exception {
        List questionLanguages = new ArrayList();
        this.questionId_ = question.getPath();
        this.categoryId_ = "";
        try {
            question_ = question;
            this.lastLanguage_ = this.defaultLanguage_ = question_.getLanguage();
            questionLanguages = fAQService_.getQuestionLanguages(this.questionId_);
            for (QuestionLanguage questionLanguage : questionLanguages) {
                this.mapLanguage.put(questionLanguage.getLanguage(), questionLanguage);
            }
            this.isApproved_ = question_.isApproved();
            this.isActivated_ = question_.isActivated();
            this.initPage(false);
            UIFormStringInput authorQ = (UIFormStringInput)this.getChildById(AUTHOR);
            authorQ.setValue((Object)question_.getAuthor());
            UIFormStringInput emailQ = (UIFormStringInput)this.getChildById(EMAIL_ADDRESS);
            emailQ.setValue((Object)question_.getEmail());
            this.inputQuestionContent.setValue((Object)question.getQuestion());
            this.inputQuestionDetail.setValue((Object)question_.getDetail());
        }
        catch (Exception e) {
            log.error((Object)"Failed to set editing question.", (Throwable)e);
            this.initPage(false);
        }
    }

    public boolean isMode() {
        return this.isMode;
    }

    public void setIsMode(boolean isMode) {
        this.isMode = isMode;
    }

    public String getQuestionId() {
        return this.questionId_;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage_ = defaultLanguage;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage_;
    }

    private String getAuthor() {
        return this.author_;
    }

    public void setAuthor(String author) {
        this.author_ = author;
    }

    private String getEmail() {
        return this.email_;
    }

    public void setEmail(String email) {
        this.email_ = email;
    }

    private String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.categoryId_ = FAQUtils.isFieldEmpty((String)categoryId) ? Utils.CATEGORY_HOME : categoryId;
        this.questionId_ = null;
        this.lastLanguage_ = this.defaultLanguage_ = FAQUtils.getDefaultLanguage();
        this.initPage(false);
    }

    protected UIForm getParentForm() {
        return (UIForm)this.getParent();
    }

    public List<UIFormInputWithActions.ActionData> getActionList() {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (FileAttachment attachdata : this.listFileAttach_) {
            UIFormInputWithActions.ActionData uploadAction = new UIFormInputWithActions.ActionData();
            uploadAction.setActionListener("Download");
            uploadAction.setActionParameter(attachdata.getPath());
            uploadAction.setActionType(0);
            uploadAction.setCssIconClass("AttachmentIcon");
            uploadAction.setActionName(attachdata.getName() + " (" + attachdata.getSize() + " B)");
            uploadAction.setShowLabel(true);
            uploadedFiles.add(uploadAction);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(REMOVE_FILE_ATTACH);
            removeAction.setActionParameter(attachdata.getPath());
            removeAction.setCssIconClass("LabelLink");
            removeAction.setActionType(1);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void setListFileAttach(List<FileAttachment> listFileAttachment) {
        this.listFileAttach_.addAll(listFileAttachment);
    }

    public void setListFileAttach(FileAttachment fileAttachment) {
        this.listFileAttach_.add(fileAttachment);
    }

    private List<FileAttachment> getListFile() {
        return this.listFileAttach_;
    }

    public void refreshUploadFileList() throws Exception {
        ((UIFormInputWithActions)this.getChildById(ATTACHMENTS)).setActionField(FILE_ATTACHMENTS, this.getActionList());
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) throws Exception {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    static /* synthetic */ UIFormSelectBox access$000(UIQuestionForm x0) {
        return x0.selectLanguage;
    }

    static /* synthetic */ UIFormWYSIWYGInput access$100(UIQuestionForm x0) {
        return x0.inputQuestionDetail;
    }

    static /* synthetic */ UIFormStringInput access$200(UIQuestionForm x0) {
        return x0.inputQuestionContent;
    }

    static /* synthetic */ String access$300(UIQuestionForm x0) {
        return x0.lastLanguage_;
    }

    static /* synthetic */ Map access$400(UIQuestionForm x0) {
        return x0.mapLanguage;
    }

    static /* synthetic */ String access$302(UIQuestionForm x0, String x1) {
        x0.lastLanguage_ = x1;
        return x0.lastLanguage_;
    }

    static /* synthetic */ UIFormStringInput access$500(UIQuestionForm x0) {
        return x0.inputAuthor;
    }

    static /* synthetic */ UIFormStringInput access$600(UIQuestionForm x0) {
        return x0.inputEmailAddress;
    }

    static /* synthetic */ String access$700(UIQuestionForm x0) {
        return x0.defaultLanguage_;
    }

    static /* synthetic */ String access$800(UIQuestionForm x0) {
        return x0.questionId_;
    }

    static /* synthetic */ Question access$902(Question x0) {
        question_ = x0;
        return question_;
    }

    static /* synthetic */ String access$1000(UIQuestionForm x0) {
        return x0.getCategoryId();
    }

    static /* synthetic */ Question access$900() {
        return question_;
    }

    static /* synthetic */ boolean access$1100(UIQuestionForm x0) {
        return x0.isModerate;
    }

    static /* synthetic */ boolean access$1200(UIQuestionForm x0) {
        return x0.isAddCheckBox;
    }

    static /* synthetic */ List access$1300(UIQuestionForm x0) {
        return x0.listFileAttach_;
    }

    static /* synthetic */ FAQSetting access$1400(UIQuestionForm x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ Log access$1500() {
        return log;
    }

    static /* synthetic */ FAQService access$1600() {
        return fAQService_;
    }

    static /* synthetic */ boolean access$1700(UIQuestionForm x0) {
        return x0.isMode;
    }

    static /* synthetic */ boolean access$1800(UIQuestionForm x0) {
        return x0.isChildOfManager;
    }
}

