/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UICommentForm;
import org.exoplatform.faq.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UICommentForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UICommentForm
extends UIForm
implements UIPopupComponent {
    private String languageSelected;
    private Question question_;
    private Comment comment;
    private String questionContent;
    private String questionDetail;
    private String currentUser_ = FAQUtils.getCurrentUser();
    private final String TITLE_USERNAME = "UserName";
    private final String COMMENT_CONTENT = "CommentContent";
    private boolean isAddNew = false;
    private boolean isNotDefLg = false;
    private FAQSetting faqSetting_;
    private String link_ = "";

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public UICommentForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput("UserName", "UserName", this.currentUser_).setEditable(false));
        this.addChild((UIComponent)new UIFormWYSIWYGInput("CommentContent", "CommentContent", ""));
    }

    public String getQuestionContent() {
        return this.questionContent;
    }

    public String getQuestionDetail() {
        return this.questionDetail;
    }

    public void setInfor(Question question, String commentId, FAQSetting faqSetting, String language) throws Exception {
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        if (!language.equals(question.getLanguage())) {
            try {
                QuestionLanguage questionLanguage = faqService.getQuestionLanguageByLanguage(question.getPath(), language);
                this.questionContent = questionLanguage.getQuestion();
                this.questionDetail = questionLanguage.getDetail();
                this.languageSelected = language;
            }
            catch (Exception e) {
                this.questionContent = question.getQuestion();
                this.questionDetail = question.getDetail();
                this.languageSelected = question.getLanguage();
            }
        } else {
            this.questionContent = question.getQuestion();
            this.questionDetail = question.getDetail();
            this.languageSelected = question.getLanguage();
        }
        this.question_ = question;
        this.faqSetting_ = faqSetting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        if (commentId.indexOf("new") < 0) {
            this.isAddNew = true;
            this.comment = faqService.getCommentById(question.getPath(), commentId, language);
            ((UIFormWYSIWYGInput)this.getChildById("CommentContent")).setValue((Object)this.comment.getComments());
        }
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public String getLink() {
        return this.link_;
    }

    static /* synthetic */ Question access$000(UICommentForm x0) {
        return x0.question_;
    }

    static /* synthetic */ Comment access$100(UICommentForm x0) {
        return x0.comment;
    }

    static /* synthetic */ Comment access$102(UICommentForm x0, Comment x1) {
        x0.comment = x1;
        return x0.comment;
    }

    static /* synthetic */ boolean access$200(UICommentForm x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$300(UICommentForm x0) {
        return x0.currentUser_;
    }

    static /* synthetic */ String access$400(UICommentForm x0) {
        return x0.languageSelected;
    }
}

