/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UICategories.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={EditSubCategoryActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={MoveCategoryActionListener.class}), @EventConfig(listeners={WatchActionListener.class}), @EventConfig(listeners={WatchManagerActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ChangeIndexActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={FilterQuestionsActionListener.class}), @EventConfig(listeners={MoveCategoryIntoActionListener.class})})
public class UICategories
extends UIContainer {
    private String FILTER_QUESTIONS = "allQuestions";
    private String FILTER_OPEN_QUESTIONS = "openQuestions";
    private String FILTER_PENDING_QUESTIONS = "pendingQuestions";
    public String parentCateID_ = null;
    private String categoryId_;
    private boolean isSwap = false;
    private String currentCategoryName = "";
    private boolean viewBackIcon = false;
    private List<Category> listCate = new ArrayList();
    Map<String, Boolean> categoryMod = new HashMap();
    private boolean isModerator = false;
    private FAQSetting faqSetting_ = new FAQSetting();
    private String[] firstActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] firstActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] secondActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] secondActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditSubCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] userActionsCateUnWatch_ = new String[]{"AddNewQuestion", "UnWatch"};
    FAQService faqService_;
    private String portalName = null;
    private String currentUser = null;
    String[] font_weight = new String[]{"bold", "none", "none"};

    public UICategories() throws Exception {
        this.portalName = this.getPortalName();
        this.currentUser = FAQUtils.getCurrentUser();
    }

    public void setFAQService(FAQService service) {
        this.faqService_ = service;
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    private long[] getCategoryInfo() {
        long[] result = new long[]{0L, 0L, 0L, 0L};
        try {
            result = this.faqService_.getCategoryInfo(this.categoryId_, this.faqSetting_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Category> getListCate() {
        return this.listCate;
    }

    public String getCategoryPath() {
        return this.categoryId_;
    }

    public void setPathCategory(String categoryPath) {
        this.categoryId_ = categoryPath;
        this.parentCateID_ = categoryPath.indexOf("/") >= 0 ? categoryPath.substring(0, categoryPath.lastIndexOf("/")) : categoryPath;
        this.font_weight = new String[]{"bold", "none", "none"};
    }

    private void setIsModerators(String currentUser_) throws Exception {
        this.categoryMod.clear();
        this.isModerator = false;
        if (this.faqSetting_.isAdmin()) {
            this.isModerator = true;
        }
        if (!this.isModerator) {
            this.isModerator = this.faqService_.isCategoryModerator(this.categoryId_, currentUser_);
        }
        if (!this.isModerator) {
            for (Category cat : this.listCate) {
                this.categoryMod.put(cat.getId(), this.faqService_.isCategoryModerator(cat.getPath(), currentUser_));
            }
        }
    }

    private boolean isCategoryModerator(String path) throws Exception {
        if (this.faqSetting_.isAdmin()) {
            return true;
        }
        if (!FAQUtils.isFieldEmpty((String)this.categoryId_) && path.indexOf(this.categoryId_) >= 0 && this.isModerator) {
            return true;
        }
        String categoryId = path;
        if (categoryId.indexOf("/") > 0) {
            categoryId = categoryId.substring(categoryId.lastIndexOf("/") + 1);
        }
        if (this.categoryMod.containsKey(categoryId)) {
            return (Boolean)this.categoryMod.get(categoryId);
        }
        boolean isMod = this.faqService_.isCategoryModerator(path, this.currentUser);
        this.categoryMod.put(categoryId, isMod);
        return isMod;
    }

    public String getCurrentName() {
        return this.currentCategoryName;
    }

    private boolean isWatched(String cateId) {
        return this.faqService_.isUserWatched(this.currentUser, cateId);
    }

    private void setListCate() throws Exception {
        if (!this.isSwap) {
            List newList = new ArrayList();
            String userName = FAQUtils.getCurrentUser();
            try {
                newList = this.faqSetting_.isAdmin() ? this.faqService_.getSubCategories(this.categoryId_, this.faqSetting_, true, null) : this.faqService_.getSubCategories(this.categoryId_, this.faqSetting_, false, UserHelper.getAllGroupAndMembershipOfUser((String)userName));
                if (this.categoryId_.equals("categories")) {
                    this.currentCategoryName = this.faqService_.getCategoryById(this.categoryId_).getName();
                    this.currentCategoryName = "<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + this.currentCategoryName + "\"/>";
                } else {
                    this.currentCategoryName = this.faqService_.getCategoryById(this.categoryId_).getName();
                }
            }
            catch (Exception e) {
                if (this.parentCateID_.equals("categories")) {
                    this.currentCategoryName = this.faqService_.getCategoryById(this.parentCateID_).getName();
                    this.currentCategoryName = "<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + this.currentCategoryName + "\"/>";
                } else {
                    this.currentCategoryName = this.faqService_.getCategoryById(this.parentCateID_).getName();
                }
                e.printStackTrace();
            }
            this.viewBackIcon = true;
            if (newList.isEmpty()) {
                newList = this.faqSetting_.isAdmin() ? this.faqService_.getSubCategories(this.parentCateID_, this.faqSetting_, true, null) : this.faqService_.getSubCategories(this.parentCateID_, this.faqSetting_, false, UserHelper.getAllGroupAndMembershipOfUser((String)userName));
                this.viewBackIcon = false;
            }
            if (this.currentCategoryName == null || this.currentCategoryName.trim().length() < 1) {
                this.currentCategoryName = FAQUtils.getResourceBundle((String)"UIBreadcumbs.label.categories");
            }
            UIBreadcumbs breadcumbs = (UIBreadcumbs)((UIAnswersContainer)this.getAncestorOfType(UIAnswersContainer.class)).getChild(UIBreadcumbs.class);
            this.listCate.clear();
            this.listCate.addAll(newList);
            String[] listId = breadcumbs.getPath(breadcumbs.getBreadcumbs().size() - 1).split("/");
            this.setIsModerators(userName);
        }
        this.isSwap = false;
    }

    public String getRSSLink(String cateId) {
        return RSS.getRSSLink((String)"faq", (String)this.portalName, (String)cateId);
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public void resetListCate() throws Exception {
        this.isSwap = true;
        this.listCate.clear();
        String userName = FAQUtils.getCurrentUser();
        if (this.faqSetting_.isAdmin()) {
            this.listCate.addAll(this.faqService_.getSubCategories(this.parentCateID_, this.faqSetting_, true, null));
        } else {
            this.listCate.addAll(this.faqService_.getSubCategories(this.parentCateID_, this.faqSetting_, false, UserHelper.getAllGroupAndMembershipOfUser((String)userName)));
        }
        this.setIsModerators(userName);
    }

    private boolean hasWatch(String categoryPath) {
        return this.faqService_.hasWatch(categoryPath);
    }

    private String[] getActionCategory(String cateId) {
        if (this.categoryId_ == null) {
            if (this.isWatched(cateId)) {
                return this.firstActionCateUnWatch_;
            }
            return this.firstActionCate_;
        }
        if (this.isWatched(cateId)) {
            return this.secondActionCateUnWatch_;
        }
        return this.secondActionCate_;
    }

    private String[] getActionCategoryWithUser(String cateId) {
        try {
            if (FAQUtils.getCurrentUser() != null) {
                if (this.isWatched(cateId)) {
                    return this.userActionsCateUnWatch_;
                }
                return this.userActionsCate_;
            }
            return new String[]{this.userActionsCate_[0]};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[]{this.userActionsCate_[0]};
        }
    }

    static /* synthetic */ FAQSetting access$000(UICategories x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ String access$100(UICategories x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ String access$200(UICategories x0) {
        return x0.FILTER_OPEN_QUESTIONS;
    }

    static /* synthetic */ String access$300(UICategories x0) {
        return x0.FILTER_PENDING_QUESTIONS;
    }
}

