/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.rendering.RenderHelper;
import org.exoplatform.faq.rendering.RenderingException;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIAnswersPageIterator;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/faq/webui/UIQuestions.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={ChangeStatusAnswerActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={SettingActionListener.class}), @EventConfig(listeners={QuestionManagamentActionListener.class}), @EventConfig(listeners={ViewQuestionActionListener.class}), @EventConfig(listeners={OpenQuestionActionListener.class}), @EventConfig(listeners={CloseQuestionActionListener.class}), @EventConfig(listeners={ViewUserProfileActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class}), @EventConfig(listeners={EditAnswerActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={MoveQuestionActionListener.class}), @EventConfig(listeners={SendQuestionActionListener.class}), @EventConfig(listeners={CommentQuestionActionListener.class}), @EventConfig(listeners={DeleteCommentActionListener.class}, confirm="UIQuestions.msg.confirm-delete-comment"), @EventConfig(listeners={DeleteAnswerActionListener.class}, confirm="UIQuestions.msg.confirm-delete-answer"), @EventConfig(listeners={UnVoteQuestionActionListener.class}, confirm="UIQuestions.msg.confirm-unvote-question"), @EventConfig(listeners={CommentToAnswerActionListener.class}), @EventConfig(listeners={VoteQuestionActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={SortAnswerActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={VoteAnswerActionListener.class}), @EventConfig(listeners={PrintAllQuestionActionListener.class}), @EventConfig(listeners={DiscussForumActionListener.class})})
public class UIQuestions
extends UIContainer {
    private static String SEARCH_INPUT = "SearchInput";
    private static String COMMENT_ITER = "CommentIter";
    private static String ANSWER_ITER = "AnswerIter";
    public static final String OBJECT_ITERATOR = "object_iter";
    private FAQSetting faqSetting_ = null;
    private Map<String, Question> questionMap_ = new LinkedHashMap();
    public JCRPageList pageList;
    private boolean canEditQuestion = false;
    private Boolean isSortAnswerUp = null;
    public String categoryId_ = null;
    public String viewingQuestionId_ = "";
    private String currentUser_ = "";
    private String link_ = "";
    private FAQService faqService_ = null;
    private Map<String, QuestionLanguage> languageMap = new HashMap();
    public boolean isChangeLanguage = false;
    public List<String> listLanguage = new ArrayList();
    public String backPath_ = null;
    private String language_ = FAQUtils.getDefaultLanguage();
    private String discussId = "";
    private String[] firstTollbar_ = new String[]{"AddNewQuestion", "QuestionManagament"};
    private String[] menuCateManager = new String[]{"EditCategory", "AddCategory", "DeleteCategory", "Export", "Import"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] moderatorActionQues_ = new String[]{"CommentQuestion", "ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] moderatorActionQues2_ = new String[]{"ResponseQuestion", "EditQuestion", "DeleteQuestion", "MoveQuestion", "SendQuestion"};
    private String[] userActionQues_ = new String[]{"CommentQuestion", "SendQuestion"};
    private String[] userActionQues2_ = new String[]{"SendQuestion"};
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    public boolean viewAuthorInfor = false;
    private RenderHelper renderHelper = new RenderHelper();
    public UIAnswersPageIterator pageIterator = null;
    public long pageSelect = 0L;

    public UIQuestions() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.addChild(UIAnswersPageIterator.class, null, OBJECT_ITERATOR);
        if (this.faqService_ == null) {
            this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        }
        if (FAQUtils.isFieldEmpty((String)this.getId())) {
            this.setId("UIQuestions");
        }
    }

    public String getRSSLink() {
        return RSS.getRSSLink((String)"faq", (String)this.getPortalName(), (String)this.categoryId_);
    }

    private String getLinkDiscuss(String topicId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String link = "";
        try {
            String nodePath = portalContext.getNodePath();
            List values = this.calculateUrlDisscuss();
            link = this.getLink().replaceAll(nodePath.substring(nodePath.indexOf("/") + 1), (String)values.get(0));
            String key = link.substring(link.indexOf("=") + 1, link.indexOf("&amp;"));
            link = link.replaceFirst(key, (String)values.get(1));
            link = FAQUtils.getLink((String)link, (String)this.getId(), (String)"UIBreadcumbs", (String)"Setting", (String)"ChangePath", (String)topicId);
        }
        catch (Exception e) {
            e.printStackTrace();
            link = portalContext.getRequest().getRequestURL().toString();
        }
        return link;
    }

    private List<String> calculateUrlDisscuss() throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        List navigations = new ArrayList();
        navigations = Util.getUIPortal().getNavigations();
        DataStorage dataStorage = (DataStorage)PortalContainer.getInstance().getComponentInstanceOfType(DataStorage.class);
        for (PageNavigation nav : navigations) {
            for (PageNode pageNode : nav.getNodes()) {
                if (pageNode.getPageReference() == null) continue;
                Page page = dataStorage.getPage(pageNode.getPageReference());
                ArrayList children2 = page.getChildren();
                for (ModelObject modelObject : children2) {
                    if (!(modelObject instanceof Application)) continue;
                }
            }
        }
        return values;
    }

    private String convertLinkToForum(String s) {
        s = s.replaceAll("answers", "forum").replaceFirst(this.getId(), "UIBreadcumbs").replaceFirst("DiscussForum", "ChangePath").replaceAll("amp;", "");
        return s;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private boolean isDiscussForum() throws Exception {
        FAQSetting faqSetting = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)faqSetting);
        return faqSetting.getIsDiscussForum();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public void setListObject() throws Exception {
        try {
            if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
                this.faqSetting_.setCurrentUser(this.currentUser_);
                if (this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    this.faqSetting_.setCanEdit(true);
                } else if (this.categoryId_ != null && this.categoryId_.trim().length() > 0) {
                    try {
                        if (Arrays.asList(this.faqService_.getCategoryById(this.categoryId_).getModerators()).contains(this.currentUser_)) {
                            this.faqSetting_.setCanEdit(true);
                        }
                    }
                    catch (Exception e) {}
                } else {
                    this.faqSetting_.setCanEdit(false);
                }
            }
            String objectId = null;
            if (this.pageList != null) {
                objectId = this.pageList.getObjectId();
            }
            this.pageList = this.faqService_.getQuestionsByCatetory(this.categoryId_, this.faqSetting_);
            this.pageList.setPageSize(10L);
            if (objectId != null && objectId.trim().length() > 0) {
                this.pageList.setObjectId(objectId);
            }
            this.pageIterator = (UIAnswersPageIterator)this.getChildById(OBJECT_ITERATOR);
            this.pageIterator.updatePageList(this.pageList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Answer[] getPageListAnswer(String questionId) throws Exception {
        if (this.isSortAnswerUp != null) {
            Answer[] answers = ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
            for (int i = 0; i < answers.length - 1; ++i) {
                for (int j = i + 1; j < answers.length; ++j) {
                    Answer temp;
                    if (this.isSortAnswerUp.booleanValue()) {
                        if (answers[j].getMarkVotes() >= answers[i].getMarkVotes()) continue;
                        temp = answers[i];
                        answers[i] = answers[j];
                        answers[j] = temp;
                        continue;
                    }
                    if (answers[j].getMarkVotes() <= answers[i].getMarkVotes()) continue;
                    temp = answers[i];
                    answers[i] = answers[j];
                    answers[j] = temp;
                }
            }
            return answers;
        }
        return ((QuestionLanguage)this.languageMap.get(this.language_)).getAnswers();
    }

    private Comment[] getPageListComment(String questionId) throws Exception {
        return ((QuestionLanguage)this.languageMap.get(this.language_)).getComments();
    }

    private String[] getActionTollbar() {
        return this.firstTollbar_;
    }

    private String[] getMenuCateManager() {
        return this.menuCateManager;
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    private String[] getActionCategoryWithUser() {
        if (this.currentUser_ != null) {
            return this.userActionsCate_;
        }
        if (this.faqSetting_.isEnableAutomaticRSS()) {
            return new String[]{this.userActionsCate_[0], "RSSFAQ"};
        }
        return new String[]{this.userActionsCate_[0]};
    }

    private String[] getActionQuestion() {
        if (this.canEditQuestion) {
            if (!this.faqSetting_.isEnanbleVotesAndComments()) {
                return this.moderatorActionQues2_;
            }
            return this.moderatorActionQues_;
        }
        if (!this.faqSetting_.isEnanbleVotesAndComments()) {
            return this.userActionQues2_;
        }
        if (this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    public void updateCurrentQuestionList() throws Exception {
        this.questionMap_.clear();
        this.pageSelect = this.pageIterator.getPageSelected();
        for (Question question : this.pageList.getPage(this.pageSelect, null)) {
            this.questionMap_.put(question.getId(), question);
        }
        this.pageSelect = this.pageList.getCurrentPage();
        this.pageIterator.setSelectPage(this.pageSelect);
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    public void setFAQService(FAQService service) {
        this.faqService_ = service;
    }

    private String[] getActionQuestionWithUser() {
        if (!this.faqSetting_.isEnanbleVotesAndComments() || this.currentUser_ == null || this.currentUser_.trim().length() < 1) {
            return this.userActionQues2_;
        }
        return this.userActionQues_;
    }

    public void setLanguageView(String language) {
        this.language_ = language;
    }

    private String getQuestionContent() {
        if (this.languageMap.containsKey(this.language_)) {
            return ((QuestionLanguage)this.languageMap.get(this.language_)).getQuestion();
        }
        return "";
    }

    private Question getQuestionDetail() {
        Question question = new Question();
        question.setDetail(((QuestionLanguage)this.languageMap.get(this.language_)).getDetail());
        return question;
    }

    private void setIsModerators() throws Exception {
        this.canEditQuestion = this.faqSetting_.isAdmin() || this.faqService_.isCategoryModerator(this.categoryId_, this.currentUser_);
    }

    private boolean canVote(Question question) {
        if (question.getUsersVote() != null) {
            for (String user : question.getUsersVote()) {
                if (!user.contains(this.currentUser_ + "/")) continue;
                return false;
            }
        }
        return true;
    }

    public void setDefaultLanguage() {
        this.language_ = FAQUtils.getDefaultLanguage();
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 500L) {
            String str = residual + "";
            result = size + 1L + " " + this.sizes_[i];
        } else {
            result = size + " " + this.sizes_[i];
        }
        return result;
    }

    private Question[] getListQuestion() {
        try {
            this.updateCurrentQuestionList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.questionMap_.values().toArray(new Question[0]);
    }

    private boolean getCanEditQuestion() {
        return this.canEditQuestion;
    }

    private String getQuestionView() {
        return this.viewingQuestionId_;
    }

    private String[] getQuestionLangauges(String questionPath) {
        return this.languageMap.keySet().toArray(new String[0]);
    }

    private String getAvatarUrl(String userId) {
        try {
            String url = FAQUtils.getFileSource((FileAttachment)this.faqService_.getUserAvatar(userId), null);
            if (FAQUtils.isFieldEmpty((String)url)) {
                url = "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
            }
            return url;
        }
        catch (Exception exception) {
            return "/faq/skin/DefaultSkin/webui/background/Avatar1.gif";
        }
    }

    public String getCategoryId() {
        return this.categoryId_;
    }

    public void setCategoryId(String categoryId) throws Exception {
        this.viewAuthorInfor = this.faqService_.isViewAuthorInfo(categoryId);
        this.categoryId_ = categoryId;
        this.setListObject();
    }

    public void viewQuestion(Question question) throws Exception {
        if (!this.questionMap_.containsKey(question.getLanguage())) {
            List languages = this.faqService_.getQuestionLanguages(question.getPath());
            this.languageMap.clear();
            for (QuestionLanguage lang : languages) {
                this.languageMap.put(lang.getLanguage(), lang);
            }
            if (!this.questionMap_.containsKey(question.getId())) {
                this.questionMap_.put(question.getLanguage(), question);
            }
            this.viewingQuestionId_ = question.getPath();
        }
    }

    public void updateCurrentLanguage() throws Exception {
        if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
            this.languageMap.put(this.language_, this.faqService_.getQuestionLanguageByLanguage(this.viewingQuestionId_, this.language_));
        } else {
            this.languageMap.clear();
        }
    }

    public void updateQuestionLanguageByLanguage(String questionPath, String language) throws Exception {
        this.languageMap.put(language, this.faqService_.getQuestionLanguageByLanguage(questionPath, language));
    }

    public void updateLanguageMap() throws Exception {
        try {
            this.languageMap.clear();
            if (this.viewingQuestionId_ != null && this.viewingQuestionId_.length() > 0) {
                List languages = this.faqService_.getQuestionLanguages(this.viewingQuestionId_);
                for (QuestionLanguage lang : languages) {
                    this.languageMap.put(lang.getLanguage(), lang);
                }
            }
        }
        catch (Exception e) {
            this.viewingQuestionId_ = "";
            e.printStackTrace();
        }
    }

    private String getQuestionRelationById(String questionId) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(questionId);
            return (String)this.faqService_.getQuestionContents(ids).get(0);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getLink() {
        return this.link_;
    }

    private String getBackPath() {
        return this.backPath_;
    }

    public void setPath(String s) {
    }

    private void setLink(String link) {
        this.link_ = link;
    }

    public String render(Object obj) throws RenderingException {
        if (obj instanceof Question) {
            return this.renderHelper.renderQuestion((Question)obj);
        }
        if (obj instanceof Answer) {
            return this.renderHelper.renderAnswer((Answer)obj);
        }
        if (obj instanceof Comment) {
            return this.renderHelper.renderComment((Comment)obj);
        }
        return "";
    }

    private boolean checkQuestionToView(Question question, UIApplication uiApplication, Event<UIQuestions> event) {
        if (!question.isActivated() || !question.isApproved() && this.faqSetting_.getDisplayMode().equals(FAQUtils.DISPLAYAPPROVED)) {
            uiApplication.addMessage(new ApplicationMessage("UIQuestions.msg.question-pending", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getAncestorOfType(UIAnswersContainer.class));
            return true;
        }
        return false;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    static /* synthetic */ FAQSetting access$000(UIQuestions x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ FAQService access$100(UIQuestions x0) {
        return x0.faqService_;
    }

    static /* synthetic */ boolean access$200(UIQuestions x0) {
        return x0.canEditQuestion;
    }

    static /* synthetic */ Boolean access$300(UIQuestions x0) {
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ Boolean access$302(UIQuestions x0, Boolean x1) {
        x0.isSortAnswerUp = x1;
        return x0.isSortAnswerUp;
    }

    static /* synthetic */ String access$400(UIQuestions x0) {
        return x0.language_;
    }

    static /* synthetic */ String access$402(UIQuestions x0, String x1) {
        x0.language_ = x1;
        return x0.language_;
    }

    static /* synthetic */ boolean access$500(UIQuestions x0, Question x1, UIApplication x2, Event x3) {
        return x0.checkQuestionToView(x1, x2, x3);
    }

    static /* synthetic */ Map access$600(UIQuestions x0) {
        return x0.questionMap_;
    }

    static /* synthetic */ String access$700(UIQuestions x0) {
        return x0.getLink();
    }

    static /* synthetic */ Map access$800(UIQuestions x0) {
        return x0.languageMap;
    }

    static /* synthetic */ String access$902(UIQuestions x0, String x1) {
        x0.discussId = x1;
        return x0.discussId;
    }

    static /* synthetic */ String access$1000(UIQuestions x0, String x1) throws Exception {
        return x0.getLinkDiscuss(x1);
    }
}

