/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.BaseUIFAQForm;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.popup.UISendMailForm;
import org.exoplatform.ks.common.EmailNotifyPlugin;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UISendMailForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={ToActionListener.class}), @EventConfig(listeners={CcActionListener.class}), @EventConfig(listeners={BccActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class})})
public class UISendMailForm
extends BaseUIFAQForm
implements UIPopupComponent {
    private boolean isViewCC = false;
    private boolean isViewBCC = false;
    private static final String FILED_FROM_NAME = "FromName";
    private static final String FILED_FROM = "From";
    private static final String FILED_TO = "To";
    private static final String FILED_ADD_CC = "AddCc";
    private static final String FILED_ADD_BCC = "AddBcc";
    private static final String FILED_SUBJECT = "Subject";
    private static final String FILED_QUESTION_LANGUAGE = "Language";
    private static final String FILED_MESSAGE = "Message";
    public static final String FIELD_FROM_INPUT = "fromInput";
    private static final String MIMETYPE_TEXTHTML = "text/html".intern();
    private Map<String, String> serverConfig_ = new HashMap();
    private List<SelectItemOption<String>> listLanguageToReponse = new ArrayList();
    private List<QuestionLanguage> listQuestionLanguage = new ArrayList();
    private String languageIsResponsed = "";
    private String questionChanged_ = new String();
    private String link_ = "";
    public List<User> toUsers = new ArrayList();
    public List<User> addCCUsers = new ArrayList();
    public List<User> addBCCUsers = new ArrayList();
    private int posOfResponse = 0;
    private List<String> listAnotherEmail = new ArrayList();

    public UISendMailForm() throws Exception {
        this.setActions(new String[]{"Send", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLink() {
        return this.link_;
    }

    public void setLink(String link) {
        this.link_ = link;
    }

    public List<User> getToUsers() {
        return this.toUsers;
    }

    public void setToUsers(List<User> userList) {
        this.toUsers = userList;
    }

    public List<User> getAddCCUsers() {
        return this.addCCUsers;
    }

    public void setAddCCUsers(List<User> userList) {
        this.addCCUsers = userList;
    }

    public List<User> getAddBCCUsers() {
        return this.addBCCUsers;
    }

    public void setAddBCCUsers(List<User> userList) {
        this.addBCCUsers = userList;
    }

    private List<SelectItemOption<String>> getListLanguageToSendFriend() {
        return this.listLanguageToReponse;
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            this.serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
        }
        catch (Exception e) {
            this.log.error((Object)("Can not add Plugin Email Norify, exception: " + e.getMessage()));
        }
    }

    public void setUpdateQuestion(String questionPath, String language) throws Exception {
        Question question = FAQUtils.getFAQService().getQuestionById(questionPath);
        if (language.length() <= 0) {
            language = question.getLanguage();
        }
        String email = "";
        String name = "";
        String userName = FAQUtils.getCurrentUser();
        if (!FAQUtils.isFieldEmpty((String)userName)) {
            name = FAQUtils.getFullName((String)userName);
            email = FAQUtils.getEmailUser((String)userName);
        }
        this.languageIsResponsed = question.getLanguage();
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setId(question.getId());
        questionLanguage.setQuestion(question.getQuestion());
        questionLanguage.setDetail(question.getDetail());
        questionLanguage.setLanguage(question.getLanguage());
        questionLanguage.setAnswers(question.getAnswers());
        questionLanguage.setComments(question.getComments());
        this.listQuestionLanguage.add(questionLanguage);
        for (QuestionLanguage questionLanguage2 : this.getFAQService().getQuestionLanguages(questionPath)) {
            String quest2 = questionLanguage2.getDetail().replaceAll("\n", "<br>").replaceAll("'", "&#39;");
            questionLanguage2.setDetail(quest2);
            if (this.isContainLanguageList(this.listQuestionLanguage, questionLanguage2.getLanguage())) continue;
            this.listQuestionLanguage.add(questionLanguage2);
        }
        this.questionChanged_ = question.getQuestion();
        this.listLanguageToReponse.add(new SelectItemOption(language, (Object)language));
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM_NAME, FILED_FROM_NAME, name));
        this.addChild((UIComponent)new UIFormStringInput(FILED_FROM, FILED_FROM, email));
        this.addChild((UIComponent)new UIFormStringInput(FILED_TO, FILED_TO, null));
        this.addChild((UIComponent)new UIFormStringInput(FILED_ADD_CC, FILED_ADD_CC, null));
        this.addChild((UIComponent)new UIFormStringInput(FILED_ADD_BCC, FILED_ADD_BCC, null));
        UIFormSelectBox questionLanguages = new UIFormSelectBox(FILED_QUESTION_LANGUAGE, FILED_QUESTION_LANGUAGE, this.listLanguageToReponse);
        questionLanguages.setSelectedValues(new String[]{language});
        questionLanguages.setOptions(this.listLanguageToReponse);
        questionLanguages.setOnChange("ChangeLanguage");
        this.addChild((UIComponent)questionLanguages);
        String contenQuestion = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (QuestionLanguage questionLangua : this.listQuestionLanguage) {
            if (!questionLangua.getLanguage().equals(language)) continue;
            contenQuestion = questionLangua.getQuestion();
            Answer[] answers = questionLangua.getAnswers();
            stringBuffer.append(this.getLabel("change-content")).append(":<p><b>").append(this.getLabel("Question")).append("</b> ").append(contenQuestion).append("</p>");
            if (questionLangua.getDetail() != null && questionLangua.getDetail().trim().length() > 0) {
                stringBuffer.append("<p><b>").append(this.getLabel("Detail")).append("</b> ").append(questionLangua.getDetail()).append("</p>");
            }
            if (answers != null && answers.length > 0) {
                stringBuffer.append("<p>");
                for (Answer answer : answers) {
                    stringBuffer.append("<br/><b>").append(this.getLabel("Response")).append("</b>").append("<br/>").append(answer.getResponses());
                }
                stringBuffer.append("</p>");
            }
            if (FAQUtils.isFieldEmpty((String)this.link_)) break;
            if (!language.equals(question.getLanguage()) && !this.link_.contains("language")) {
                this.link_ = this.link_ + "/language=" + language;
            }
            stringBuffer.append(this.getLabel("Link").replaceFirst("<link>", this.link_));
            break;
        }
        this.addChild((UIComponent)new UIFormStringInput(FILED_SUBJECT, FILED_SUBJECT, this.getLabel("change-title") + " " + contenQuestion.replaceAll("<br>", " ")));
        UIFormWYSIWYGInput filedMessage = new UIFormWYSIWYGInput(FILED_MESSAGE, FILED_MESSAGE, "");
        filedMessage.setValue((Object)stringBuffer.toString());
        filedMessage.setToolBarName("Basic");
        this.addChild((UIComponent)filedMessage);
    }

    private boolean isContainLanguageList(List<QuestionLanguage> questionlg, String language) throws Exception {
        for (QuestionLanguage questionLanguage : questionlg) {
            if (!questionLanguage.getLanguage().equals(language)) continue;
            return true;
        }
        return false;
    }

    public void setFieldToValue(String value) {
        if (this.listAnotherEmail != null && this.listAnotherEmail.size() > 0) {
            for (String email : this.listAnotherEmail) {
                value = email + "," + value;
            }
        }
        this.getUIStringInput(FILED_TO).setValue((Object)value);
    }

    public String getFieldToValue() {
        return (String)this.getUIStringInput(FILED_TO).getValue();
    }

    public void setFieldCCValue(String value) {
        if (this.listAnotherEmail != null && this.listAnotherEmail.size() > 0) {
            for (String email : this.listAnotherEmail) {
                value = email + "," + value;
            }
        }
        if (value != null && value.trim().length() > 0) {
            this.isViewCC = true;
        }
        this.getUIStringInput(FILED_ADD_CC).setValue((Object)value);
    }

    public String getFieldCCValue() {
        return (String)this.getUIStringInput(FILED_ADD_CC).getValue();
    }

    public void setFieldBCCValue(String value) {
        if (this.listAnotherEmail != null && this.listAnotherEmail.size() > 0) {
            for (String email : this.listAnotherEmail) {
                value = email + "," + value;
            }
        }
        if (value != null && value.trim().length() > 0) {
            this.isViewBCC = true;
        }
        this.getUIStringInput(FILED_ADD_BCC).setValue((Object)value);
    }

    public String getFieldBCCValue() {
        return (String)this.getUIStringInput(FILED_ADD_BCC).getValue();
    }

    public Map<String, String> getServerConfig() {
        return this.serverConfig_;
    }

    static /* synthetic */ String access$000() {
        return MIMETYPE_TEXTHTML;
    }

    static /* synthetic */ FAQService access$100(UISendMailForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ Log access$200(UISendMailForm x0) {
        return x0.log;
    }

    static /* synthetic */ UIComponent access$300(UISendMailForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$402(UISendMailForm x0, List x1) {
        x0.listAnotherEmail = x1;
        return x0.listAnotherEmail;
    }

    static /* synthetic */ List access$400(UISendMailForm x0) {
        return x0.listAnotherEmail;
    }

    static /* synthetic */ UIComponent access$500(UISendMailForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ UIComponent access$600(UISendMailForm x0, UIContainer x1, Class x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$700(UISendMailForm x0) {
        return x0.listQuestionLanguage;
    }

    static /* synthetic */ String access$802(UISendMailForm x0, String x1) {
        x0.languageIsResponsed = x1;
        return x0.languageIsResponsed;
    }

    static /* synthetic */ int access$900(UISendMailForm x0) {
        return x0.posOfResponse;
    }

    static /* synthetic */ String access$1000(UISendMailForm x0) {
        return x0.link_;
    }
}

