/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIAnswersContainer;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.faq.webui.popup.UISettingForm;
import org.exoplatform.ks.common.webui.UIPopupAction;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/faq/webui/UIAnswersPortlet.gtmpl")
public class UIAnswersPortlet
extends UIPortletApplication {
    private boolean isFirstTime = true;

    public UIAnswersPortlet() throws Exception {
        this.addChild(UIAnswersContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UIAnswersPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UIAnswersPopupWindow");
    }

    public String getSpaceCategoryId() {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            if (pref.getValue("SPACE_URL", null) != null) {
                String url = pref.getValue("SPACE_URL", null);
                SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = sService.getSpaceByUrl(url);
                String categoryId = Utils.CATEGORY_PREFIX + space.getId();
                return categoryId;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            this.isFirstTime = true;
            if (this.getChild(UIAnswersContainer.class) == null) {
                if (this.getChild(UISettingForm.class) != null) {
                    this.removeChild(UISettingForm.class);
                }
                this.addChild(UIAnswersContainer.class, null, null);
            }
            this.renderPortletById();
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            try {
                if (this.isFirstTime) {
                    this.isFirstTime = false;
                    UIQuestions questions = (UIQuestions)((UIAnswersContainer)this.getChild(UIAnswersContainer.class)).getChild(UIQuestions.class);
                    FAQSetting faqSetting = questions.getFAQSetting();
                    if (this.getChild(UISettingForm.class) == null && faqSetting.isAdmin()) {
                        this.removeChild(UIAnswersContainer.class);
                        UISettingForm settingForm = (UISettingForm)this.addChild(UISettingForm.class, null, "FAQPortletSetting");
                        settingForm.setRendered(true);
                        settingForm.setIsEditPortlet(true);
                        settingForm.init();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\nFail to render a WebUIApplication\n", (Throwable)e);
            }
        }
        super.processRender(app, context);
    }

    private void renderPortletById() throws Exception {
        try {
            String cateId = this.getSpaceCategoryId();
            PortalRequestContext context = Util.getPortalRequestContext();
            if (!FAQUtils.isFieldEmpty((String)cateId) && context.getRequestParameter("objectId") == null && !"true".equals("" + context.getRequestParameter("ajaxRequest"))) {
                UIBreadcumbs uiBreadcums = (UIBreadcumbs)this.findFirstComponentOfType(UIBreadcumbs.class);
                UIQuestions uiQuestions = (UIQuestions)this.findFirstComponentOfType(UIQuestions.class);
                UICategories categories = (UICategories)this.findFirstComponentOfType(UICategories.class);
                uiBreadcums.setUpdataPath("categories/" + cateId);
                uiBreadcums.setRenderSearch(true);
                uiQuestions.setCategoryId("categories/" + cateId);
                categories.setPathCategory("categories/" + cateId);
            }
        }
        catch (Exception e) {
            System.out.println("can not render the selected category");
        }
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public static String getPreferenceDisplay() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue("display", "");
        return repository;
    }
}

