/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui.popup;

import java.util.ArrayList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.rendering.RenderHelper;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.webui.popup.UIPopupViewQuestion;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/faq/webui/popup/UIPopupViewQuestion.gtmpl", events={@EventConfig(listeners={DownloadAttachActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIPopupViewQuestion
extends BaseUIForm
implements UIPopupComponent {
    private String questionId_ = null;
    private String language_ = "";
    private static FAQService faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    private String[] sizes = new String[]{"bytes", "KB", "MB"};
    private RenderHelper renderHelper = new RenderHelper();

    public UIPopupViewQuestion() throws Exception {
        this.setActions(new String[]{"Close"});
    }

    public String getQuestion() {
        return this.questionId_;
    }

    public void setQuestion(String questionId) {
        this.questionId_ = questionId;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String renderAnswer(Answer answer) {
        return this.renderHelper.renderAnswer(answer);
    }

    public Question getViewQuestion() {
        Question question = null;
        try {
            question = faqService_.getQuestionById(this.questionId_);
            ArrayList listQuestionLanguage = new ArrayList();
            listQuestionLanguage.addAll(faqService_.getQuestionLanguages(this.questionId_));
            for (QuestionLanguage questionLanguage : listQuestionLanguage) {
                if (!questionLanguage.getLanguage().equals(this.language_)) continue;
                question.setDetail(questionLanguage.getDetail());
                question.setQuestion(questionLanguage.getQuestion());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get Question Language, exception: " + e.getMessage()));
        }
        return question;
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = "";
        try {
            url = Utils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            this.log.debug((Object)"Getting image url fail: ", (Throwable)e);
        }
        return url;
    }

    public String getQuestionRelationById(String questionId) {
        try {
            Question question = faqService_.getQuestionById(questionId);
            if (question != null) {
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get Question Relation by Id, exception: " + e.getMessage()));
        }
        return "";
    }

    private String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        if (residual > 1000L) {
            String str = residual + "";
            result = size + "." + str.substring(0, 3) + " " + this.sizes[i];
        } else {
            result = size + "." + residual + " " + this.sizes[i];
        }
        return result;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

