/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQUtils;
import org.exoplatform.faq.webui.UIBreadcumbs;
import org.exoplatform.faq.webui.UICategories;
import org.exoplatform.faq.webui.UIQuestions;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/faq/webui/UIAnswersContainer.gtmpl")
public class UIAnswersContainer
extends UIContainer {
    private FAQSetting faqSetting_ = null;
    private String currentUser_;
    private FAQService faqService_;
    private boolean isRenderChild = true;
    private boolean hasPermission = true;
    private List<String> propetyOfUser = new ArrayList();

    public UIAnswersContainer() throws Exception {
        this.faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, null, null);
        UIQuestions uiQuestions = (UIQuestions)this.addChild(UIQuestions.class, null, null);
        UICategories uiCategories = (UICategories)this.addChild(UICategories.class, null, null);
        this.currentUser_ = FAQUtils.getCurrentUser();
        this.faqSetting_ = new FAQSetting();
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        this.faqSetting_.setCurrentUser(this.currentUser_);
        if (!FAQUtils.isFieldEmpty((String)this.currentUser_)) {
            if (this.faqService_.isAdminRole(null)) {
                this.faqSetting_.setIsAdmin("TRUE");
            } else {
                this.faqSetting_.setIsAdmin("FALSE");
            }
            this.faqService_.getUserSetting(this.currentUser_, this.faqSetting_);
        } else {
            this.faqSetting_.setIsAdmin("FALSE");
        }
        String cateIdView = "categories";
        if (!this.faqSetting_.isAdmin() && !this.faqSetting_.isPostQuestionInRootCategory()) {
            this.propetyOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
            List cates = this.faqService_.getSubCategories(cateIdView, this.faqSetting_, false, this.propetyOfUser);
            if (cates != null && cates.size() > 0) {
                cateIdView = cateIdView + "/" + ((Category)cates.get(0)).getId();
            }
        }
        this.hasPermission = this.isRenderChild = this.isRenderCategory(cateIdView);
        uiBreadcumbs.setUpdataPath(cateIdView);
        uiQuestions.setFAQService(this.faqService_);
        uiQuestions.setFAQSetting(this.faqSetting_);
        uiQuestions.setCategoryId(cateIdView);
        uiBreadcumbs.setRenderSearch(uiQuestions.isViewRootCate());
        uiCategories.setFAQSetting(this.faqSetting_);
        uiCategories.setFAQService(this.faqService_);
        if (uiCategories.getCategoryPath() == null) {
            uiCategories.setPathCategory(cateIdView);
        }
    }

    public void setViewRootCate() {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String isAjax = portalContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        FAQUtils.getPorletPreference((FAQSetting)this.faqSetting_);
        UIQuestions questions = (UIQuestions)this.getChild(UIQuestions.class);
        questions.setViewRootCate();
        boolean b = questions.isViewRootCate();
        if (b != this.hasPermission) {
            this.hasPermission = b;
        }
        if ("categories".equals(questions.getCategoryId())) {
            this.isRenderChild = this.hasPermission;
        }
    }

    public boolean isRenderCategory(String categoryId) {
        try {
            Category category = this.faqService_.getCategoryById(categoryId);
            if (this.currentUser_ != null && this.currentUser_.trim().length() > 0) {
                this.faqSetting_.setCurrentUser(this.currentUser_);
                this.faqSetting_.setCanEdit(false);
                if (this.faqSetting_.getIsAdmin() != null && this.faqSetting_.getIsAdmin().equals("TRUE")) {
                    this.faqSetting_.setCanEdit(true);
                } else if (category.getModerators() != null && category.getModerators().length > 0 && category.getModerators()[0].trim().length() > 0) {
                    if (this.propetyOfUser.isEmpty()) {
                        this.propetyOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
                    }
                    this.faqSetting_.setCanEdit(Utils.hasPermission((List)this.propetyOfUser, Arrays.asList(category.getModerators())));
                }
            }
            if (!this.faqSetting_.isCanEdit() && category.getUserPrivate() != null && category.getUserPrivate().length > 0 && category.getUserPrivate()[0].trim().length() > 0) {
                if (this.propetyOfUser.isEmpty()) {
                    this.propetyOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
                }
                return Utils.hasPermission((List)this.propetyOfUser, Arrays.asList(category.getUserPrivate()));
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public FAQSetting getFAQSetting() {
        return this.faqSetting_;
    }

    public boolean getRenderChild() {
        return this.hasPermission;
    }

    public void updateIsRender(boolean isRender) throws Exception {
        ((UICategories)this.getChild(UICategories.class)).setRendered(isRender);
        ((UIBreadcumbs)this.getChild(UIBreadcumbs.class)).setRendered(isRender);
        ((UIQuestions)this.getChild(UIQuestions.class)).setRendered(isRender);
    }
}

