/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    public NewUserListener(InitParams params) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        ForumService fservice = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        try {
            ForumStatistic statistic = fservice.getForumStatistic(sysSession);
            statistic.setNewMembers(user.getFullName());
            statistic.setMembersCount(statistic.getMembersCount() + 1L);
            fservice.saveForumStatistic(sysSession, statistic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
        sysSession = SessionProvider.createSystemProvider();
        try {
            fservice.createUserProfile(sysSession, user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(User user) throws Exception {
        SessionProvider sysSession = SessionProvider.createSystemProvider();
        ForumService fservice = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        try {
            ForumStatistic statistic = fservice.getForumStatistic(sysSession);
            if (user.getUserName().equals(statistic.getNewMembers())) {
                fservice.updateForumStatistic(sysSession);
            } else {
                statistic.setMembersCount(statistic.getMembersCount() - 1L);
                fservice.saveForumStatistic(sysSession, statistic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sysSession.close();
        }
    }
}

