/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.user;

import org.apache.commons.logging.Log;
import org.exoplatform.forum.service.user.ContactProvider;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class PersonalProfileContactProvider
implements ContactProvider {
    private static Log log = ExoLogger.getLogger(PersonalProfileContactProvider.class);
    private OrganizationService orgService;

    public PersonalProfileContactProvider(OrganizationService orgService) {
        this.orgService = orgService;
    }

    public ForumContact getForumContact(String userId) {
        ForumContact contact = new ForumContact();
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(userId);
            User user = this.orgService.getUserHandler().findUserByName(userId);
            contact.setAvatarUrl(profile.getAttribute("user.other-info.avatar.url"));
            contact.setBirthday(profile.getAttribute("user.bdate"));
            contact.setGender(profile.getAttribute("user.gender"));
            contact.setJob(profile.getAttribute("user.jobtitle"));
            contact.setFirstName(user.getFirstName());
            contact.setLastName(user.getLastName());
            contact.setEmailAddress(user.getEmail());
            contact.setCity(profile.getAttribute("user.home-info.postal.city"));
            contact.setCountry(profile.getAttribute("user.home-info.postal.country"));
            contact.setMobile(profile.getAttribute("user.home-info.telecom.mobile.number"));
            contact.setPhone(profile.getAttribute("user.home-info.telecom.telephone.number"));
            contact.setWebSite(profile.getAttribute("user.home-info.online.uri"));
        }
        catch (Exception e) {
            log.warn((Object)("Could not retrieve forum user profile for " + userId + ": " + e.getMessage()));
        }
        return contact;
    }
}

