/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;

public class CategoryEventListener
implements EventListener {
    private static final Log log = ExoLogger.getLogger(CategoryEventListener.class);
    private String workspace_;
    private String repository_;

    public CategoryEventListener(String ws, String repo) throws Exception {
        this.workspace_ = ws;
        this.repository_ = repo;
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            while (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                if (ev.getType() == 1) {
                    try {
                        forumService.registerListenerForCategory(ev.getPath());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (ev.getType() != 2) continue;
                forumService.unRegisterListenerForCategory(ev.getPath());
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to run category event listener.", (Throwable)e);
        }
    }

    public void removeEvent(EventIterator evIter) {
        evIter.remove();
    }
}

