/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.Watch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRPageList<E>
extends PageList {
    protected int pageSelected = 1;

    public JCRPageList(int pageSize) {
        super(pageSize);
    }

    protected abstract void populateCurrentPage(int var1) throws Exception;

    protected abstract void populateCurrentPageSearch(int var1, List var2, boolean var3, boolean var4) throws Exception;

    protected abstract void populateCurrentPageList(int var1, List<String> var2) throws Exception;

    protected abstract void populateCurrentPage(String var1) throws Exception;

    public int getPageSelected() {
        return this.pageSelected;
    }

    public void setPageSize(long pageSize) {
        super.setPageSize((int)pageSize);
    }

    public int getCurrentPage() {
        return this.currentPage_;
    }

    public int getAvailable() {
        return this.available_;
    }

    public int getAvailablePage() {
        return this.availablePage_;
    }

    public List<E> currentPage() throws Exception {
        if (this.currentListPage_ == null) {
            this.populateCurrentPage(this.currentPage_);
        }
        return this.currentListPage_;
    }

    public List<E> getPage(int page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(this.currentPage_);
        this.pageSelected = this.currentPage_;
        return this.currentListPage_;
    }

    public List<E> getpage(String valueSearch) throws Exception {
        this.populateCurrentPage(valueSearch);
        return this.currentListPage_;
    }

    public List<E> getPageSearch(int page, List<ForumSearch> list) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageSearch(this.currentPage_, list, false, false);
        return this.currentListPage_;
    }

    public List<E> getPageWatch(int page, List<Watch> list) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageSearch(this.currentPage_, list, true, false);
        return this.currentListPage_;
    }

    public List<E> getPageUser(int page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageSearch(this.currentPage_, new CopyOnWriteArrayList(), true, true);
        return this.currentListPage_;
    }

    public List<E> getPageList(int page, List<String> list) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPageList(this.currentPage_, list);
        return this.currentListPage_;
    }

    public void checkAndSetPage(int page) throws Exception {
        if (page > this.availablePage_) {
            page = this.availablePage_ - 1;
        }
        if (page < 1) {
            page = 1;
        }
        this.currentPage_ = page;
    }
}

