/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.JCRForumAttachment;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.jcr.JCRSessionManager;

public class ForumPageList
extends JCRPageList {
    private boolean isQuery_ = false;
    private String value_;
    private JCRSessionManager sessionManager;
    private NodeIterator iter_ = null;
    private List listValue_ = null;

    public ForumPageList(int pageSize, int size) {
        super(pageSize);
        this.setAvailablePage(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForumPageList(NodeIterator iter, int pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.sessionManager = ForumServiceUtils.getSessionManager();
        try {
            if (iter == null) {
                this.sessionManager.openSession();
                iter = this.setQuery(this.isQuery_, this.value_);
            }
            if (iter != null) {
                this.iter_ = iter;
                this.setAvailablePage((int)iter.getSize());
            }
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public ForumPageList(List listResult) {
        super(listResult.size());
        this.isQuery_ = false;
        this.listValue_ = listResult;
        this.sessionManager = ForumServiceUtils.getSessionManager();
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (this.iter_ == null) {
            this.sessionManager.openSession();
            this.iter_ = this.setQuery(this.isQuery_, this.value_);
            this.sessionManager.closeSession();
            this.setAvailablePage((int)this.iter_.getSize());
            if (page == 0) {
                this.currentPage_ = 0;
            } else {
                this.checkAndSetPage(page);
            }
            page = this.currentPage_;
        }
        long pageSize = 0L;
        if (page > 0) {
            long position = 0L;
            pageSize = this.getPageSize();
            if (page == 1) {
                position = 0L;
            } else {
                position = (long)(page - 1) * pageSize;
                this.iter_.skip(position);
            }
        } else {
            pageSize = this.iter_.getSize();
        }
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:post")) {
                this.currentListPage_.add(this.getPost(currentNode));
            } else if (currentNode.isNodeType("exo:topic")) {
                this.currentListPage_.add(this.getTopic(currentNode));
            } else if (currentNode.isNodeType(Utils.USER_PROFILES_TYPE)) {
                this.currentListPage_.add(this.getUserProfile(currentNode));
            } else if (currentNode.isNodeType("exo:privateMessage")) {
                this.currentListPage_.add(this.getPrivateMessage(currentNode));
            }
            ++i;
        }
        this.iter_ = null;
    }

    protected void populateCurrentPage(String valueString) throws Exception {
        NodeIterator nodeIterator = this.setQuery(this.isQuery_, this.value_);
        if (this.iter_ == null) {
            this.iter_ = this.setQuery(this.isQuery_, this.value_);
        }
        int pos = 0;
        int i = 0;
        while ((long)i < nodeIterator.getSize()) {
            if (this.getUserProfile(nodeIterator.nextNode()).getUserId().equals(valueString)) {
                pos = i + 1;
                break;
            }
            ++i;
        }
        int pageSize = this.getPageSize();
        int page = 1;
        if (pos < pageSize) {
            page = 1;
        } else {
            page = pos / pageSize;
            if (pos % pageSize > 0) {
                ++page;
            }
        }
        this.pageSelected = page;
        this.iter_.skip((long)((page - 1) * pageSize));
        this.currentListPage_ = new ArrayList();
        for (int i2 = 0; i2 < pageSize && this.iter_.hasNext(); ++i2) {
            this.currentListPage_.add(this.getUserProfile(this.iter_.nextNode()));
        }
        this.iter_ = null;
    }

    protected void populateCurrentPageSearch(int page, List list, boolean isWatch, boolean isSearchUser) throws Exception {
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1 ? 0L : (long)(page - 1) * pageSize;
        pageSize *= (long)page;
        if (!isSearchUser) {
            this.currentListPage_ = !isWatch ? new ArrayList() : new ArrayList();
        } else {
            this.currentListPage_ = new CopyOnWriteArrayList();
            list = this.listValue_;
        }
        for (int i = (int)position; (long)i < pageSize && i < list.size(); ++i) {
            this.currentListPage_.add(list.get(i));
        }
    }

    private NodeIterator setQuery(boolean isQuery, String value) throws Exception {
        NodeIterator iter;
        Session session = JCRSessionManager.getCurrentSession();
        if (isQuery) {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(value, "xpath");
            QueryResult result = query.execute();
            iter = result.getNodes();
        } else {
            Node node = (Node)session.getItem(value);
            iter = node.getNodes();
        }
        return iter;
    }

    private Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        if (postNode.hasProperty("exo:owner")) {
            postNew.setOwner(postNode.getProperty("exo:owner").getString());
        }
        if (postNode.hasProperty("exo:createdDate")) {
            postNew.setCreatedDate(postNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:modifiedBy")) {
            postNew.setModifiedBy(postNode.getProperty("exo:modifiedBy").getString());
        }
        if (postNode.hasProperty("exo:modifiedDate")) {
            postNew.setModifiedDate(postNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (postNode.hasProperty("exo:editReason")) {
            postNew.setEditReason(postNode.getProperty("exo:editReason").getString());
        }
        if (postNode.hasProperty("exo:name")) {
            postNew.setName(postNode.getProperty("exo:name").getString());
        }
        if (postNode.hasProperty("exo:message")) {
            postNew.setMessage(postNode.getProperty("exo:message").getString());
        }
        if (postNode.hasProperty("exo:remoteAddr")) {
            postNew.setRemoteAddr(postNode.getProperty("exo:remoteAddr").getString());
        }
        if (postNode.hasProperty("exo:icon")) {
            postNew.setIcon(postNode.getProperty("exo:icon").getString());
        }
        if (postNode.hasProperty("exo:link")) {
            postNew.setLink(postNode.getProperty("exo:link").getString());
        }
        if (postNode.hasProperty("exo:isApproved")) {
            postNew.setIsApproved(postNode.getProperty("exo:isApproved").getBoolean());
        }
        if (postNode.hasProperty("exo:isHidden")) {
            postNew.setIsHidden(postNode.getProperty("exo:isHidden").getBoolean());
        }
        if (postNode.hasProperty("exo:isActiveByTopic")) {
            postNew.setIsActiveByTopic(postNode.getProperty("exo:isActiveByTopic").getBoolean());
        }
        if (postNode.hasProperty("exo:userPrivate")) {
            postNew.setUserPrivate(this.ValuesToArray(postNode.getProperty("exo:userPrivate").getValues()));
        }
        if (postNode.hasProperty("exo:numberAttach")) {
            long numberAttach = postNode.getProperty("exo:numberAttach").getLong();
            postNew.setNumberAttach(numberAttach);
            if (numberAttach > 0L) {
                NodeIterator postAttachments = postNode.getNodes();
                ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
                while (postAttachments.hasNext()) {
                    Node node = postAttachments.nextNode();
                    if (!node.isNodeType("exo:forumAttachment")) continue;
                    JCRForumAttachment attachment = new JCRForumAttachment();
                    Node nodeFile = node.getNode("jcr:content");
                    attachment.setId(node.getName());
                    attachment.setPathNode(node.getPath());
                    attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                    attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                    String workspace = node.getSession().getWorkspace().getName();
                    attachment.setWorkspace(workspace);
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                    attachment.setPath("/" + workspace + node.getPath());
                    attachments.add(attachment);
                }
                postNew.setAttachments(attachments);
            }
        }
        return postNew;
    }

    private Topic getTopic(Node topicNode) throws Exception {
        Node FirstPostNode;
        String idFirstPost;
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setOwner(topicNode.getProperty("exo:owner").getString());
        topicNew.setTopicName(topicNode.getProperty("exo:name").getString());
        topicNew.setCreatedDate(topicNode.getProperty("exo:createdDate").getDate().getTime());
        if (topicNode.hasProperty("exo:modifiedBy")) {
            topicNew.setModifiedBy(topicNode.getProperty("exo:modifiedBy").getString());
        }
        if (topicNode.hasProperty("exo:modifiedDate")) {
            topicNew.setModifiedDate(topicNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (topicNode.hasProperty("exo:lastPostBy")) {
            topicNew.setLastPostBy(topicNode.getProperty("exo:lastPostBy").getString());
        }
        if (topicNode.hasProperty("exo:lastPostDate")) {
            topicNew.setLastPostDate(topicNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        try {
            topicNew.setTopicType(topicNode.getProperty("exo:topicType").getString());
        }
        catch (Exception e) {
            topicNew.setTopicType(" ");
        }
        topicNew.setDescription(topicNode.getProperty("exo:description").getString());
        topicNew.setPostCount(topicNode.getProperty("exo:postCount").getLong());
        topicNew.setViewCount(topicNode.getProperty("exo:viewCount").getLong());
        if (topicNode.hasProperty("exo:numberAttachments")) {
            topicNew.setNumberAttachment(topicNode.getProperty("exo:numberAttachments").getLong());
        }
        topicNew.setIcon(topicNode.getProperty("exo:icon").getString());
        topicNew.setLink(topicNode.getProperty("exo:link").getString());
        if (topicNode.hasProperty("exo:isNotifyWhenAddPost")) {
            topicNew.setIsNotifyWhenAddPost(topicNode.getProperty("exo:isNotifyWhenAddPost").getString());
        }
        topicNew.setIsModeratePost(topicNode.getProperty("exo:isModeratePost").getBoolean());
        topicNew.setIsClosed(topicNode.getProperty("exo:isClosed").getBoolean());
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(topicNode.getProperty("exo:isLock").getBoolean());
        }
        topicNew.setIsApproved(topicNode.getProperty("exo:isApproved").getBoolean());
        topicNew.setIsSticky(topicNode.getProperty("exo:isSticky").getBoolean());
        topicNew.setIsWaiting(topicNode.getProperty("exo:isWaiting").getBoolean());
        topicNew.setIsActive(topicNode.getProperty("exo:isActive").getBoolean());
        topicNew.setIsActiveByForum(topicNode.getProperty("exo:isActiveByForum").getBoolean());
        topicNew.setCanView(this.ValuesToArray(topicNode.getProperty("exo:canView").getValues()));
        topicNew.setCanPost(this.ValuesToArray(topicNode.getProperty("exo:canPost").getValues()));
        if (topicNode.hasProperty("exo:isPoll")) {
            topicNew.setIsPoll(topicNode.getProperty("exo:isPoll").getBoolean());
        }
        if (topicNode.hasProperty("exo:userVoteRating")) {
            topicNew.setUserVoteRating(this.ValuesToArray(topicNode.getProperty("exo:userVoteRating").getValues()));
        }
        if (topicNode.hasProperty("exo:tagId")) {
            topicNew.setTagId(this.ValuesToArray(topicNode.getProperty("exo:tagId").getValues()));
        }
        if (topicNode.hasProperty("exo:voteRating")) {
            topicNew.setVoteRating(topicNode.getProperty("exo:voteRating").getDouble());
        }
        if (topicNode.isNodeType("exo:forumWatching") && topicNode.hasProperty("exo:emailWatching")) {
            topicNew.setEmailNotification(this.ValuesToArray(topicNode.getProperty("exo:emailWatching").getValues()));
        }
        if (topicNode.hasNode(idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST)) && (FirstPostNode = topicNode.getNode(idFirstPost)).hasProperty("exo:numberAttachments") && FirstPostNode.getProperty("exo:numberAttachments").getLong() > 0L) {
            NodeIterator postAttachments = FirstPostNode.getNodes();
            ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
            while (postAttachments.hasNext()) {
                Node node = postAttachments.nextNode();
                if (!node.isNodeType("exo:forumAttachment")) continue;
                JCRForumAttachment attachment = new JCRForumAttachment();
                Node nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getName());
                attachment.setPathNode(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setName(nodeFile.getProperty("exo:fileName").getString());
                String workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                attachment.setPath("/" + workspace + node.getPath());
                attachments.add(attachment);
            }
            topicNew.setAttachments(attachments);
        }
        return topicNew;
    }

    private UserProfile getUserProfile(Node profileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(profileNode.getName());
        userProfile.setUserTitle(profileNode.getProperty("exo:userTitle").getString());
        try {
            userProfile.setScreenName(profileNode.getProperty("exo:screenName").getString());
        }
        catch (Exception e) {
            userProfile.setScreenName(profileNode.getName());
        }
        userProfile.setFullName(profileNode.getProperty("exo:fullName").getString());
        userProfile.setFirstName(profileNode.getProperty("exo:firstName").getString());
        userProfile.setLastName(profileNode.getProperty("exo:lastName").getString());
        userProfile.setEmail(profileNode.getProperty("exo:email").getString());
        userProfile.setUserRole(profileNode.getProperty("exo:userRole").getLong());
        userProfile.setSignature(profileNode.getProperty("exo:signature").getString());
        userProfile.setTotalPost(profileNode.getProperty("exo:totalPost").getLong());
        userProfile.setTotalTopic(profileNode.getProperty("exo:totalTopic").getLong());
        userProfile.setModerateForums(this.ValuesToArray(profileNode.getProperty("exo:moderateForums").getValues()));
        try {
            userProfile.setModerateCategory(this.ValuesToArray(profileNode.getProperty("exo:moderateCategory").getValues()));
        }
        catch (Exception e) {
            userProfile.setModerateCategory(new String[0]);
        }
        if (profileNode.hasProperty("exo:lastLoginDate")) {
            userProfile.setLastLoginDate(profileNode.getProperty("exo:lastLoginDate").getDate().getTime());
        }
        if (profileNode.hasProperty("exo:joinedDate")) {
            userProfile.setJoinedDate(profileNode.getProperty("exo:joinedDate").getDate().getTime());
        }
        if (profileNode.hasProperty("exo:lastPostDate")) {
            userProfile.setLastPostDate(profileNode.getProperty("exo:lastPostDate").getDate().getTime());
        }
        userProfile.setIsDisplaySignature(profileNode.getProperty("exo:isDisplaySignature").getBoolean());
        userProfile.setIsDisplayAvatar(profileNode.getProperty("exo:isDisplayAvatar").getBoolean());
        userProfile.setNewMessage(profileNode.getProperty("exo:newMessage").getLong());
        userProfile.setTimeZone(profileNode.getProperty("exo:timeZone").getDouble());
        userProfile.setShortDateFormat(profileNode.getProperty("exo:shortDateformat").getString());
        userProfile.setLongDateFormat(profileNode.getProperty("exo:longDateformat").getString());
        userProfile.setTimeFormat(profileNode.getProperty("exo:timeFormat").getString());
        userProfile.setMaxPostInPage(profileNode.getProperty("exo:maxPost").getLong());
        userProfile.setMaxTopicInPage(profileNode.getProperty("exo:maxTopic").getLong());
        userProfile.setIsShowForumJump(profileNode.getProperty("exo:isShowForumJump").getBoolean());
        userProfile.setIsBanned(profileNode.getProperty("exo:isBanned").getBoolean());
        if (profileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(profileNode.getProperty("exo:banUntil").getLong());
        }
        if (profileNode.hasProperty("exo:banReason")) {
            userProfile.setBanReason(profileNode.getProperty("exo:banReason").getString());
        }
        if (profileNode.hasProperty("exo:banCounter")) {
            userProfile.setBanCounter(Integer.parseInt(profileNode.getProperty("exo:banCounter").getString()));
        }
        if (profileNode.hasProperty("exo:banReasonSummary")) {
            userProfile.setBanReasonSummary(this.ValuesToArray(profileNode.getProperty("exo:banReasonSummary").getValues()));
        }
        if (profileNode.hasProperty("exo:createdDateBan")) {
            userProfile.setCreatedDateBan(profileNode.getProperty("exo:createdDateBan").getDate().getTime());
        }
        return userProfile;
    }

    private ForumPrivateMessage getPrivateMessage(Node messageNode) throws Exception {
        ForumPrivateMessage message = new ForumPrivateMessage();
        message.setId(messageNode.getName());
        message.setFrom(messageNode.getProperty("exo:from").getString());
        message.setSendTo(messageNode.getProperty("exo:sendTo").getString());
        message.setName(messageNode.getProperty("exo:name").getString());
        message.setMessage(messageNode.getProperty("exo:message").getString());
        message.setReceivedDate(messageNode.getProperty("exo:receivedDate").getDate().getTime());
        message.setIsUnread(messageNode.getProperty("exo:isUnread").getBoolean());
        message.setType(messageNode.getProperty("exo:type").getString());
        return message;
    }

    private String[] ValuesToArray(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    protected void populateCurrentPageList(int page, List list) throws Exception {
        int pageSize = this.getPageSize();
        int position = 0;
        position = page == 1 ? 0 : (page - 1) * pageSize;
        pageSize *= page;
        this.currentListPage_ = new ArrayList();
        for (int i = position; i < pageSize && i < list.size(); ++i) {
            this.currentListPage_.add(list.get(i));
        }
    }

    public List getAll() throws Exception {
        this.currentPage_ = 0;
        this.populateCurrentPage(this.currentPage_);
        this.pageSelected = 0;
        return this.currentListPage_;
    }
}

