/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.selector;

import java.io.Serializable;
import org.exoplatform.forum.service.cache.model.ScopeCacheKey;
import org.exoplatform.forum.service.cache.model.data.ForumData;
import org.exoplatform.forum.service.cache.model.key.ForumKey;
import org.exoplatform.forum.service.cache.model.selector.ScopeCacheSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumPathSelector
extends ScopeCacheSelector<ScopeCacheKey, Object> {
    private final String[] paths;
    private final ExoCache<ForumKey, ForumData> forumData;

    public ForumPathSelector(String[] paths, ExoCache<ForumKey, ForumData> forumData) {
        if (paths == null) {
            throw new NullPointerException();
        }
        if (forumData == null) {
            throw new NullPointerException();
        }
        this.paths = paths;
        this.forumData = forumData;
    }

    @Override
    public boolean select(ScopeCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (!super.select(key, ocinfo)) {
            return false;
        }
        ForumData data = (ForumData)this.forumData.get((Serializable)key);
        if (data == null || data == ForumData.NULL) {
            return false;
        }
        for (String path : this.paths) {
            if (!data.getPath().endsWith(path)) continue;
            return true;
        }
        return false;
    }
}

