/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class ForumGroupListener
extends GroupEventListener {
    private static final Log log = ExoLogger.getLogger(ForumGroupListener.class);
    private ForumService forumService = null;

    private ForumService getForumService() {
        if (this.forumService == null) {
            this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        }
        return this.forumService;
    }

    public void preDelete(Group group) throws Exception {
        String groupId = group.getId();
        log.info((Object)("Calculate deleted group from forum: " + groupId));
        this.getForumService().calculateDeletedGroup(groupId, group.getGroupName());
    }
}

