/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JobWattingForModerator;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={ChangePathActionListener.class}), @EventConfig(listeners={RssActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class})})
public class UIBreadcumbs
extends UIContainer {
    private ForumService forumService;
    private List<String> breadcumbs_ = new ArrayList();
    private List<String> path_ = new ArrayList();
    private String forumHomePath_;
    public static final String FORUM_SERVICE = Utils.FORUM_SERVICE;
    private UserProfile userProfile;
    JobWattingForModerator wattingForModerator;
    private boolean isLink = false;
    private boolean isOpen = true;
    private String tooltipLink = "forumHome";

    public UIBreadcumbs() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.forumHomePath_ = this.forumService.getForumHomePath(ForumSessionUtils.getSystemProvider());
        this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
        this.path_.add(FORUM_SERVICE);
    }

    public void setUpdataPath(String path) throws Exception {
        this.isLink = false;
        if (!ForumUtils.isEmpty((String)path) && !path.equals(FORUM_SERVICE)) {
            String[] temp = path.split("/");
            String pathNode = this.forumHomePath_;
            this.path_.clear();
            this.breadcumbs_.clear();
            this.path_.add(FORUM_SERVICE);
            this.tooltipLink = "forumHome";
            this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
            if (path.equals(ForumUtils.FIELD_EXOFORUM_LABEL)) {
                this.breadcumbs_.add(ForumUtils.FIELD_SEARCHFORUM_LABEL);
                this.path_.add("/" + ForumUtils.FIELD_EXOFORUM_LABEL);
            } else {
                String tempPath = "";
                int i = 0;
                for (String string : temp) {
                    pathNode = pathNode + "/" + string;
                    Object obj = this.forumService.getObjectNameByPath(ForumSessionUtils.getSystemProvider(), pathNode);
                    if (obj == null) {
                        if (i == 0) {
                            this.isLink = true;
                        }
                        break;
                    }
                    if (obj instanceof Category) {
                        Category category = (Category)obj;
                        tempPath = string;
                        this.breadcumbs_.add(category.getCategoryName());
                        this.tooltipLink = "category";
                    } else if (obj instanceof Forum) {
                        tempPath = !ForumUtils.isEmpty((String)tempPath) ? tempPath + "/" + string : string;
                        Forum forum = (Forum)obj;
                        this.breadcumbs_.add(forum.getForumName());
                        this.tooltipLink = "forum";
                    } else if (obj instanceof Topic) {
                        tempPath = !ForumUtils.isEmpty((String)tempPath) ? tempPath + "/" + string : string;
                        Topic topic = (Topic)obj;
                        this.breadcumbs_.add(topic.getTopicName());
                        this.tooltipLink = "topic";
                    } else if (obj instanceof Tag) {
                        Tag tag = (Tag)obj;
                        this.breadcumbs_.add(tag.getName());
                        this.tooltipLink = "tag";
                    }
                    this.path_.add(tempPath);
                    ++i;
                }
            }
        } else {
            this.path_.clear();
            this.breadcumbs_.clear();
            this.path_.add(FORUM_SERVICE);
            this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
            this.tooltipLink = "forumHome";
        }
    }

    private void setUserProfile() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    private int getTotalJobWattingForModerator() throws Exception {
        return this.forumService.getTotalJobWattingForModerator(SessionProviderFactory.createSystemProvider(), this.userProfile.getUserId());
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    private String getToolTip() {
        return this.tooltipLink;
    }

    private boolean isLink() {
        return this.isLink;
    }

    private String getPath(int index) {
        return (String)this.path_.get(index);
    }

    private int getMaxPath() {
        return this.breadcumbs_.size();
    }

    private List<String> getBreadcumbs() throws Exception {
        return this.breadcumbs_;
    }

    private long getNewMessage() throws Exception {
        try {
            String username = this.userProfile.getUserId();
            return this.forumService.getNewPrivateMessage(SessionProviderFactory.createSystemProvider(), username);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    static /* synthetic */ boolean access$002(UIBreadcumbs x0, boolean x1) {
        x0.isOpen = x1;
        return x0.isOpen;
    }

    static /* synthetic */ UserProfile access$100(UIBreadcumbs x0) {
        return x0.userProfile;
    }
}

