/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Poll;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumCheckBoxInput;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.forum.webui.UITopicDetailContainer;
import org.exoplatform.forum.webui.UITopicPoll;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicPoll.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={RemovePollActionListener.class}, confirm="UITopicPoll.msg.confirm-RemovePoll"), @EventConfig(listeners={ClosedPollActionListener.class}), @EventConfig(listeners={VoteAgainPollActionListener.class})})
public class UITopicPoll
extends UIForm {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private Poll poll_;
    private String categoryId;
    private String forumId;
    private String topicId;
    private boolean isAgainVote = false;
    private boolean isEditPoll = false;
    private boolean canViewEditMenu = false;
    private boolean userIsBanned = false;
    private Forum forum;

    private UserProfile getOption() throws Exception {
        return ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
    }

    public void setForum(Forum forum) {
        this.forum = forum;
    }

    public void updateFormPoll(String categoryId, String forumId, String topicId) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.isEditPoll = true;
    }

    private void init() throws Exception {
        if (this.hasChildren()) {
            this.removeChild(UIFormRadioBoxInput.class);
            for (int i = 0; i < 10 && this.hasChildren(); ++i) {
                this.removeChild(UIForumCheckBoxInput.class);
            }
        }
        if (this.poll_ != null) {
            if (!this.poll_.getIsMultiCheck()) {
                ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                for (String s : this.poll_.getOption()) {
                    options.add(new SelectItemOption(s, (Object)s));
                }
                UIFormRadioBoxInput input = new UIFormRadioBoxInput("vote", "vote", options);
                input.setAlign(1);
                this.addUIFormInput((UIFormInput)input);
            } else {
                for (String s : this.poll_.getOption()) {
                    this.addUIFormInput((UIFormInput)new UIForumCheckBoxInput(s, s, (Object)false));
                }
            }
        }
    }

    private Poll getPoll() throws Exception {
        if (!ForumUtils.isEmpty((String)this.categoryId)) {
            Poll poll;
            UserProfile userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
            String userId = userProfile.getUserId();
            long userRole = userProfile.getUserRole();
            this.canViewEditMenu = userRole == 0L || ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)userId);
            this.poll_ = poll = this.forumService.getPoll(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId, this.topicId);
            this.init();
            return poll;
        }
        return null;
    }

    private boolean getIsEditPoll() {
        return this.isEditPoll;
    }

    private boolean getCanViewEditMenu() {
        return this.canViewEditMenu;
    }

    private boolean getIsVoted() throws Exception {
        String[] userVotes;
        Date today;
        if (this.poll_.getIsClosed()) {
            return true;
        }
        String userVote = ForumSessionUtils.getCurrentUser();
        this.userIsBanned = ((UITopicDetail)((UITopicDetailContainer)this.getAncestorOfType(UITopicDetailContainer.class)).getChild(UITopicDetail.class)).getUserProfile().getIsBanned();
        if (this.userIsBanned) {
            return true;
        }
        if (ForumUtils.isEmpty((String)userVote)) {
            return true;
        }
        if (this.poll_.getTimeOut() > 0L && (today = new Date()).getTime() - this.poll_.getCreatedDate().getTime() >= this.poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (this.isAgainVote) {
            return false;
        }
        for (String string : userVotes = this.poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(":"))).equalsIgnoreCase(userVote)) continue;
            return true;
        }
        return false;
    }

    private String[] getInfoVote() throws Exception {
        Poll poll = this.poll_;
        String[] voteNumber = poll.getVote();
        long size = 0L;
        if (!poll.getIsMultiCheck()) {
            size = poll.getUserVote().length;
        } else {
            for (String user : poll.getUserVote()) {
                size += (long)(user.split(":").length - 1);
            }
        }
        if (size == 0L) {
            size = 1L;
        }
        String[] infoVote = new String[voteNumber.length + 1];
        int i = 0;
        for (String string : voteNumber) {
            double tmp = Double.parseDouble(string);
            double k = tmp * (double)size / 100.0;
            int t = (int)Math.round(k);
            string = "" + (double)t * 100.0 / (double)size;
            infoVote[i] = string + ":" + t;
            ++i;
        }
        infoVote[i] = "" + size;
        return infoVote;
    }

    static /* synthetic */ Poll access$000(UITopicPoll x0) {
        return x0.poll_;
    }

    static /* synthetic */ boolean access$100(UITopicPoll x0) {
        return x0.isAgainVote;
    }

    static /* synthetic */ String access$200(UITopicPoll x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$300(UITopicPoll x0) {
        return x0.forumId;
    }

    static /* synthetic */ String access$400(UITopicPoll x0) {
        return x0.topicId;
    }

    static /* synthetic */ ForumService access$500(UITopicPoll x0) {
        return x0.forumService;
    }

    static /* synthetic */ boolean access$102(UITopicPoll x0, boolean x1) {
        x0.isAgainVote = x1;
        return x0.isAgainVote;
    }

    static /* synthetic */ Poll access$002(UITopicPoll x0, Poll x1) {
        x0.poll_ = x1;
        return x0.poll_;
    }

    static /* synthetic */ Poll access$600(UITopicPoll x0) throws Exception {
        return x0.getPoll();
    }

    static /* synthetic */ boolean access$702(UITopicPoll x0, boolean x1) {
        x0.isEditPoll = x1;
        return x0.isEditPoll;
    }

    static /* synthetic */ void access$800(UITopicPoll x0) throws Exception {
        x0.init();
    }
}

