/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.popup.UIForumAdministrationForm;
import org.exoplatform.forum.webui.popup.UIListTopicOld;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIForumAdministrationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddIpActionListener.class}), @EventConfig(listeners={PostsActionListener.class}), @EventConfig(listeners={UnBanActionListener.class}), @EventConfig(listeners={GetDefaultMailActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RunActionListener.class})})
public class UIForumAdministrationForm
extends UIForm
implements UIPopupComponent {
    private ForumService forumService;
    private ForumAdministration administration;
    private int id = 0;
    private boolean isRenderListTopic = false;
    public static final String FIELD_FORUMSORT_TAB = "forumSortTab";
    public static final String FIELD_CENSOREDKEYWORD_TAB = "forumCensorTab";
    public static final String FIELD_ACTIVETOPIC_TAB = "activeTopicTab";
    public static final String FIELD_NOTIFYEMAIL_TAB = "notifyEmailTab";
    public static final String IP_BAN_TAB = "ipBanTab";
    public static final String NEW_IP_BAN_INPUT = "newIpBan";
    public static final String SEARCH_IP_BAN = "searchIpBan";
    public static final String FIELD_FORUMSORTBY_INPUT = "forumSortBy";
    public static final String FIELD_FORUMSORTBYTYPE_INPUT = "forumSortByType";
    public static final String FIELD_TOPICSORTBY_INPUT = "topicSortBy";
    public static final String FIELD_TOPICSORTBYTYPE_INPUT = "topicSortByType";
    public static final String FIELD_CENSOREDKEYWORD_TEXTAREA = "censorKeyword";
    public static final String FIELD_NOTIFYEMAIL_TEXTAREA = "notifyEmail";
    public static final String FIELD_ACTIVEABOUT_INPUT = "activeAbout";
    public static final String FIELD_SETACTIVE_INPUT = "setActive";
    private List<String> listIpBan = new ArrayList();

    public UIForumAdministrationForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIListTopicOld.class, null, null);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setInit() throws Exception {
        this.administration = this.forumService.getForumAdministration(ForumSessionUtils.getSystemProvider());
        UIFormInputWithActions forumSortTab = new UIFormInputWithActions(FIELD_FORUMSORT_TAB);
        UIFormInputWithActions forumCensorTab = new UIFormInputWithActions(FIELD_CENSOREDKEYWORD_TAB);
        UIFormInputWithActions notifyEmailTab = new UIFormInputWithActions(FIELD_NOTIFYEMAIL_TAB);
        UIFormInputWithActions ipBanTab = new UIFormInputWithActions(IP_BAN_TAB);
        String[] idLables = new String[]{"forumOrder", "isLock", "createdDate", "modifiedDate", "topicCount", "postCount"};
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("forumName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox forumSortBy = new UIFormSelectBox(FIELD_FORUMSORTBY_INPUT, FIELD_FORUMSORTBY_INPUT, ls);
        forumSortBy.setValue(this.administration.getForumSortBy());
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox forumSortByType = new UIFormSelectBox(FIELD_FORUMSORTBYTYPE_INPUT, FIELD_FORUMSORTBYTYPE_INPUT, ls);
        forumSortByType.setValue(this.administration.getForumSortByType());
        idLables = new String[]{"isLock", "createdDate", "modifiedDate", "lastPostDate", "postCount", "viewCount", "numberAttachments"};
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("threadName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox topicSortBy = new UIFormSelectBox(FIELD_TOPICSORTBY_INPUT, FIELD_TOPICSORTBY_INPUT, ls);
        topicSortBy.setValue(this.administration.getTopicSortBy());
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox topicSortByType = new UIFormSelectBox(FIELD_TOPICSORTBYTYPE_INPUT, FIELD_TOPICSORTBYTYPE_INPUT, ls);
        topicSortByType.setValue(this.administration.getTopicSortByType());
        UIFormTextAreaInput censorKeyword = new UIFormTextAreaInput(FIELD_CENSOREDKEYWORD_TEXTAREA, FIELD_CENSOREDKEYWORD_TEXTAREA, null);
        censorKeyword.setValue((Object)this.administration.getCensoredKeyword());
        UIFormStringInput activeAbout = new UIFormStringInput(FIELD_ACTIVEABOUT_INPUT, FIELD_ACTIVEABOUT_INPUT, null);
        activeAbout.setValue((Object)"0");
        activeAbout.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption("true", (Object)"true"));
        options.add(new SelectItemOption("false", (Object)"false"));
        UIFormRadioBoxInput setActive = new UIFormRadioBoxInput(FIELD_SETACTIVE_INPUT, FIELD_SETACTIVE_INPUT, options);
        setActive.setValue((Object)"false");
        String value = this.administration.getNotifyEmailContent();
        if (ForumUtils.isEmpty((String)value)) {
            value = this.getLabel("notifyEmailContentDefault");
        }
        UIFormWYSIWYGInput notifyEmail = new UIFormWYSIWYGInput(FIELD_NOTIFYEMAIL_TEXTAREA, null, "", true);
        notifyEmail.setValue((Object)value);
        forumSortTab.addUIFormInput((UIFormInput)forumSortBy);
        forumSortTab.addUIFormInput((UIFormInput)forumSortByType);
        forumSortTab.addUIFormInput((UIFormInput)topicSortBy);
        forumSortTab.addUIFormInput((UIFormInput)topicSortByType);
        notifyEmailTab.addUIFormInput((UIFormInput)notifyEmail);
        forumCensorTab.addUIFormInput((UIFormInput)censorKeyword);
        this.addUIFormInput((UIFormInput)activeAbout);
        this.addUIFormInput((UIFormInput)setActive);
        this.addUIFormInput((UIFormInputSet)forumSortTab);
        this.addUIFormInput((UIFormInputSet)forumCensorTab);
        this.addUIFormInput((UIFormInputSet)notifyEmailTab);
        if (ForumUtils.enableIPLogging()) {
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_IP_BAN, null));
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT, null));
            this.listIpBan.add("192.168.1.49");
            this.listIpBan.add("192.168.2.1");
        }
    }

    public boolean isRenderListTopic() {
        return this.isRenderListTopic;
    }

    public void setRenderListTopic(boolean isRenderListTopic) {
        this.isRenderListTopic = isRenderListTopic;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    private boolean checkIpAddress(String ipAdd) {
        try {
            int[] ips = new int[ipAdd.split(".").length];
            int i = 0;
            for (String str : ipAdd.split(".")) {
                ips[i++] = Integer.parseInt(str);
            }
            if (ips.length != 4 || ips[0] <= 0 || ips[0] > 255 || ips[0] == 255 && ips[1] == 255 || ips[2] == 255 || ips[3] == 255) {
                return false;
            }
            for (i = 1; i < 4; ++i) {
                if (ips[i] >= 0 && ips[i] <= 255) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static /* synthetic */ ForumAdministration access$000(UIForumAdministrationForm x0) {
        return x0.administration;
    }

    static /* synthetic */ ForumService access$100(UIForumAdministrationForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ int access$202(UIForumAdministrationForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ boolean access$300(UIForumAdministrationForm x0, String x1) {
        return x0.checkIpAddress(x1);
    }
}

