/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIFormSelectBoxForum;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIForumUserSettingForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIFormInputWithActions.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIForumUserSettingForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_USERPROFILE_FORM = "ForumUserProfile";
    public static final String FIELD_USEROPTION_FORM = "ForumUserOption";
    public static final String FIELD_TIMEZONE_SELECTBOX = "TimeZone";
    public static final String FIELD_SHORTDATEFORMAT_SELECTBOX = "ShortDateformat";
    public static final String FIELD_LONGDATEFORMAT_SELECTBOX = "LongDateformat";
    public static final String FIELD_TIMEFORMAT_SELECTBOX = "Timeformat";
    public static final String FIELD_MAXTOPICS_SELECTBOX = "MaximumThreads";
    public static final String FIELD_MAXPOSTS_SELECTBOX = "MaximumPosts";
    public static final String FIELD_FORUMJUMP_CHECKBOX = "ShowForumJump";
    public static final String FIELD_TIMEZONE = "timeZone";
    public static final String FIELD_USERID_INPUT = "ForumUserName";
    public static final String FIELD_USERTITLE_INPUT = "ForumUserTitle";
    public static final String FIELD_SIGNATURE_TEXTAREA = "Signature";
    public static final String FIELD_ISDISPLAYSIGNATURE_CHECKBOX = "IsDisplaySignature";
    public static final String FIELD_ISDISPLAYAVATAR_CHECKBOX = "IsDisplayAvatar";
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private UserProfile userProfile = null;
    private String[] permissionUser = null;

    public UIForumUserSettingForm() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.permissionUser = new String[]{res.getString("UIForumPortlet.label.PermissionAdmin").toLowerCase(), res.getString("UIForumPortlet.label.PermissionModerator").toLowerCase(), res.getString("UIForumPortlet.label.PermissionGuest").toLowerCase(), res.getString("UIForumPortlet.label.PermissionUser").toLowerCase()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForumOption() throws Exception {
        String[] format;
        SessionProvider sProvider = ForumSessionUtils.getSystemProvider();
        try {
            String userId = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile().getUserId();
            this.userProfile = this.forumService.getUserSettingProfile(sProvider, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        String[] timeZone1 = this.getLabel(FIELD_TIMEZONE).split("/");
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        for (String string : timeZone1) {
            list.add(new SelectItemOption(string + "/timeZone", (Object)ForumUtils.getTimeZoneNumberInString((String)string)));
        }
        UIFormSelectBoxForum timeZone = new UIFormSelectBoxForum(FIELD_TIMEZONE_SELECTBOX, FIELD_TIMEZONE_SELECTBOX, list);
        double timeZoneOld = -this.userProfile.getTimeZone();
        Date date = this.getNewDate(timeZoneOld);
        String mark = "-";
        if (timeZoneOld < 0.0) {
            timeZoneOld = -timeZoneOld;
        } else if (timeZoneOld > 0.0) {
            mark = "+";
        } else {
            timeZoneOld = 0.0;
            mark = "";
        }
        timeZone.setValue(mark + timeZoneOld + "0");
        list = new ArrayList();
        for (String frm : format = new String[]{"M-d-yyyy", "M-d-yy", "MM-dd-yy", "MM-dd-yyyy", "yyyy-MM-dd", "yy-MM-dd", "dd-MM-yyyy", "dd-MM-yy", "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy/MM/dd", "yy/MM/dd", "dd/MM/yyyy", "dd/MM/yy"}) {
            list.add(new SelectItemOption(frm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)frm, (Date)date) + ")", (Object)frm));
        }
        UIFormSelectBox shortdateFormat = new UIFormSelectBox(FIELD_SHORTDATEFORMAT_SELECTBOX, FIELD_SHORTDATEFORMAT_SELECTBOX, list);
        shortdateFormat.setValue(this.userProfile.getShortDateFormat());
        list = new ArrayList();
        for (String idFrm : format = new String[]{"DDD,MMMM dd,yyyy", "DDDD,MMMM dd,yyyy", "DDDD,dd MMMM,yyyy", "DDD,MMM dd,yyyy", "DDDD,MMM dd,yyyy", "DDDD,dd MMM,yyyy", "MMMM dd,yyyy", "dd MMMM,yyyy", "MMM dd,yyyy", "dd MMM,yyyy"}) {
            list.add(new SelectItemOption(idFrm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)idFrm, (Date)date) + ")", (Object)idFrm.replaceFirst(" ", "=")));
        }
        UIFormSelectBox longDateFormat = new UIFormSelectBox(FIELD_LONGDATEFORMAT_SELECTBOX, FIELD_LONGDATEFORMAT_SELECTBOX, list);
        longDateFormat.setValue(this.userProfile.getLongDateFormat().replaceFirst(" ", "="));
        list = new ArrayList();
        list.add(new SelectItemOption("12-hour", (Object)"hh:mm=a"));
        list.add(new SelectItemOption("24-hour", (Object)"HH:mm"));
        UIFormSelectBox timeFormat = new UIFormSelectBox(FIELD_TIMEFORMAT_SELECTBOX, FIELD_TIMEFORMAT_SELECTBOX, list);
        timeFormat.setValue(this.userProfile.getTimeFormat().replace(' ', '='));
        list = new ArrayList();
        for (int i = 5; i <= 45; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumThreads = new UIFormSelectBox(FIELD_MAXTOPICS_SELECTBOX, FIELD_MAXTOPICS_SELECTBOX, list);
        maximumThreads.setValue("id" + this.userProfile.getMaxTopicInPage());
        list = new ArrayList();
        for (int i = 5; i <= 35; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumPosts = new UIFormSelectBox(FIELD_MAXPOSTS_SELECTBOX, FIELD_MAXPOSTS_SELECTBOX, list);
        maximumPosts.setValue("id" + this.userProfile.getMaxPostInPage());
        boolean isJump = this.userProfile.getIsShowForumJump();
        UIFormCheckBoxInput isShowForumJump = new UIFormCheckBoxInput(FIELD_FORUMJUMP_CHECKBOX, FIELD_FORUMJUMP_CHECKBOX, (Object)isJump);
        isShowForumJump.setChecked(isJump);
        UIFormStringInput userId = new UIFormStringInput(FIELD_USERID_INPUT, FIELD_USERID_INPUT, null);
        userId.setValue((Object)this.userProfile.getUserId());
        userId.setEditable(false);
        userId.setEnable(false);
        UIFormStringInput userTitle = new UIFormStringInput(FIELD_USERTITLE_INPUT, FIELD_USERTITLE_INPUT, null);
        userTitle.setValue((Object)this.userProfile.getUserTitle());
        if (this.userProfile.getUserRole() > 0L) {
            userTitle.setEditable(false);
            userTitle.setEnable(false);
        }
        UIFormTextAreaInput signature = new UIFormTextAreaInput(FIELD_SIGNATURE_TEXTAREA, FIELD_SIGNATURE_TEXTAREA, null);
        signature.setValue((Object)this.userProfile.getSignature());
        UIFormCheckBoxInput isDisplaySignature = new UIFormCheckBoxInput(FIELD_ISDISPLAYSIGNATURE_CHECKBOX, FIELD_ISDISPLAYSIGNATURE_CHECKBOX, (Object)false);
        isDisplaySignature.setChecked(this.userProfile.getIsDisplaySignature());
        UIFormCheckBoxInput isDisplayAvatar = new UIFormCheckBoxInput(FIELD_ISDISPLAYAVATAR_CHECKBOX, FIELD_ISDISPLAYAVATAR_CHECKBOX, (Object)false);
        isDisplayAvatar.setChecked(this.userProfile.getIsDisplayAvatar());
        UIFormInputWithActions inputSetProfile = new UIFormInputWithActions(FIELD_USERPROFILE_FORM);
        inputSetProfile.addUIFormInput((UIFormInput)userId);
        inputSetProfile.addUIFormInput((UIFormInput)userTitle);
        inputSetProfile.addUIFormInput((UIFormInput)signature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplaySignature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplayAvatar);
        UIFormInputWithActions inputSetOption = new UIFormInputWithActions(FIELD_USEROPTION_FORM);
        inputSetOption.addUIFormInput((UIFormInput)timeZone);
        inputSetOption.addUIFormInput((UIFormInput)shortdateFormat);
        inputSetOption.addUIFormInput((UIFormInput)longDateFormat);
        inputSetOption.addUIFormInput((UIFormInput)timeFormat);
        inputSetOption.addUIFormInput((UIFormInput)maximumThreads);
        inputSetOption.addUIFormInput((UIFormInput)maximumPosts);
        inputSetOption.addUIFormInput((UIFormInput)isShowForumJump);
        this.addUIFormInput((UIFormInputSet)inputSetProfile);
        this.addUIFormInput((UIFormInputSet)inputSetOption);
    }

    private Date getNewDate(double timeZoneOld) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset + (long)(timeZoneOld * 3600000.0));
        return calendar.getTime();
    }

    public UIFormSelectBoxForum getUIFormSelectBoxForum(String name) {
        return (UIFormSelectBoxForum)this.findComponentById(name);
    }

    public void activate() throws Exception {
        this.initForumOption();
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ UserProfile access$000(UIForumUserSettingForm x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String[] access$100(UIForumUserSettingForm x0) {
        return x0.permissionUser;
    }

    static /* synthetic */ ForumService access$200(UIForumUserSettingForm x0) {
        return x0.forumService;
    }
}

