/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListPostByIP;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPageListPostByIP.gtmpl", events={@EventConfig(listeners={OpenPostLinkActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={DeletePostLinkActionListener.class}, confirm="UITopicDetail.confirm.DeleteThisPost")})
public class UIPageListPostByIP
extends UIForm
implements UIPopupComponent {
    private ForumService forumService;
    private UserProfile userProfile = null;
    private String userName = null;
    private String ip_ = null;
    private String strOrderBy = "createdDate descending";
    private boolean hasEnableIPLogging = true;
    private List<Post> posts = new ArrayList();

    public UIPageListPostByIP() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIForumPageIterator.class, null, "PageListPostByUser");
        this.setActions(new String[]{"Cancel"});
    }

    public boolean getHasEnableIPLogging() {
        return this.hasEnableIPLogging;
    }

    private UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            this.userProfile = forumPortlet.getUserProfile();
            this.hasEnableIPLogging = forumPortlet.isEnableIPLogging();
        }
        return this.userProfile;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userId) {
        this.userName = userId;
    }

    public void setIp(String ip) {
        this.ip_ = ip;
        this.strOrderBy = "createdDate descending";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Post> getPostsByUser() throws Exception {
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        ArrayList<Post> posts = null;
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            boolean isMod = false;
            if (this.userProfile.getUserRole() < 2L) {
                isMod = true;
            }
            JCRPageList pageList = this.forumService.getListPostsByIP(this.ip_, this.strOrderBy, sProvider);
            forumPageIterator.updatePageList(pageList);
            if (pageList != null) {
                pageList.setPageSize(6L);
            }
            posts = pageList.getPage(forumPageIterator.getPageSelected());
            forumPageIterator.setSelectPage(pageList.getCurrentPage());
        }
        finally {
            sProvider.close();
        }
        if (posts == null) {
            posts = new ArrayList<Post>();
        }
        this.posts = posts;
        return posts;
    }

    private Post getPostById(String postId) {
        for (Post post : this.posts) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return null;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ Post access$000(UIPageListPostByIP x0, String x1) {
        return x0.getPostById(x1);
    }

    static /* synthetic */ UserProfile access$100(UIPageListPostByIP x0) {
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$200(UIPageListPostByIP x0) {
        return x0.forumService;
    }

    static /* synthetic */ String access$300(UIPageListPostByIP x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$302(UIPageListPostByIP x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }
}

