/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.popup.UIForumInputWithActions;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.forum.webui.popup.UITopicForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UITopicForm.gtmpl", events={@EventConfig(listeners={PreviewThreadActionListener.class}), @EventConfig(listeners={SubmitThreadActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectIconActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE)})
public class UITopicForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String FIELD_THREADCONTEN_TAB = "ThreadContent";
    public static final String FIELD_THREADICON_TAB = "ThreadIcon";
    public static final String FIELD_THREADOPTION_TAB = "ThreadOption";
    public static final String FIELD_THREADPERMISSION_TAB = "ThreadPermission";
    public static final String FIELD_TOPICTITLE_INPUT = "ThreadTitle";
    public static final String FIELD_EDITREASON_INPUT = "editReason";
    public static final String FIELD_MESSAGE_TEXTAREA = "Message";
    public static final String FIELD_MESSAGECONTENT = "messageContent";
    public static final String FIELD_TOPICSTATUS_SELECTBOX = "TopicStatus";
    public static final String FIELD_TOPICSTATE_SELECTBOX = "TopicState";
    public static final String FIELD_APPROVED_CHECKBOX = "Approved";
    public static final String FIELD_MODERATEPOST_CHECKBOX = "ModeratePost";
    public static final String FIELD_NOTIFYWHENADDPOST_CHECKBOX = "NotifyWhenAddPost";
    public static final String FIELD_STICKY_CHECKBOX = "Sticky";
    public static final String FIELD_CANVIEW_INPUT = "CanView";
    public static final String FIELD_CANPOST_INPUT = "CanPost";
    public static final String ACT_REMOVE = "remove";
    public static final String FIELD_ATTACHMENTS = "attachments";
    private List<ForumAttachment> attachments_ = new ArrayList();
    private String categoryId;
    private String forumId;
    private String topicId;
    private String link = "";
    private Forum forum;
    private boolean isMod = false;
    private int id = 0;
    private Topic topic = new Topic();

    public UITopicForm() throws Exception {
        UIFormStringInput topicTitle = new UIFormStringInput(FIELD_TOPICTITLE_INPUT, FIELD_TOPICTITLE_INPUT, null);
        topicTitle.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput editReason = new UIFormStringInput(FIELD_EDITREASON_INPUT, FIELD_EDITREASON_INPUT, null);
        editReason.setRendered(false);
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("Open", (Object)"open"));
        ls.add(new SelectItemOption("Closed", (Object)"closed"));
        UIFormSelectBox topicState = new UIFormSelectBox(FIELD_TOPICSTATE_SELECTBOX, FIELD_TOPICSTATE_SELECTBOX, ls);
        topicState.setDefaultValue((Object)"open");
        ArrayList<SelectItemOption> ls1 = new ArrayList<SelectItemOption>();
        ls1.add(new SelectItemOption("UnLock", (Object)"unlock"));
        ls1.add(new SelectItemOption("Locked", (Object)"locked"));
        UIFormSelectBox topicStatus = new UIFormSelectBox(FIELD_TOPICSTATUS_SELECTBOX, FIELD_TOPICSTATUS_SELECTBOX, ls1);
        topicStatus.setDefaultValue((Object)"unlock");
        UIFormCheckBoxInput moderatePost = new UIFormCheckBoxInput(FIELD_MODERATEPOST_CHECKBOX, FIELD_MODERATEPOST_CHECKBOX, (Object)false);
        UIFormCheckBoxInput checkWhenAddPost = new UIFormCheckBoxInput(FIELD_NOTIFYWHENADDPOST_CHECKBOX, FIELD_NOTIFYWHENADDPOST_CHECKBOX, (Object)false);
        UIFormCheckBoxInput sticky = new UIFormCheckBoxInput(FIELD_STICKY_CHECKBOX, FIELD_STICKY_CHECKBOX, (Object)false);
        UIFormTextAreaInput canView = new UIFormTextAreaInput(FIELD_CANVIEW_INPUT, FIELD_CANVIEW_INPUT, null);
        UIFormTextAreaInput canPost = new UIFormTextAreaInput(FIELD_CANPOST_INPUT, FIELD_CANPOST_INPUT, null);
        UIFormWYSIWYGInput formWYSIWYGInput = new UIFormWYSIWYGInput(FIELD_MESSAGECONTENT, null, null, true);
        formWYSIWYGInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector(FIELD_THREADICON_TAB, FIELD_THREADICON_TAB);
        uiIconSelector.setSelectedIcon("IconsView");
        UIForumInputWithActions threadContent = new UIForumInputWithActions(FIELD_THREADCONTEN_TAB);
        threadContent.addUIFormInput((UIFormInput)topicTitle);
        threadContent.addUIFormInput((UIFormInput)editReason);
        threadContent.addUIFormInput((UIFormInput)formWYSIWYGInput);
        threadContent.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        threadContent.setActionField(FIELD_THREADCONTEN_TAB, this.getUploadFileList());
        UIForumInputWithActions threadOption = new UIForumInputWithActions(FIELD_THREADOPTION_TAB);
        threadOption.addUIFormInput((UIFormInput)topicState);
        threadOption.addUIFormInput((UIFormInput)topicStatus);
        threadOption.addUIFormInput((UIFormInput)moderatePost);
        threadOption.addUIFormInput((UIFormInput)checkWhenAddPost);
        threadOption.addUIFormInput((UIFormInput)sticky);
        UIForumInputWithActions threadPermission = new UIForumInputWithActions(FIELD_THREADPERMISSION_TAB);
        threadPermission.addUIFormInput((UIFormInput)canPost);
        threadPermission.addUIFormInput((UIFormInput)canView);
        String[] fieldPermissions = new String[]{FIELD_CANVIEW_INPUT, FIELD_CANPOST_INPUT};
        String[] strings = new String[]{"SelectUser", "SelectMemberShip", "SelectGroup"};
        for (String fieldPermission : fieldPermissions) {
            ArrayList<UIForumInputWithActions.ActionData> actions = new ArrayList<UIForumInputWithActions.ActionData>();
            int i = 0;
            for (String string : strings) {
                UIForumInputWithActions.ActionData ad = new UIForumInputWithActions.ActionData();
                ad.setActionListener("AddValuesUser");
                ad.setActionParameter(fieldPermission + "/" + String.valueOf(i));
                ad.setCssIconClass(string + "Icon");
                ad.setActionName(string);
                actions.add(ad);
                ++i;
            }
            threadPermission.setActionField(fieldPermission, actions);
        }
        this.addUIFormInput((UIFormInputSet)threadContent);
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.addUIFormInput((UIFormInputSet)threadOption);
        this.addUIFormInput((UIFormInputSet)threadPermission);
        this.setActions(new String[]{"PreviewThread", "SubmitThread", "Attachment", "Cancel"});
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setTopicIds(String categoryId, String forumId, Forum forum) {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topic = new Topic();
        this.forum = forum;
        UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById(FIELD_THREADCONTEN_TAB);
        threadContent.getUIStringInput(FIELD_EDITREASON_INPUT).setRendered(false);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    public List<UIForumInputWithActions.ActionData> getUploadFileList() {
        ArrayList<UIForumInputWithActions.ActionData> uploadedFiles = new ArrayList<UIForumInputWithActions.ActionData>();
        for (ForumAttachment attachdata : this.attachments_) {
            UIForumInputWithActions.ActionData fileUpload = new UIForumInputWithActions.ActionData();
            fileUpload.setActionListener("");
            fileUpload.setActionType(2);
            fileUpload.setCssIconClass("AttachmentIcon ZipFileIcon");
            String fileName = ForumUtils.getSizeFile((double)attachdata.getSize());
            fileName = attachdata.getName() + "(" + fileName + ")";
            fileUpload.setActionName(fileName);
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIForumInputWithActions.ActionData removeAction = new UIForumInputWithActions.ActionData();
            removeAction.setActionListener("RemoveAttachment");
            removeAction.setActionName(ACT_REMOVE);
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setActionType(1);
            removeAction.setBreakLine(true);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void refreshUploadFileList() throws Exception {
        UIForumInputWithActions inputSet = (UIForumInputWithActions)this.getChildById(FIELD_THREADCONTEN_TAB);
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    public void addToUploadFileList(ForumAttachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(ForumAttachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void removeUploadFileList() {
        this.attachments_.clear();
    }

    public List<ForumAttachment> getAttachFileList() {
        return this.attachments_;
    }

    public void setUpdateTopic(Topic topic, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.topic = topic;
            this.topicId = topic.getId();
            UIForumInputWithActions threadContent = (UIForumInputWithActions)this.getChildById(FIELD_THREADCONTEN_TAB);
            threadContent.getUIStringInput(FIELD_EDITREASON_INPUT).setRendered(true);
            threadContent.getUIStringInput(FIELD_TOPICTITLE_INPUT).setValue((Object)ForumTransformHTML.unCodeHTML((String)topic.getTopicName()));
            ((UIFormWYSIWYGInput)threadContent.getChild(UIFormWYSIWYGInput.class)).setValue((Object)ForumTransformHTML.enCodeHTML((String)topic.getDescription()));
            UIForumInputWithActions threadOption = (UIForumInputWithActions)this.getChildById(FIELD_THREADOPTION_TAB);
            String stat = "open";
            if (topic.getIsClosed()) {
                stat = "closed";
            }
            threadOption.getUIFormSelectBox(FIELD_TOPICSTATE_SELECTBOX).setValue(stat);
            stat = topic.getIsLock() ? "locked" : "unlock";
            threadOption.getUIFormSelectBox(FIELD_TOPICSTATUS_SELECTBOX).setValue(stat);
            threadOption.getUIFormCheckBoxInput(FIELD_MODERATEPOST_CHECKBOX).setChecked(topic.getIsModeratePost());
            if (topic.getIsNotifyWhenAddPost() != null && topic.getIsNotifyWhenAddPost().trim().length() > 0) {
                threadOption.getUIFormCheckBoxInput(FIELD_NOTIFYWHENADDPOST_CHECKBOX).setChecked(true);
            }
            threadOption.getUIFormCheckBoxInput(FIELD_STICKY_CHECKBOX).setChecked(topic.getIsSticky());
            UIForumInputWithActions threadPermission = (UIForumInputWithActions)this.getChildById(FIELD_THREADPERMISSION_TAB);
            threadPermission.getUIStringInput(FIELD_CANVIEW_INPUT).setValue((Object)ForumUtils.unSplitForForum((String[])topic.getCanView()));
            threadPermission.getUIStringInput(FIELD_CANPOST_INPUT).setValue((Object)ForumUtils.unSplitForForum((String[])topic.getCanPost()));
            ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
            String postId = this.topicId.replaceFirst(Utils.TOPIC, Utils.POST);
            Post post = forumService.getPost(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId, this.topicId, postId);
            if (post.getAttachments() != null && post.getAttachments().size() > 0) {
                this.attachments_ = post.getAttachments();
                this.refreshUploadFileList();
            }
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(topic.getIcon());
        }
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormTextAreaInput fieldInput = this.getUIFormTextAreaInput(selectField);
        String values = (String)fieldInput.getValue();
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])(values = ForumUtils.removeSpaceInString((String)values)).split(","), (String)value)) {
                if (values.lastIndexOf(",") != values.length() - 1) {
                    values = values + ",";
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        fieldInput.setValue((Object)values);
    }

    public boolean isMod() {
        return this.isMod;
    }

    public void setMod(boolean isMod) {
        this.isMod = isMod;
    }

    static /* synthetic */ List access$000(UITopicForm x0) {
        return x0.attachments_;
    }

    static /* synthetic */ Forum access$100(UITopicForm x0) {
        return x0.forum;
    }

    static /* synthetic */ String access$200(UITopicForm x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$300(UITopicForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ Topic access$400(UITopicForm x0) {
        return x0.topic;
    }

    static /* synthetic */ String access$500(UITopicForm x0) {
        return x0.topicId;
    }

    static /* synthetic */ Topic access$402(UITopicForm x0, Topic x1) {
        x0.topic = x1;
        return x0.topic;
    }

    static /* synthetic */ int access$602(UITopicForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }
}

