/***************************************************************************
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 ***************************************************************************/
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumSearch;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.popup.UIBanIPForumManagerForm;
import org.exoplatform.forum.webui.popup.UIExportForm;
import org.exoplatform.forum.webui.popup.UIForumForm;
import org.exoplatform.forum.webui.popup.UIMergeTopicForm;
import org.exoplatform.forum.webui.popup.UIMoveForumForm;
import org.exoplatform.forum.webui.popup.UIMoveTopicForm;
import org.exoplatform.forum.webui.popup.UIPageListTopicUnApprove;
import org.exoplatform.forum.webui.popup.UIPopupAction;
import org.exoplatform.forum.webui.popup.UIPopupContainer;
import org.exoplatform.forum.webui.popup.UITopicForm;
import org.exoplatform.forum.webui.popup.UIWatchToolsForm;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

/**
 * Created by The eXo Platform SARL Author : Hung Nguyen
 * hung.nguyen@exoplatform.com Aus 01, 2007 2:48:18 PM
 */

@ComponentConfig(
	lifecycle = UIFormLifecycle.class,
	template =	"app:/templates/forum/webui/UITopicContainer.gtmpl", 
	events = {
		@EventConfig(listeners = UITopicContainer.SearchFormActionListener.class ),	
		@EventConfig(listeners = UITopicContainer.GoNumberPageActionListener.class ),	
		@EventConfig(listeners = UITopicContainer.AddTopicActionListener.class ),	
		@EventConfig(listeners = UITopicContainer.OpenTopicActionListener.class ),
		@EventConfig(listeners = UITopicContainer.OpenTopicsTagActionListener.class ),
		@EventConfig(listeners = UITopicContainer.ApproveTopicsActionListener.class ),// Menu
																																									// Forum
		@EventConfig(listeners = UITopicContainer.EditForumActionListener.class ),	
		@EventConfig(listeners = UITopicContainer.SetLockedForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetUnLockForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetOpenForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetCloseForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.MoveForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.RemoveForumActionListener.class,confirm="UITopicContainer.confirm.RemoveForum"),// Menu
																																																															// Topic
		@EventConfig(listeners = UITopicContainer.WatchOptionActionListener.class),
		
		@EventConfig(listeners = UITopicContainer.EditTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetOpenTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetCloseTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetLockedTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetUnLockTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetStickTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetUnStickTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetMoveTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.MergeTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetDeleteTopicActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetUnWaitingActionListener.class),
		@EventConfig(listeners = UITopicContainer.SetOrderByActionListener.class),
		@EventConfig(listeners = UITopicContainer.AddWatchingActionListener.class),
		@EventConfig(listeners = UITopicContainer.AddBookMarkActionListener.class),
		@EventConfig(listeners = UITopicContainer.ExportForumActionListener.class),
		@EventConfig(listeners = UITopicContainer.AdvancedSearchActionListener.class),
		@EventConfig(listeners = UITopicContainer.BanIpForumToolsActionListener.class),
		@EventConfig(listeners = UIForumKeepStickPageIterator.GoPageActionListener.class)
	}
)
public class UITopicContainer extends UIForumKeepStickPageIterator {
	@SuppressWarnings("unused")
  private boolean useAjax = true;
	private ForumService forumService ;
	private String forumId = "";
	private String categoryId = "";
	private Forum forum;
//	private JCRPageList pageList ;
	private List <Topic> topicList ;
	private boolean isUpdate = false;
	private boolean isModerator = false ;
	private boolean canAddNewThread = true ;
	private UserProfile userProfile = null;
	private String strOrderBy = "" ;
	private boolean isLogin = false;
	private boolean isNull = false; 
	private boolean enableIPLogging = true;
	public boolean isNull() { return isNull; }
	public void setNull(boolean isNull) { this.isNull = isNull;}
	public boolean isLogin() {return isLogin;}
	public void setLogin(boolean isLogin) {this.isLogin = isLogin;}

	public UITopicContainer() throws Exception {
		forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class) ;
		addUIFormInput( new UIFormStringInput(ForumUtils.GOPAGE_ID_T, null)) ;
		addUIFormInput( new UIFormStringInput(ForumUtils.GOPAGE_ID_B, null)) ;
		addUIFormInput( new UIFormStringInput(ForumUtils.SEARCHFORM_ID, null)) ;
		if(ForumSessionUtils.getCurrentUser() != null) isLogin = true;
	}
	@SuppressWarnings("unused")
	private UserProfile getUserProfile() { return userProfile ;}

	public void setUpdateForum(String categoryId, Forum forum) throws Exception {
		this.forum = forum ;
		this.forumId = forum.getId() ;
		this.categoryId = categoryId ;
		this.pageSelect = 1 ;
		UIForumPortlet forumPortlet = this.getAncestorOfType(UIForumPortlet.class);
		this.useAjax = forumPortlet.isUseAjax();
		enableIPLogging = forumPortlet.isEnableIPLogging() ;
		forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath((categoryId + "/" + forumId)) ;
		forumPortlet.updateAccessForum(forumId);
		this.userProfile = forumPortlet.getUserProfile() ;
		cleanCheckedList();
	}
	
	public void setIdUpdate(boolean isUpdate) { this.isUpdate = isUpdate;}
	
	public void updateByBreadcumbs(String categoryId, String forumId, boolean isBreadcumbs) throws Exception {
		this.forumId = forumId ;
		this.categoryId = categoryId ;
		this.isUpdate = true ;
		this.pageSelect = 1 ;
		UIForumPortlet forumPortlet = this.getAncestorOfType(UIForumPortlet.class);
		this.useAjax = forumPortlet.isUseAjax();
		enableIPLogging = forumPortlet.isEnableIPLogging() ;
		forumPortlet.updateAccessForum(forumId);
		this.userProfile = forumPortlet.getUserProfile() ;
		if(!isBreadcumbs) {
			forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath((categoryId + "/" + forumId)) ;
		}
		cleanCheckedList();
	}

	public boolean getCanAddNewThread(){return this.canAddNewThread ; }
	
	private Forum getForum() throws Exception {
		if(this.isUpdate) {
			this.forum = forumService.getForum(ForumSessionUtils.getSystemProvider(), categoryId, forumId);
			this.isUpdate = false ;
		}
		UIForumContainer forumContainer = this.getParent() ;
		if(this.forum != null)
			forumContainer.findFirstComponentOfType(UIForumInfos.class).setForum(this.forum);
		return this.forum ;
	}
	
	@SuppressWarnings("unused")
	private void initPage() throws Exception {
		this.canAddNewThread = true ;
		if(userProfile == null) userProfile = new UserProfile();
		StringBuffer strQuery = new StringBuffer() ;
		long role = userProfile.getUserRole() ;
		String userId = userProfile.getUserId() ;
		List<String> ipBaneds = forum.getBanIP();
		isModerator = false ;
		if(role == 0 || ForumServiceUtils.hasPermission(forum.getModerators(), userId)) isModerator = true;
		if(ipBaneds != null && ipBaneds.size() > 0) {
			if(!ipBaneds.contains(getIPRemoter())) {
				String[] strings = this.forum.getCreateTopicRole() ;
				if(strings != null && strings.length > 0){
					canAddNewThread = ForumServiceUtils.hasPermission(strings, userId) ;
				}
			} else canAddNewThread = false;
		} else {
			if(!isModerator) {
				String[] strings = this.forum.getCreateTopicRole() ;
				if(strings != null && strings.length > 0){
					canAddNewThread = ForumServiceUtils.hasPermission(strings, userId) ;
				}
			}
		}
		if(!isModerator) {
			strQuery.append("@exo:isClosed='false' and @exo:isWaiting='false'");
			boolean isView = ForumServiceUtils.hasPermission(forum.getPoster(), userId) ;
			if(!isView) isView = ForumServiceUtils.hasPermission(forum.getViewer(), userId) ;
			if(!isView) {
				strQuery.append(" and (@exo:owner='").append(userId).append("' or @exo:canView=' ' or @exo:canPost=' '") ;
				for (String string : ForumSessionUtils.getAllGroupAndMembershipOfUser(userId)) {
					strQuery.append(" or @exo:canView='"+string+"' or @exo:canPost='"+string+"'") ;
				}
				strQuery.append(")");
			}
		}
		if(!isModerator && this.forum.getIsModerateTopic()) {
			if(!ForumUtils.isEmpty(strQuery.toString())) strQuery.append(" and ") ;
			strQuery.append("@exo:isApproved='true'") ;
		}
		this.pageList = forumService.getPageTopic(ForumSessionUtils.getSystemProvider(), categoryId, forumId, strQuery.toString(), strOrderBy);
		long maxTopic = userProfile.getMaxTopicInPage() ;
		if(maxTopic <= 0) maxTopic = 10 ;
		try{
			this.pageList.setPageSize(maxTopic);
		}catch (NullPointerException e) {
			isNull = true;
		}
	}
	
	private String getIPRemoter() throws Exception {
		if(enableIPLogging) {
			WebuiRequestContext	context =	RequestContext.getCurrentInstance() ;
			PortletRequestImp request = context.getRequest() ;
			return request.getRemoteAddr();
		}
		return "";
	}
	
	@SuppressWarnings("unused")
	private String[] getActionMenuForum() throws Exception {
		String []actions ;
		if(userProfile.getUserRole() == 0) actions = new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", 
				"MoveForum", "RemoveForum", "ExportForum", "WatchOption", "BanIpForumTools"};
		else actions = new String[]{"EditForum", "SetUnLockForum", "SetLockedForum", "SetOpenForum", "SetCloseForum", 
				"ExportForum", "WatchOption", "BanIpForumTools"};
		return actions;
	}

	@SuppressWarnings("unused")
	private String[] getActionMenuTopic() throws Exception {
		String []actions = {"EditTopic", "SetOpenTopic", "SetCloseTopic", "SetLockedTopic", "SetUnLockTopic", "SetStickTopic",
				"SetUnStickTopic", "SetMoveTopic", "SetDeleteTopic", "MergeTopic", "SetUnWaiting", "ApproveTopics"}; 
		return actions;
	}
	
	@SuppressWarnings({ "unchecked", "unused" })
  private List<Topic> getTopicPageLits() throws Exception {
		maxPage = this.pageList.getAvailablePage() ;
		if(this.pageSelect > maxPage)this.pageSelect = maxPage ;
		List<Topic> topics = pageList.getPage(pageSelect);
		pageSelect = pageList.getCurrentPage();
		if(topics == null) topics = new ArrayList<Topic>(); 
		this.topicList = topics;
		for(Topic topic : this.topicList) {
			if(getUIFormCheckBoxInput(topic.getId()) != null) {
				getUIFormCheckBoxInput(topic.getId()).setChecked(false) ;
			}else {
				UIFormCheckBoxInput<Boolean> checkItem = new UIFormCheckBoxInput<Boolean>(topic.getId(), topic.getId(), false);
				addChild(checkItem);
			}
		}
		return this.topicList ;
	}
	
	@SuppressWarnings("unchecked")
  private Topic getTopicByAll(String topicId) throws Exception {
		List<Topic> listTopic = this.pageList.getPage(0) ;
		for (Topic topic : listTopic) {
			if(topic.getId().equals(topicId)) return topic ;
		}
		return null ;
	}
	
	@SuppressWarnings("unchecked")
  private Topic getTopic(String topicId) throws Exception {
		for (Topic topic : topicList) {
			if(topic.getId().equals(topicId)) return topic ;
		}
		return null ;
	}
	
	@SuppressWarnings("unused")
  private long getSizePost(Topic topic) throws Exception {
		long maxPost = userProfile.getMaxPostInPage() ;
		if(maxPost <= 0) maxPost = 10;
		if(topic.getPostCount() > maxPost) {
			long availablePost = 0;
			if(isModerator){
				availablePost = topic.getPostCount()+1;
			} else {
				String isApprove = "" ;
				String userLogin = userProfile.getUserId();
				if(this.forum.getIsModeratePost() || topic.getIsModeratePost()) {
					if(!(topic.getOwner().equals(userLogin))) isApprove = "true" ;
				}
				availablePost = this.forumService.getAvailablePost(ForumSessionUtils.getSystemProvider(), this.categoryId, this.forumId, topic.getId(), isApprove, "false", userLogin)	;
			}
			long value = availablePost/maxPost;
			if((value*maxPost) < availablePost) value = value + 1;
			return value;
		} else return 1;
	}
	
	@SuppressWarnings("unused")
	private String[] getStarNumber(Topic topic) throws Exception {
		double voteRating = topic.getVoteRating() ;
		return ForumUtils.getStarNumber(voteRating) ;
	}

	@SuppressWarnings("unused")
	private List<Tag> getTagsByTopic(String[] tagIds) throws Exception {
		return this.forumService.getTagsByTopic(ForumSessionUtils.getSystemProvider(), tagIds);	
	}
	
	static public class SearchFormActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource() ;
			String path = uiTopicContainer.forum.getPath() ;
			UIFormStringInput formStringInput = uiTopicContainer.getUIStringInput(ForumUtils.SEARCHFORM_ID) ;
			String text = formStringInput.getValue() ;
			if(!ForumUtils.isEmpty(text) && !ForumUtils.isEmpty(path)) {
				String special = "\\,.?!`~/][)(;#@$%^&*<>-_+=";
				for (int i = 0; i < special.length(); i++) {
					char c = special.charAt(i);
					if(text.indexOf(c) >= 0) {
						UIApplication uiApp = uiTopicContainer.getAncestorOfType(UIApplication.class) ;
						uiApp.addMessage(new ApplicationMessage("UIQuickSearchForm.msg.failure", null, ApplicationMessage.WARNING)) ;
						return ;
					}
				}
				StringBuffer type = new StringBuffer();
				if(uiTopicContainer.isModerator){ 
					type.append("true,").append(Utils.TOPIC).append("/").append(Utils.POST);
				} else {
					type.append("false,").append(Utils.TOPIC).append("/").append(Utils.POST);
				}
				UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
				forumPortlet.updateIsRendered(ForumUtils.CATEGORIES) ;
				UICategoryContainer categoryContainer = forumPortlet.getChild(UICategoryContainer.class);
				categoryContainer.updateIsRender(true);
				UICategories categories = categoryContainer.getChild(UICategories.class);
				categories.setIsRenderChild(true) ;
				ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class) ;
				List<ForumSearch> list = forumService.getQuickSearch(ForumSessionUtils.getSystemProvider(), text, type.toString(), path, ForumSessionUtils.getAllGroupAndMembershipOfUser(uiTopicContainer.getUserProfile().getUserId()));
				UIForumListSearch listSearchEvent = categories.getChild(UIForumListSearch.class) ;
				listSearchEvent.setListSearchEvent(list) ;
				forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath(ForumUtils.FIELD_EXOFORUM_LABEL) ;
				formStringInput.setValue("") ;
				event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
			} else {
				Object[] args = { };
				throw new MessageException(new ApplicationMessage("UIQuickSearchForm.msg.checkEmpty", args, ApplicationMessage.WARNING)) ;
			}
			
		}
	}
	
	static public class GoNumberPageActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer topicContainer = event.getSource() ;
			int idbt = Integer.parseInt(event.getRequestContext().getRequestParameter(OBJECTID)) ;
			UIFormStringInput stringInput1 = topicContainer.getUIStringInput(ForumUtils.GOPAGE_ID_T) ;
			UIFormStringInput stringInput2 = topicContainer.getUIStringInput(ForumUtils.GOPAGE_ID_B) ;
			String numberPage = "" ;
			if(idbt == 1) {
				numberPage = stringInput1.getValue() ;
			} else {
				numberPage = stringInput2.getValue() ;
			}
			stringInput1.setValue("") ; stringInput2.setValue("") ;
			numberPage = ForumUtils.removeZeroFirstNumber(numberPage) ;
			if(!ForumUtils.isEmpty(numberPage)) {
				try {
					long page = Long.parseLong(numberPage.trim()) ;
					if(page < 0) {
						Object[] args = { "go page" };
						throw new MessageException(new ApplicationMessage("NameValidator.msg.Invalid-number", args, ApplicationMessage.WARNING)) ;
					} else {
						if(page == 0) {
							page = (long)1;
						} else if(page > topicContainer.pageList.getAvailablePage()){
							page = topicContainer.pageList.getAvailablePage() ;
						}
						topicContainer.pageSelect = page ;
						event.getRequestContext().addUIComponentToUpdateByAjax(topicContainer) ;
					}
				} catch (NumberFormatException e) {
					Object[] args = { "go page" };
					throw new MessageException(new ApplicationMessage("NameValidator.msg.Invalid-number", args, ApplicationMessage.WARNING)) ;
				}
			}
		}
	}
	
	static public class AddTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource() ;
			UIForumPortlet forumPortlet =uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIPopupContainer popupContainer = popupAction.createUIComponent(UIPopupContainer.class, null, null) ;
			UITopicForm topicForm = popupContainer.addChild(UITopicForm.class, null, null) ;
			topicForm.setTopicIds(uiTopicContainer.categoryId, uiTopicContainer.forumId, uiTopicContainer.forum) ;
			topicForm.setMod(uiTopicContainer.isModerator) ;
			popupContainer.setId("UIAddTopicContainer") ;
			popupAction.activate(popupContainer, 850, 500) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
		}
	}
	
	static public class OpenTopicsTagActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource() ;
			String tagId = event.getRequestContext().getRequestParameter(OBJECTID) ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			forumPortlet.updateIsRendered(ForumUtils.TAG) ;
			forumPortlet.getChild(UIForumLinks.class).setValueOption(Utils.FORUM_SERVICE) ;
			forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath(tagId) ;
			forumPortlet.getChild(UITopicsTag.class).setIdTag(tagId) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}
	
	static public class OpenTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			String idAndNumber = event.getRequestContext().getRequestParameter(OBJECTID) ;
			String []temp = idAndNumber.split(",") ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			try {
				Topic topic = uiTopicContainer.getTopic(temp[0]) ;
				//boolean isReadTopic = ForumUtils.isStringInStrings(uiTopicContainer.userProfile.getReadTopic(), topic.getId());
				UIForumContainer uiForumContainer = forumPortlet.getChild(UIForumContainer.class) ;
				UITopicDetailContainer uiTopicDetailContainer = uiForumContainer.getChild(UITopicDetailContainer.class) ;
				uiForumContainer.setIsRenderChild(false) ;
				UITopicDetail uiTopicDetail = uiTopicDetailContainer.getChild(UITopicDetail.class) ;
				uiTopicDetail.setUpdateForum(uiTopicContainer.forum) ;
				uiTopicDetailContainer.getChild(UITopicPoll.class).updateFormPoll(uiTopicContainer.categoryId, uiTopicContainer.forumId, topic.getId() ) ;
				forumPortlet.getChild(UIForumLinks.class).setValueOption((uiTopicContainer.categoryId+"/"+ uiTopicContainer.forumId + " "));
				if(temp[2].equals("true")) {
					uiTopicDetail.setIdPostView("lastpost") ;
				} else {
					uiTopicDetail.setIdPostView("top") ;
				}
				uiTopicDetail.setUpdateContainer(uiTopicContainer.categoryId, uiTopicContainer.forumId, topic, Long.parseLong(temp[1])) ;
				
				WebuiRequestContext context = event.getRequestContext() ;
				context.addUIComponentToUpdateByAjax(uiForumContainer) ;
				context.addUIComponentToUpdateByAjax(forumPortlet.getChild(UIBreadcumbs.class)) ;
			} catch (NullPointerException e) {
				forumPortlet.updateIsRendered(ForumUtils.CATEGORIES);
				UICategoryContainer categoryContainer = forumPortlet.getChild(UICategoryContainer.class) ;
				categoryContainer.updateIsRender(true) ;
				categoryContainer.getChild(UICategories.class).setIsRenderChild(false) ;
				forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath(Utils.FORUM_SERVICE);
				UIApplication uiApp = uiTopicContainer.getAncestorOfType(UIApplication.class) ;
				uiApp.addMessage(new ApplicationMessage("UITopicContainer.msg.forum-deleted", null, ApplicationMessage.WARNING)) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages()) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet);
				return;
			}
		}
	}

	static public class EditForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIPopupContainer popupContainer = popupAction.createUIComponent(UIPopupContainer.class, null, null) ;
			UIForumForm forumForm = popupContainer.addChild(UIForumForm.class, null, null) ;
			boolean isMode = false ;
			if(uiTopicContainer.userProfile.getUserRole() == 1) isMode = true;
			forumForm.setMode(isMode);
			forumForm.initForm();
			forumForm.setCategoryValue(uiTopicContainer.categoryId, false) ;
			forumForm.setForumValue(forum, true);
			forumForm.setForumUpdate(true) ;
			popupContainer.setId("EditForumForm") ;
			popupAction.activate(popupContainer, 650, 480) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
			uiTopicContainer.isUpdate = true ;
		}
	}	
	
	static public class SetLockedForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			forum.setIsLock(true);
			uiTopicContainer.isUpdate = true ;
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			try {
				uiTopicContainer.forumService.modifyForum(sProvider, forum, 2) ;
			} finally {
				sProvider.close();
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class SetUnLockForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			forum.setIsLock(false);
			uiTopicContainer.isUpdate = true ;
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			try {
				uiTopicContainer.forumService.modifyForum(sProvider, forum, 2) ;
			} finally {
				sProvider.close();
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class SetOpenForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			forum.setIsClosed(false);
			uiTopicContainer.isUpdate = true ;
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			try {
				uiTopicContainer.forumService.modifyForum(sProvider, forum, 1) ;
			} finally {
				sProvider.close();
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class SetCloseForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			forum.setIsClosed(true);
			uiTopicContainer.isUpdate = true ;
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			try {
				uiTopicContainer.forumService.modifyForum(sProvider, forum, 1) ;
			} finally {
				sProvider.close();
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	} 
	
	static public class MoveForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			List <Forum> forums = new ArrayList<Forum>();
			forums.add(forum);
			uiTopicContainer.isUpdate = true ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIMoveForumForm moveForumForm = popupAction.createUIComponent(UIMoveForumForm.class, null, null) ;
			moveForumForm.setListForum(forums, uiTopicContainer.categoryId);
			moveForumForm.setForumUpdate(true) ;
			popupAction.activate(moveForumForm, 315, 365) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
		}
	}	
	
	static public class RemoveForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			try {
				uiTopicContainer.forumService.removeForum(sProvider, uiTopicContainer.categoryId, forum.getId()) ;
				UICategoryContainer categoryContainer = forumPortlet.getChild(UICategoryContainer.class) ;
				forumPortlet.updateIsRendered(ForumUtils.CATEGORIES) ;
				categoryContainer.updateIsRender(false) ;
				categoryContainer.getChild(UICategory.class).updateByBreadcumbs(uiTopicContainer.categoryId) ;
				forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath(uiTopicContainer.categoryId) ;
				forumPortlet.getChild(UIForumLinks.class).setUpdateForumLinks() ;
			} finally {
				sProvider.close();
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class ExportForumActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(forum == null){
				UIApplication uiApp = uiTopicContainer.getAncestorOfType(UIApplication.class) ;
				uiApp.addMessage(new ApplicationMessage("UITopicContainer.msg.forum-deleted", null, ApplicationMessage.WARNING)) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages()) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet);
				return;
			}
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIExportForm exportForm = popupAction.createUIComponent(UIExportForm.class, null, null) ;
			exportForm.setObjectId(forum);
			popupAction.activate(exportForm, 380, 160) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
		}
	}	
	
	static public class WatchOptionActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			Forum forum = uiTopicContainer.getForum() ;
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIWatchToolsForm watchToolsForm = popupAction.createUIComponent(UIWatchToolsForm.class, null, null) ;
			watchToolsForm.setPath(forum.getPath());
			watchToolsForm.setEmails(forum.getEmailNotification()) ;
			watchToolsForm.setIsTopic(false);
			popupAction.activate(watchToolsForm, 500, 365) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
		}
	}	
	
	// ----------------------------------MenuThread---------------------------------
	static public class ApproveTopicsActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			List <Topic> topics = new ArrayList<Topic>();
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(topic.getIsApproved()) continue ;
					topic.setIsApproved(true);
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 3) ;
				} finally {
					sProvider.close();
				}
				event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
			} else {
				UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
				UIPageListTopicUnApprove pageListTopicUnApprove	= popupAction.createUIComponent(UIPageListTopicUnApprove.class, null, null) ;
				pageListTopicUnApprove.setUpdateContainer(uiTopicContainer.categoryId, uiTopicContainer.forumId) ;
				popupAction.activate(pageListTopicUnApprove, 500, 365) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
			}
		}
	}	

	static public class EditTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic = null ;
			boolean checked = false ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					checked = true ;
					break;
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(checked) {
				UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
				UIPopupContainer popupContainer = popupAction.createUIComponent(UIPopupContainer.class, null, null) ;
				UITopicForm topicForm = popupContainer.addChild(UITopicForm.class, null, null) ;
				topicForm.setTopicIds(uiTopicContainer.categoryId, uiTopicContainer.forumId, uiTopicContainer.forum) ;
				topicForm.setUpdateTopic(topic, true) ;
				topicForm.setMod(uiTopicContainer.isModerator) ;
				popupContainer.setId("UIEditTopicContainer") ;
				popupAction.activate(popupContainer, 850, 460) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
			} else {
				Object[] args = { };
				throw new MessageException(new ApplicationMessage("UICategory.msg.notCheck", args, ApplicationMessage.WARNING)) ;
			}
		}
	}	
	
	static public class SetOpenTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			List <Topic> topics = new ArrayList<Topic>();
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(!topic.getIsClosed()) continue ;
					topic.setIsClosed(false);
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 1) ;
				} finally {
					sProvider.close();
				}
			} 
			if(topics.size() == 0){
				Object[] args = {"Open" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class SetCloseTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List <Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(topic.getIsClosed()) continue ;
					topic.setIsClosed(true);
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 1) ;
				} finally {
					sProvider.close();
				}
			} 
			if(topics.size() == 0){
				Object[] args = { "Close" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	
	
	static public class SetLockedTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(topic.getIsLock()) continue ;
					topic.setIsLock(true);
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 2) ;
				} finally {
					sProvider.close();
				}
			} 
			if(topics.size() == 0){
				Object[] args = { "Locked" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}
	
	static public class SetUnLockTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			try{
				if(uiTopicContainer.getForum().getIsLock()){
					UIApplication uiApp = uiTopicContainer.getAncestorOfType(UIApplication.class) ;
					uiApp.addMessage(new ApplicationMessage("UITopicContainer.sms.ForumIsLocked", new Object[]{}, ApplicationMessage.WARNING)) ;
					event.getRequestContext().addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages()) ;
					return;
				}
			} catch (Exception e){
				e.printStackTrace();
				return;
			}
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(!topic.getIsLock()) continue ;
					topic.setIsLock(false);
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 2) ;
				} finally {
					sProvider.close();
				}
			} 
			if(topics.size() == 0){
				Object[] args = { "UnLock" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class SetUnStickTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(topic.getIsSticky()){ topic.setIsSticky(false); topics.add(topic); }
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 4) ;
				} finally {
					sProvider.close();
				}
			} else {
				Object[] args = { "UnStick" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	
	
	static public class SetStickTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(!topic.getIsSticky()){ topic.setIsSticky(true); topics.add(topic); }
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 4) ;
				} finally {
					sProvider.close();
				}
			}else {
				Object[] args = { "Stick" };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheck", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	
	
	static public class SetMoveTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
				UIMoveTopicForm moveTopicForm = popupAction.createUIComponent(UIMoveTopicForm.class, null, null) ;
				moveTopicForm.setUserProfile(uiTopicContainer.userProfile) ;
				moveTopicForm.updateTopic(uiTopicContainer.forumId, topics, false);
				popupAction.activate(moveTopicForm, 400, 420) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
			} 
			if(topics.size() == 0){
				Object[] args = { };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheckMove", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	

	static public class MergeTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 1) {
				UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
				UIMergeTopicForm mergeTopicForm = popupAction.createUIComponent(UIMergeTopicForm.class, null, null) ;
				mergeTopicForm.updateTopics(topics) ;
				popupAction.activate(mergeTopicForm, 560, 260) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
			} 
			if(topics.size() <= 1){
				Object[] args = { };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheckThreads", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	
	
	static public class SetDeleteTopicActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					topics.add(topic);
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					for(Topic topic_ : topics) {
						try{
							uiTopicContainer.forumService.removeTopic(sProvider, uiTopicContainer.categoryId, uiTopicContainer.forumId, topic_.getId()) ;
						}catch(Exception e){
							e.printStackTrace();
						}
					}
				} finally {
					sProvider.close();
				}
			} else if (topics.size() == 0){
				Object[] args = { };
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheckMove", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}	
	
	static public class SetUnWaitingActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiTopicContainer = event.getSource();
			List<Topic> topics = new ArrayList<Topic>();
			List<String> topicIds = uiTopicContainer.getIdSelected() ;
			Topic topic ;
			for(String topicId : topicIds) {
				topic = uiTopicContainer.getTopicByAll(topicId);
				if(topic != null) {
					if(topic.getIsWaiting()){ topic.setIsWaiting(false) ;topics.add(topic); } 
				}
			}
			UIForumPortlet forumPortlet = uiTopicContainer.getAncestorOfType(UIForumPortlet.class) ;
			if(topics.size() > 0) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try {
					uiTopicContainer.forumService.modifyTopic(sProvider, topics, 5) ;
				} finally {
					sProvider.close();
				}
			} 
			if(topics.size() == 0){
				Object[] args = {};
				throw new MessageException(new ApplicationMessage("UITopicContainer.sms.notCheckUnWait", args, ApplicationMessage.WARNING)) ;
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}
	
	static public class SetOrderByActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiContainer = event.getSource();
			String path = event.getRequestContext().getRequestParameter(OBJECTID)	;
			if(!ForumUtils.isEmpty(uiContainer.strOrderBy)) {
				if(uiContainer.strOrderBy.indexOf(path) >= 0) {
					if(uiContainer.strOrderBy.indexOf("descending") > 0) {
						uiContainer.strOrderBy = path + " ascending";
					} else {
						uiContainer.strOrderBy = path + " descending";
					}
				} else {
					uiContainer.strOrderBy = path + " ascending";
				}
			} else {
				uiContainer.strOrderBy = path + " ascending";
			}
			event.getRequestContext().addUIComponentToUpdateByAjax(uiContainer) ;
		}
	}
	
	static public class AddBookMarkActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer topicContainer = event.getSource();
			String topicId = event.getRequestContext().getRequestParameter(OBJECTID)	;
			if(!ForumUtils.isEmpty(topicId)) {
				SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
				try{
					StringBuffer buffer = new StringBuffer();
					if(topicId.equals("forum")) {
						buffer.append("ForumNormalIcon//").append(topicContainer.forum.getForumName()).append("//").append(topicContainer.forumId);
					}else {
						Topic topic = topicContainer.getTopicByAll(topicId);
						buffer.append("ThreadNoNewPost//").append(topic.getTopicName()).append("//").append(topicId) ;
					}
					String userName = topicContainer.userProfile.getUserId() ;
					topicContainer.forumService.saveUserBookmark(sProvider, userName, buffer.toString(), true) ;
					UIForumPortlet forumPortlet = topicContainer.getAncestorOfType(UIForumPortlet.class) ;
					forumPortlet.updateUserProfileInfo() ;
				} catch (Exception e) {
					sProvider.close();
				}
			}
		}
	}
	
	static public class AddWatchingActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer topicContainer = event.getSource();
			String path = event.getRequestContext().getRequestParameter(OBJECTID)	;
			if(path.equals("forum")){
				path = topicContainer.categoryId+"/"+topicContainer.forumId ;
				topicContainer.isUpdate = true;
			} else {
				path = topicContainer.categoryId+"/"+topicContainer.forumId+"/"+path ;
			}
			SessionProvider sProvider = ForumSessionUtils.getSystemProvider() ;
			List<String> values = new ArrayList<String>();
			String userName = topicContainer.userProfile.getUserId();
			try {
				values.add(ForumSessionUtils.getUserByUserId(userName).getEmail());
				topicContainer.forumService.addWatch(sProvider, 1, path, values, ForumSessionUtils.getCurrentUser()) ;
				Object[] args = { };
				UIApplication uiApp = topicContainer.getAncestorOfType(UIApplication.class) ;
				uiApp.addMessage(new ApplicationMessage("UIAddWatchingForm.msg.successfully", args, ApplicationMessage.INFO)) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages()) ;
			} catch (Exception e) {
				e.printStackTrace();
				Object[] args = { };
				UIApplication uiApp = topicContainer.getAncestorOfType(UIApplication.class) ;
				uiApp.addMessage(new ApplicationMessage("UIAddWatchingForm.msg.fall", args, ApplicationMessage.WARNING)) ;
				event.getRequestContext().addUIComponentToUpdateByAjax(uiApp.getUIPopupMessages()) ;
			}finally {
				sProvider.close();
			}
		}
	}
	
	static	public class AdvancedSearchActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiForm = event.getSource() ;
			UIForumPortlet forumPortlet = uiForm.getAncestorOfType(UIForumPortlet.class) ;
			forumPortlet.updateIsRendered(ForumUtils.FIELD_SEARCHFORUM_LABEL) ;
			forumPortlet.getChild(UIBreadcumbs.class).setUpdataPath(ForumUtils.FIELD_EXOFORUM_LABEL) ;
			UISearchForm searchForm = forumPortlet.getChild(UISearchForm.class) ;
			searchForm.setUserProfile(forumPortlet.getUserProfile()) ;
			searchForm.setSelectType(Utils.CATEGORY) ;
			searchForm.setIsSearchForum(false);
			searchForm.setIsSearchTopic(false);
			event.getRequestContext().addUIComponentToUpdateByAjax(forumPortlet) ;
		}
	}

	static	public class BanIpForumToolsActionListener extends EventListener<UITopicContainer> {
		public void execute(Event<UITopicContainer> event) throws Exception {
			UITopicContainer uiForm = event.getSource() ;
			UIForumPortlet forumPortlet = uiForm.getAncestorOfType(UIForumPortlet.class) ;
			UIPopupAction popupAction = forumPortlet.getChild(UIPopupAction.class) ;
			UIPopupContainer popupContainer = popupAction.createUIComponent(UIPopupContainer.class, null, null) ;
			UIBanIPForumManagerForm ipForumManager = popupContainer.addChild(UIBanIPForumManagerForm.class, null, null) ;
			popupContainer.setId("BanIPForumManagerForm") ;
			ipForumManager.setForumId(uiForm.categoryId + "/" + uiForm.forumId);
			popupAction.activate(popupContainer, 450, 500) ;
			event.getRequestContext().addUIComponentToUpdateByAjax(popupAction) ;
		}
	}
}
