/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIMoveTopicForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIMoveTopicForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMoveTopicForm
extends UIForm
implements UIPopupComponent {
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    private String forumId;
    private List<Topic> topics;
    private List<Category> categories;
    private boolean isFormTopic = false;
    private boolean isAdmin = false;
    private UserProfile userProfile;
    private String link = "";

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public UserProfile getUserProfile() throws Exception {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        this.userProfile = userProfile;
        if (this.userProfile == null) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateTopic(String forumId, List<Topic> topics, boolean isFormTopic) throws Exception {
        this.forumId = forumId;
        this.topics = topics;
        this.isFormTopic = isFormTopic;
        this.setCategories();
    }

    private void setCategories() throws Exception {
        this.categories = new ArrayList();
        for (Category category : this.forumService.getCategories(ForumSessionUtils.getSystemProvider())) {
            String[] list;
            if (this.userProfile.getUserRole() == 1L && (list = category.getUserPrivate()) != null && list.length > 0 && !list[0].equals(" ") && !ForumUtils.isStringInStrings((String[])list, (String)this.userProfile.getUserId())) continue;
            this.categories.add(category);
        }
    }

    private List<Category> getCategories() throws Exception {
        return this.categories;
    }

    private boolean getSelectCate(String cateId) throws Exception {
        return ((Topic)this.topics.get(0)).getPath().contains(cateId);
    }

    private List<Forum> getForums(String categoryId) throws Exception {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        for (Forum forum : this.forumService.getForums(ForumSessionUtils.getSystemProvider(), categoryId, "")) {
            if (forum.getId().equalsIgnoreCase(this.forumId) || this.userProfile.getUserRole() == 1L && (forum.getModerators().length > 0 && !ForumUtils.isStringInStrings((String[])forum.getModerators(), (String)this.userProfile.getUserId()) || forum.getModerators().length <= 0) && (forum.getIsClosed() || forum.getIsLock() || forum.getCreateTopicRole().length > 0 && !ForumUtils.isStringInStrings((String[])forum.getCreateTopicRole(), (String)this.userProfile.getUserId()))) continue;
            forums.add(forum);
        }
        return forums;
    }

    static /* synthetic */ List access$000(UIMoveTopicForm x0) {
        return x0.topics;
    }

    static /* synthetic */ ForumService access$100(UIMoveTopicForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ boolean access$200(UIMoveTopicForm x0) {
        return x0.isFormTopic;
    }
}

