/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UIShowBookMarkForm;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIShowBookMarkForm.gtmpl", events={@EventConfig(listeners={OpenLinkActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteLinkActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIShowBookMarkForm
extends UIForm
implements UIPopupComponent {
    ForumService forumService;
    public final String BOOKMARK_ITERATOR = "BookmarkPageIterator";
    private JCRPageList pageList;
    UIForumPageIterator pageIterator;
    private List<String> bookMarks = new ArrayList();

    public UIShowBookMarkForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, "BookmarkPageIterator");
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBookMark() throws Exception {
        SessionProvider sProvider = SessionProviderFactory.createSystemProvider();
        try {
            this.bookMarks = this.forumService.getBookmarks(sProvider, ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile().getUserId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        this.pageList = new ForumPageList(6L, this.bookMarks.size());
        this.pageList.setPageSize(6L);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList(this.pageIterator.getPageSelected(), this.bookMarks));
        this.pageIterator.setSelectPage(this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1L) {
                this.pageIterator.setRendered(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private String getBookMarkId(String id) throws Exception {
        for (String str : this.bookMarks) {
            if (str.indexOf(id) < 0) continue;
            return str;
        }
        return "";
    }

    static /* synthetic */ String access$000(UIShowBookMarkForm x0, String x1) throws Exception {
        return x0.getBookMarkId(x1);
    }
}

