/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.user.ForumContact;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.forum.webui.popup.UIViewUserProfile;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewMemberProfile.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewUserProfile
extends UIForm
implements UIPopupComponent {
    private UserProfile userProfile;
    private UserProfile userProfileLogin;
    private ForumContact contact = null;
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);

    public ForumContact getContact(String userId) throws Exception {
        if (this.contact == null) {
            this.contact = this.getPersonalContact(userId);
        }
        return this.contact;
    }

    public void setContact(ForumContact contact) {
        this.contact = contact;
    }

    private boolean isAdmin(String userId) throws Exception {
        return this.forumService.isAdminRole(userId);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.forumService.isOnline(userId);
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfileLogin(UserProfile userProfile) {
        this.userProfileLogin = userProfile;
    }

    public UserProfile getUserProfileLogin() {
        return this.userProfileLogin;
    }

    private ForumContact getPersonalContact(String userId) throws Exception {
        ForumContact contact = ForumSessionUtils.getPersonalContact((String)userId);
        if (contact == null) {
            contact = new ForumContact();
        }
        return contact;
    }

    private String getAvatarUrl(ForumContact contact) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        String url = ForumSessionUtils.getUserAvatarURL((String)this.getUserProfile().getUserId(), (ForumService)this.forumService, (DownloadService)dservice);
        return url;
    }

    private String[] getLabelProfile() {
        return new String[]{"userName", "firstName", "lastName", "birthDay", "gender", "email", "jobTitle", "location", "workPhone", "mobilePhone", "website"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

