/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumActionBar;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

@ComponentConfig(template="app:/templates/forum/webui/UIForumActionBar.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={ImportCategoryActionListener.class}), @EventConfig(listeners={ExportCategoryActionListener.class}), @EventConfig(listeners={AddForumActionListener.class}), @EventConfig(listeners={ManageModeratorActionListener.class}), @EventConfig(listeners={EditProfileActionListener.class}), @EventConfig(listeners={OpenBookMarkActionListener.class}), @EventConfig(listeners={OpenAdministrationActionListener.class}), @EventConfig(listeners={PrivateMessageActionListener.class}), @EventConfig(listeners={ModerationActionListener.class})})
public class UIForumActionBar
extends UIContainer {
    private boolean hasCategory = false;
    private UserProfile userProfile;
    private ForumService forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);

    private UserProfile getUserProfile() throws Exception {
        this.userProfile = ((UIForumPortlet)this.getParent()).getUserProfile();
        return this.userProfile;
    }

    public void setHasCategory(boolean hasCategory) {
        this.hasCategory = hasCategory;
    }

    private int getTotalJobWattingForModerator() throws Exception {
        return this.forumService.getJobWattingForModeratorByUser(this.userProfile.getUserId());
    }

    private long getNewMessage() throws Exception {
        try {
            String username = this.userProfile.getUserId();
            return this.forumService.getNewPrivateMessage(username);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getUserToken() throws Exception {
        RootContainer container = RootContainer.getInstance();
        container = container.getPortalContainer("portal");
        ContinuationService continuation = (ContinuationService)container.getComponentInstanceOfType(ContinuationService.class);
        return continuation.getUserToken(this.userProfile.getUserId());
    }

    static /* synthetic */ UserProfile access$000(UIForumActionBar x0) {
        return x0.userProfile;
    }

    static /* synthetic */ boolean access$100(UIForumActionBar x0) {
        return x0.hasCategory;
    }
}

