/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIModeratorManagementForm;
import org.exoplatform.forum.webui.popup.UIPageListPostByUser;
import org.exoplatform.forum.webui.popup.UIPageListTopicByUser;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIModeratorManagementForm.gtmpl", events={@EventConfig(listeners={SetDeaultAvatarActionListener.class}), @EventConfig(listeners={SearchUserActionListener.class}), @EventConfig(listeners={GetAllUserActionListener.class}), @EventConfig(listeners={ViewProfileActionListener.class}), @EventConfig(listeners={EditProfileActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddValuesAreaActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesModCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIModeratorManagementForm
extends UIForm
implements UIPopupComponent {
    private ForumService forumService;
    private List<UserProfile> userProfiles = new ArrayList();
    private String[] permissionUser = null;
    private String[] titleUser = null;
    private JCRPageList userPageList;
    private boolean isEdit = false;
    private UserProfile userProfile = new UserProfile();
    private List<ForumLinkData> forumLinks = null;
    private List<String> listModerate = new ArrayList();
    private List<String> listModCate = new ArrayList();
    public static final String FIELD_USERPROFILE_FORM = "ForumUserProfile";
    public static final String FIELD_USEROPTION_FORM = "ForumUserOption";
    public static final String FIELD_USERBAN_FORM = "ForumUserBan";
    public static final String FIELD_USERID_INPUT = "ForumUserName";
    public static final String FIELD_SCREENNAME_INPUT = "ScreenName";
    public static final String FIELD_USERTITLE_INPUT = "ForumUserTitle";
    public static final String FIELD_USERROLE_CHECKBOX = "isAdmin";
    public static final String FIELD_SIGNATURE_TEXTAREA = "Signature";
    public static final String FIELD_ISDISPLAYSIGNATURE_CHECKBOX = "IsDisplaySignature";
    public static final String FIELD_MODERATECATEGORYS_MULTIVALUE = "ModCategorys";
    public static final String FIELD_MODERATEFORUMS_MULTIVALUE = "ModForums";
    public static final String FIELD_MODERATETOPICS_MULTIVALUE = "MosTopics";
    public static final String FIELD_ISDISPLAYAVATAR_CHECKBOX = "IsDisplayAvatar";
    public static final String FIELD_TIMEZONE_SELECTBOX = "TimeZone";
    public static final String FIELD_SHORTDATEFORMAT_SELECTBOX = "ShortDateformat";
    public static final String FIELD_LONGDATEFORMAT_SELECTBOX = "LongDateformat";
    public static final String FIELD_TIMEFORMAT_SELECTBOX = "Timeformat";
    public static final String FIELD_MAXTOPICS_SELECTBOX = "MaximumThreads";
    public static final String FIELD_MAXPOSTS_SELECTBOX = "MaximumPosts";
    public static final String FIELD_FORUMJUMP_CHECKBOX = "ShowForumJump";
    public static final String FIELD_TIMEZONE = "timeZone";
    public static final String FIELD_ISBANNED_CHECKBOX = "IsBanned";
    public static final String FIELD_BANUNTIL_SELECTBOX = "BanUntil";
    public static final String FIELD_BANREASON_TEXTAREA = "BanReason";
    public static final String FIELD_BANCOUNTER_INPUT = "BanCounter";
    public static final String FIELD_BANREASONSUMMARY_MULTIVALUE = "BanReasonSummary";
    public static final String FIELD_CREATEDDATEBAN_INPUT = "CreatedDateBan";
    public static final String FIELD_SEARCH_USER = "SearchUser";
    private String valueSearch = null;
    private String userAvartarUrl = null;
    private String keyWord = "";
    private boolean isViewSearchUser = false;

    public UIModeratorManagementForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIForumPageIterator.class, null, "ForumUserPageIterator");
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SEARCH_USER, FIELD_SEARCH_USER, null));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.titleUser = new String[]{res.getString("UIForumPortlet.label.PermissionAdmin"), res.getString("UIForumPortlet.label.PermissionModerator"), res.getString("UIForumPortlet.label.PermissionUser"), res.getString("UIForumPortlet.label.PermissionGuest")};
        this.permissionUser = new String[this.titleUser.length];
        for (int i = 0; i < this.titleUser.length; ++i) {
            this.permissionUser[i] = this.titleUser[i].toLowerCase();
        }
    }

    public void setValueSearch(String value) {
        this.valueSearch = value;
    }

    public void setPageListUserProfile() throws Exception {
        this.userPageList = this.forumService.getPageListUserProfile();
        this.userPageList.setPageSize(5);
        ((UIForumPageIterator)this.getChild(UIForumPageIterator.class)).updatePageList(this.userPageList);
    }

    private boolean isAdmin(String userId) throws Exception {
        return this.forumService.isAdminRole(userId);
    }

    private String getIsBanned(UserProfile userProfile) throws Exception {
        Calendar calendar;
        if (userProfile.getBanUntil() > 0L && (calendar = ForumUtils.getInstanceTempCalendar()).getTimeInMillis() >= userProfile.getBanUntil()) {
            userProfile.setIsBanned(false);
            return "false";
        }
        return "true";
    }

    private void setListUserProfile() throws Exception {
        if (this.valueSearch == null || this.valueSearch.trim().length() < 1) {
            UIForumPageIterator pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
            long page = pageIterator.getPageSelected();
            this.userProfiles = this.userPageList.getPage(page);
            pageIterator.setSelectPage((long)this.userPageList.getCurrentPage());
        } else {
            this.userProfiles = this.userPageList.getpage(this.valueSearch);
            ((UIForumPageIterator)this.getChild(UIForumPageIterator.class)).setSelectPage((long)this.userPageList.getCurrentPage());
            this.valueSearch = null;
        }
    }

    private List<UserProfile> getListProFileUser() throws Exception {
        if (!this.isViewSearchUser) {
            this.setListUserProfile();
        } else {
            try {
                UIForumPageIterator pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
                long page = pageIterator.getPageSelected();
                this.userProfiles = new ArrayList();
                for (Object obj : this.userPageList.getPageUser(page)) {
                    if (obj instanceof User) {
                        this.userProfiles.add(this.forumService.getUserProfileManagement(((User)obj).getUserName()));
                        continue;
                    }
                    if (!(obj instanceof UserProfile)) continue;
                    this.userProfiles.add((UserProfile)obj);
                }
            }
            catch (Exception e) {
                this.setListUserProfile();
            }
        }
        if (this.userProfiles == null) {
            this.userProfiles = new ArrayList();
        }
        return this.userProfiles;
    }

    private UserProfile getUserProfile(String userId) throws Exception {
        for (UserProfile userProfile : this.userProfiles) {
            if (!userProfile.getUserId().equals(userId)) continue;
            if (userProfile.getUserRole() != 0L && this.isAdmin(userProfile.getUserId())) {
                userProfile.setUserRole(Long.valueOf(0L));
                userProfile.setUserTitle(Utils.ADMIN);
            }
            return userProfile;
        }
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(userId);
        return userProfile;
    }

    public UserProfile getProfile() {
        return this.userProfile;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private String stringProcess(List<String> values) {
        String outPut = "";
        if (!values.isEmpty()) {
            for (String value : values) {
                if (ForumUtils.isEmpty((String)value) || value.indexOf(40) <= 0) continue;
                outPut = outPut + value.substring(0, value.lastIndexOf(40)) + "\n";
            }
        }
        return outPut;
    }

    private List<String> setListCategoryIds() {
        ArrayList<String> listId = new ArrayList<String>();
        if (!this.listModCate.isEmpty()) {
            for (String value : this.listModCate) {
                if (value == null || value.trim().length() <= 0) continue;
                listId.add(value.substring(value.lastIndexOf("(") + 1));
            }
        }
        return listId;
    }

    private List<String> setListForumIds() {
        ArrayList<String> listId = new ArrayList<String>();
        if (!this.listModerate.isEmpty()) {
            for (String value : this.listModerate) {
                if (value == null || value.trim().length() <= 0) continue;
                listId.add(value.substring(value.lastIndexOf("/") + 1));
            }
        }
        return listId;
    }

    private String getCategoryId(String str) {
        try {
            str = str.substring(str.lastIndexOf(40) + 1, str.lastIndexOf(47));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private List<String> getModerateList(List<String> forumsModerate) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : forumsModerate) {
            if (string.indexOf(40) <= 0) continue;
            string = string.substring(string.lastIndexOf(40) + 1);
            list.add(string);
        }
        return list;
    }

    private boolean getIsEdit() {
        return this.isEdit;
    }

    public void setModForunValues(List<String> values) {
        this.listModerate = values;
        UIFormInputWithActions inputSetProfile = (UIFormInputWithActions)this.getChildById(FIELD_USERPROFILE_FORM);
        String value = this.stringProcess(values);
        inputSetProfile.getUIFormTextAreaInput(FIELD_MODERATEFORUMS_MULTIVALUE).setValue((Object)value);
    }

    public void setModCateValues(List<String> values) {
        this.listModCate = values;
        UIFormInputWithActions inputSetProfile = (UIFormInputWithActions)this.getChildById(FIELD_USERPROFILE_FORM);
        String value = this.stringProcess(values);
        inputSetProfile.getUIFormTextAreaInput(FIELD_MODERATECATEGORYS_MULTIVALUE).setValue((Object)value);
    }

    private void initUserProfileForm() throws Exception {
        long until;
        String[] format;
        List<String> valuesCate;
        List<String> values;
        this.setForumLinks();
        UIFormStringInput userId = new UIFormStringInput(FIELD_USERID_INPUT, FIELD_USERID_INPUT, null);
        userId.setValue((Object)this.userProfile.getUserId());
        userId.setEditable(false);
        userId.setEnable(false);
        UIFormStringInput screenName = new UIFormStringInput(FIELD_SCREENNAME_INPUT, FIELD_SCREENNAME_INPUT, null);
        String screenN = this.userProfile.getScreenName();
        if (ForumUtils.isEmpty((String)screenN)) {
            screenN = this.userProfile.getUserId();
        }
        screenName.setValue((Object)screenN);
        UIFormStringInput userTitle = new UIFormStringInput(FIELD_USERTITLE_INPUT, FIELD_USERTITLE_INPUT, null);
        String title = this.userProfile.getUserTitle();
        boolean isAdmin = false;
        UIFormCheckBoxInput userRole = new UIFormCheckBoxInput(FIELD_USERROLE_CHECKBOX, FIELD_USERROLE_CHECKBOX, (Object)false);
        if (this.userProfile.getUserRole() == 0L) {
            isAdmin = true;
        }
        if (this.isAdmin(this.userProfile.getUserId())) {
            userRole.setEnable(false);
            isAdmin = true;
            if (this.userProfile.getUserRole() != 0L) {
                title = Utils.ADMIN;
            }
        }
        userRole.setValue((Object)isAdmin);
        userTitle.setValue((Object)title);
        UIFormTextAreaInput signature = new UIFormTextAreaInput(FIELD_SIGNATURE_TEXTAREA, FIELD_SIGNATURE_TEXTAREA, null);
        signature.setValue((Object)ForumTransformHTML.unCodeHTML((String)this.userProfile.getSignature()));
        UIFormCheckBoxInput isDisplaySignature = new UIFormCheckBoxInput(FIELD_ISDISPLAYSIGNATURE_CHECKBOX, FIELD_ISDISPLAYSIGNATURE_CHECKBOX, (Object)false);
        isDisplaySignature.setChecked(this.userProfile.getIsDisplaySignature());
        UIFormTextAreaInput moderateForums = new UIFormTextAreaInput(FIELD_MODERATEFORUMS_MULTIVALUE, FIELD_MODERATEFORUMS_MULTIVALUE, null);
        this.listModerate = values = Arrays.asList(this.userProfile.getModerateForums());
        moderateForums.setValue((Object)this.stringProcess(values));
        moderateForums.setEditable(false);
        UIFormTextAreaInput moderateCategorys = new UIFormTextAreaInput(FIELD_MODERATECATEGORYS_MULTIVALUE, FIELD_MODERATECATEGORYS_MULTIVALUE, null);
        this.listModCate = valuesCate = Arrays.asList(this.userProfile.getModerateCategory());
        moderateCategorys.setValue((Object)this.stringProcess(valuesCate));
        moderateCategorys.setEditable(false);
        UIFormCheckBoxInput isDisplayAvatar = new UIFormCheckBoxInput(FIELD_ISDISPLAYAVATAR_CHECKBOX, FIELD_ISDISPLAYAVATAR_CHECKBOX, (Object)false);
        isDisplayAvatar.setChecked(this.userProfile.getIsDisplayAvatar());
        String[] timeZone1 = this.getLabel(FIELD_TIMEZONE).split("/");
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        for (String string : timeZone1) {
            list.add(new SelectItemOption(string, (Object)ForumUtils.getTimeZoneNumberInString((String)string)));
        }
        UIFormSelectBox timeZone = new UIFormSelectBox(FIELD_TIMEZONE_SELECTBOX, FIELD_TIMEZONE_SELECTBOX, list);
        double timeZoneOld = -this.userProfile.getTimeZone();
        Date date = this.getNewDate(timeZoneOld);
        String mark = "-";
        if (timeZoneOld < 0.0) {
            timeZoneOld = -timeZoneOld;
        } else if (timeZoneOld > 0.0) {
            mark = "+";
        } else {
            timeZoneOld = 0.0;
            mark = "";
        }
        timeZone.setValue(mark + timeZoneOld + "0");
        list = new ArrayList();
        for (String frm : format = new String[]{"M-d-yyyy", "M-d-yy", "MM-dd-yy", "MM-dd-yyyy", "yyyy-MM-dd", "yy-MM-dd", "dd-MM-yyyy", "dd-MM-yy", "M/d/yyyy", "M/d/yy", "MM/dd/yy", "MM/dd/yyyy", "yyyy/MM/dd", "yy/MM/dd", "dd/MM/yyyy", "dd/MM/yy"}) {
            list.add(new SelectItemOption(frm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)frm, (Date)date) + ")", (Object)frm));
        }
        UIFormSelectBox shortdateFormat = new UIFormSelectBox(FIELD_SHORTDATEFORMAT_SELECTBOX, FIELD_SHORTDATEFORMAT_SELECTBOX, list);
        shortdateFormat.setValue(this.userProfile.getShortDateFormat());
        list = new ArrayList();
        for (String idFrm : format = new String[]{"DDD, MMMM dd, yyyy", "DDDD, MMMM dd, yyyy", "DDDD, dd MMMM, yyyy", "DDD, MMM dd, yyyy", "DDDD, MMM dd, yyyy", "DDDD, dd MMM, yyyy", "MMMM dd, yyyy", "dd MMMM, yyyy", "MMM dd, yyyy", "dd MMM, yyyy"}) {
            list.add(new SelectItemOption(idFrm.toLowerCase() + " (" + ForumUtils.getFormatDate((String)idFrm, (Date)date) + ")", (Object)idFrm.replaceFirst(" ", "=")));
        }
        UIFormSelectBox longDateFormat = new UIFormSelectBox(FIELD_LONGDATEFORMAT_SELECTBOX, FIELD_LONGDATEFORMAT_SELECTBOX, list);
        longDateFormat.setValue(this.userProfile.getLongDateFormat().replaceFirst(" ", "="));
        list = new ArrayList();
        list.add(new SelectItemOption("12-hour", (Object)"hh:mm=a"));
        list.add(new SelectItemOption("24-hour", (Object)"HH:mm"));
        UIFormSelectBox timeFormat = new UIFormSelectBox(FIELD_TIMEFORMAT_SELECTBOX, FIELD_TIMEFORMAT_SELECTBOX, list);
        timeFormat.setValue(this.userProfile.getTimeFormat().replace(' ', '='));
        list = new ArrayList();
        for (int i = 5; i <= 45; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumThreads = new UIFormSelectBox(FIELD_MAXTOPICS_SELECTBOX, FIELD_MAXTOPICS_SELECTBOX, list);
        maximumThreads.setValue("id" + this.userProfile.getMaxTopicInPage());
        list = new ArrayList();
        for (int i = 5; i <= 35; i += 5) {
            list.add(new SelectItemOption(String.valueOf(i), (Object)("id" + i)));
        }
        UIFormSelectBox maximumPosts = new UIFormSelectBox(FIELD_MAXPOSTS_SELECTBOX, FIELD_MAXPOSTS_SELECTBOX, list);
        maximumPosts.setValue("id" + this.userProfile.getMaxPostInPage());
        boolean isJump = this.userProfile.getIsShowForumJump();
        UIFormCheckBoxInput isShowForumJump = new UIFormCheckBoxInput(FIELD_FORUMJUMP_CHECKBOX, FIELD_FORUMJUMP_CHECKBOX, (Object)false);
        isShowForumJump.setChecked(isJump);
        UIFormCheckBoxInput isBanned = new UIFormCheckBoxInput(FIELD_ISBANNED_CHECKBOX, FIELD_ISBANNED_CHECKBOX, (Object)false);
        boolean isBan = this.userProfile.getIsBanned();
        isBanned.setChecked(isBan);
        list = new ArrayList();
        String dv = "Days";
        int i = 2;
        long oneDate = 86400000L;
        if (isBan) {
            until = this.userProfile.getBanUntil();
            date.setTime(until);
            list.add(new SelectItemOption("Banned until: " + ForumUtils.getFormatDate((String)(this.userProfile.getShortDateFormat() + " hh:mm a"), (Date)date) + " GMT+0", (Object)("Until_" + until)));
        }
        date = this.getInstanceTempCalendar();
        until = date.getTime() + oneDate;
        date.setTime(until);
        list.add(new SelectItemOption("1 Day (" + ForumUtils.getFormatDate((String)(this.userProfile.getShortDateFormat() + " hh:mm a"), (Date)date) + " GMT+0)", (Object)("Until_" + until)));
        while (true) {
            if (i == 8 && dv.equals("Days")) {
                i = 10;
            }
            if (i == 11) {
                i = 2;
                dv = "Weeks";
            }
            if (i == 4 && dv.equals("Weeks")) {
                i = 1;
                dv = "Month";
            }
            if (i == 2 && dv.equals("Month")) {
                dv = "Months";
            }
            if (i == 7 && dv.equals("Months")) {
                i = 1;
                dv = "Year";
            }
            if (i == 2 && dv.equals("Year")) {
                dv = "Years";
            }
            if (i == 3 && dv.equals("Years")) break;
            if (dv.equals("Days")) {
                date = this.getInstanceTempCalendar();
                until = date.getTime() + (long)i * oneDate;
                date.setTime(until);
            }
            if (dv.equals("Weeks")) {
                date = this.getInstanceTempCalendar();
                until = date.getTime() + (long)i * oneDate * 7L;
                date.setTime(until);
            }
            if (dv.equals("Month") || dv.equals("Months")) {
                date = this.getInstanceTempCalendar();
                date.setMonth(date.getMonth() + i);
                until = date.getTime();
            }
            if (dv.equals("Years") || dv.equals("Year")) {
                date = this.getInstanceTempCalendar();
                date.setYear(date.getYear() + i);
                until = date.getTime();
            }
            list.add(new SelectItemOption(i + " " + dv + " (" + ForumUtils.getFormatDate((String)(this.userProfile.getShortDateFormat() + " hh:mm a"), (Date)date) + " GMT+0)", (Object)("Until_" + until)));
            ++i;
        }
        UIFormSelectBox banUntil = new UIFormSelectBox(FIELD_BANUNTIL_SELECTBOX, FIELD_BANUNTIL_SELECTBOX, list);
        if (isBan) {
            banUntil.setValue("Until_" + this.userProfile.getBanUntil());
        }
        UIFormTextAreaInput banReason = new UIFormTextAreaInput(FIELD_BANREASON_TEXTAREA, FIELD_BANREASON_TEXTAREA, null);
        UIFormStringInput banCounter = new UIFormStringInput(FIELD_BANCOUNTER_INPUT, FIELD_BANCOUNTER_INPUT, null);
        banCounter.setValue((Object)(this.userProfile.getBanCounter() + ""));
        UIFormTextAreaInput banReasonSummary = new UIFormTextAreaInput(FIELD_BANREASONSUMMARY_MULTIVALUE, FIELD_BANREASONSUMMARY_MULTIVALUE, null);
        banReasonSummary.setValue((Object)ForumUtils.unSplitForForum((String[])this.userProfile.getBanReasonSummary()));
        banReasonSummary.setEditable(false);
        UIFormStringInput createdDateBan = new UIFormStringInput(FIELD_CREATEDDATEBAN_INPUT, FIELD_CREATEDDATEBAN_INPUT, null);
        if (isBan) {
            banReason.setValue((Object)this.userProfile.getBanReason());
            createdDateBan.setValue((Object)ForumUtils.getFormatDate((String)"MM/dd/yyyy, hh:mm a", (Date)this.userProfile.getCreatedDateBan()));
        } else {
            banReason.setEnable(true);
        }
        UIFormInputWithActions inputSetProfile = new UIFormInputWithActions(FIELD_USERPROFILE_FORM);
        inputSetProfile.addUIFormInput((UIFormInput)userId);
        inputSetProfile.addUIFormInput((UIFormInput)screenName);
        inputSetProfile.addUIFormInput((UIFormInput)userTitle);
        inputSetProfile.addUIFormInput((UIFormInput)userRole);
        inputSetProfile.addUIFormInput((UIFormInput)moderateCategorys);
        inputSetProfile.addUIFormInput((UIFormInput)moderateForums);
        inputSetProfile.addUIFormInput((UIFormInput)signature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplaySignature);
        inputSetProfile.addUIFormInput((UIFormInput)isDisplayAvatar);
        String string = FIELD_MODERATEFORUMS_MULTIVALUE;
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
        ad.setActionListener("AddValuesArea");
        ad.setActionParameter(string);
        ad.setCssIconClass("AddIcon16x16");
        ad.setActionName(string);
        actions.add(ad);
        inputSetProfile.setActionField(string, actions);
        string = FIELD_MODERATECATEGORYS_MULTIVALUE;
        actions = new ArrayList();
        ad = new UIFormInputWithActions.ActionData();
        ad.setActionListener("AddValuesModCategory");
        ad.setActionParameter(string);
        ad.setCssIconClass("AddIcon16x16");
        ad.setActionName(string);
        actions.add(ad);
        inputSetProfile.setActionField(string, actions);
        this.addUIFormInput((UIFormInputSet)inputSetProfile);
        UIFormInputWithActions inputSetOption = new UIFormInputWithActions(FIELD_USEROPTION_FORM);
        inputSetOption.addUIFormInput((UIFormInput)timeZone);
        inputSetOption.addUIFormInput((UIFormInput)shortdateFormat);
        inputSetOption.addUIFormInput((UIFormInput)longDateFormat);
        inputSetOption.addUIFormInput((UIFormInput)timeFormat);
        inputSetOption.addUIFormInput((UIFormInput)maximumThreads);
        inputSetOption.addUIFormInput((UIFormInput)maximumPosts);
        inputSetOption.addUIFormInput((UIFormInput)isShowForumJump);
        this.addUIFormInput((UIFormInputSet)inputSetOption);
        UIFormInputWithActions inputSetBan = new UIFormInputWithActions(FIELD_USERBAN_FORM);
        inputSetBan.addUIFormInput((UIFormInput)isBanned);
        inputSetBan.addUIFormInput((UIFormInput)banUntil);
        inputSetBan.addUIFormInput((UIFormInput)banReason);
        inputSetBan.addUIFormInput((UIFormInput)banCounter);
        inputSetBan.addUIFormInput((UIFormInput)banReasonSummary);
        inputSetBan.addUIFormInput((UIFormInput)createdDateBan);
        this.addUIFormInput((UIFormInputSet)inputSetBan);
        UIPageListTopicByUser pageListTopicByUser = (UIPageListTopicByUser)this.addChild(UIPageListTopicByUser.class, null, null);
        pageListTopicByUser.setUserName(this.userProfile.getUserId());
        UIPageListPostByUser listPostByUser = (UIPageListPostByUser)this.addChild(UIPageListPostByUser.class, null, null);
        listPostByUser.setUserName(this.userProfile.getUserId());
    }

    private Date getNewDate(double timeZoneOld) {
        Calendar calendar = GregorianCalendar.getInstance();
        if (15 == 0) {
            calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)(timeZoneOld * 3600000.0));
        }
        return calendar.getTime();
    }

    private Date getInstanceTempCalendar() {
        return ForumUtils.getInstanceTempCalendar().getTime();
    }

    private void setForumLinks() throws Exception {
        UIForumLinks uiForumLinks = (UIForumLinks)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIForumLinks.class);
        boolean hasGetService = false;
        if (uiForumLinks == null) {
            hasGetService = true;
        } else {
            this.forumLinks = uiForumLinks.getForumLinks();
        }
        if (this.forumLinks == null || this.forumLinks.size() <= 0) {
            hasGetService = true;
        }
        if (hasGetService) {
            this.forumService.getAllLink("", "");
        }
    }

    private List<ForumLinkData> getForumLinks() throws Exception {
        return this.forumLinks;
    }

    public void setUserAvatarURL(String userId) {
        this.userAvartarUrl = ForumSessionUtils.getUserAvatarURL((String)userId, (ForumService)this.forumService, (DownloadService)((DownloadService)this.getApplicationComponent(DownloadService.class)));
    }

    private void searchUserProfileByKey(String keyword) throws Exception {
        try {
            keyword = "*" + keyword + "*";
            this.userPageList = this.forumService.searchUserProfile(keyword);
            this.userPageList.setPageSize(5);
            ((UIForumPageIterator)this.getChild(UIForumPageIterator.class)).updatePageList(this.userPageList);
            this.isViewSearchUser = true;
        }
        catch (Exception e) {
            this.isViewSearchUser = false;
        }
    }

    static /* synthetic */ UserProfile access$000(UIModeratorManagementForm x0, String x1) throws Exception {
        return x0.getUserProfile(x1);
    }

    static /* synthetic */ UserProfile access$102(UIModeratorManagementForm x0, UserProfile x1) {
        x0.userProfile = x1;
        return x0.userProfile;
    }

    static /* synthetic */ ForumService access$200(UIModeratorManagementForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ void access$300(UIModeratorManagementForm x0) throws Exception {
        x0.initUserProfileForm();
    }

    static /* synthetic */ boolean access$402(UIModeratorManagementForm x0, boolean x1) {
        x0.isEdit = x1;
        return x0.isEdit;
    }

    static /* synthetic */ UserProfile access$100(UIModeratorManagementForm x0) {
        return x0.userProfile;
    }

    static /* synthetic */ boolean access$500(UIModeratorManagementForm x0, String x1) throws Exception {
        return x0.isAdmin(x1);
    }

    static /* synthetic */ List access$600(UIModeratorManagementForm x0, List x1) {
        return x0.getModerateList(x1);
    }

    static /* synthetic */ List access$700(UIModeratorManagementForm x0) {
        return x0.listModerate;
    }

    static /* synthetic */ List access$800(UIModeratorManagementForm x0) {
        return x0.listModCate;
    }

    static /* synthetic */ List access$702(UIModeratorManagementForm x0, List x1) {
        x0.listModerate = x1;
        return x0.listModerate;
    }

    static /* synthetic */ String[] access$900(UIModeratorManagementForm x0) {
        return x0.permissionUser;
    }

    static /* synthetic */ String[] access$1000(UIModeratorManagementForm x0) {
        return x0.titleUser;
    }

    static /* synthetic */ Date access$1100(UIModeratorManagementForm x0) {
        return x0.getInstanceTempCalendar();
    }

    static /* synthetic */ String access$1200(UIModeratorManagementForm x0) {
        return x0.keyWord;
    }

    static /* synthetic */ boolean access$1302(UIModeratorManagementForm x0, boolean x1) {
        x0.isViewSearchUser = x1;
        return x0.isViewSearchUser;
    }

    static /* synthetic */ void access$1400(UIModeratorManagementForm x0, String x1) throws Exception {
        x0.searchUserProfileByKey(x1);
    }

    static /* synthetic */ List access$1500(UIModeratorManagementForm x0) {
        return x0.setListCategoryIds();
    }

    static /* synthetic */ List access$1600(UIModeratorManagementForm x0) {
        return x0.setListForumIds();
    }

    static /* synthetic */ String access$1700(UIModeratorManagementForm x0) {
        return x0.userAvartarUrl;
    }

    static /* synthetic */ String access$1702(UIModeratorManagementForm x0, String x1) {
        x0.userAvartarUrl = x1;
        return x0.userAvartarUrl;
    }

    static /* synthetic */ String access$1202(UIModeratorManagementForm x0, String x1) {
        x0.keyWord = x1;
        return x0.keyWord;
    }
}

