/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormDateTimePicker
extends UIFormInputBase<String> {
    private String titleShowCalendar = "Show Calendar";
    private String dateStyle_ = "MM/dd/yyyy";
    private String timeStyle_ = "HH:mm:ss";
    private Date date_;
    private boolean isDisplayTime_;
    private Locale locale_;

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime) {
        super(name, bindField, String.class);
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, Locale locale) {
        super(name, bindField, String.class);
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        this.locale_ = locale;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, String titleShowCalendar, Locale locale, String dateStyle) {
        super(name, bindField, String.class);
        this.dateStyle_ = dateStyle;
        this.isDisplayTime_ = isDisplayTime;
        this.locale_ = locale;
        this.date_ = date;
        this.titleShowCalendar = titleShowCalendar;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, boolean isDisplayTime, String titleShowCalendar, Locale locale, String dateStyle, String timeStyle) {
        super(name, bindField, String.class);
        this.dateStyle_ = dateStyle;
        this.timeStyle_ = timeStyle;
        this.locale_ = locale;
        this.date_ = date;
        this.isDisplayTime_ = isDisplayTime;
        this.titleShowCalendar = titleShowCalendar;
        if (date != null) {
            this.value_ = this.getFormater().format(date);
        }
    }

    public UIFormDateTimePicker(String name, String bindField, Date date) {
        this(name, bindField, date, true);
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, String dateStyle) {
        this(name, bindField, date, false, "Show Calendar", null, dateStyle);
    }

    public UIFormDateTimePicker(String name, String bindField, Date date, String dateStyle, String timeStyle) {
        this(name, bindField, date, true, "Show Calendar", null, dateStyle, timeStyle);
    }

    public void setDisplayTime(boolean isDisplayTime) {
        this.isDisplayTime_ = isDisplayTime;
    }

    public void setTitleShowCalendar(String titleShowCalendar) {
        this.titleShowCalendar = titleShowCalendar;
    }

    public void setCalendar(Calendar date) {
        this.date_ = date.getTime();
        this.value_ = this.getFormater().format(date.getTime());
    }

    public Calendar getCalendar() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getFormater().parse((String)this.value_ + " 0:0:0"));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateValue() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getFormater().parse((String)this.value_ + " 0:0:0"));
            return calendar.getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setDateFormatStyle(String dateStyle) {
        this.dateStyle_ = dateStyle;
        this.value_ = this.getFormater().format(this.date_);
    }

    public void setTimeFormatStyle(String timeStyle) {
        this.timeStyle_ = timeStyle;
        this.value_ = this.getFormater().format(this.date_);
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input != null) {
            this.value_ = ((String)input).trim();
        }
    }

    public String getFormatStyle() {
        if (this.isDisplayTime_) {
            return this.dateStyle_ + " " + this.timeStyle_;
        }
        return this.dateStyle_;
    }

    private String getLang() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return locale.getLanguage();
    }

    private DateFormat getFormater() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        if (this.locale_ == null) {
            this.locale_ = locale;
        }
        return new SimpleDateFormat(this.getFormatStyle(), this.locale_);
    }

    public void setInfo(String titleShowCalendar, Locale locale, String dateStyle, String timeStyle) {
        this.titleShowCalendar = titleShowCalendar;
        this.dateStyle_ = dateStyle;
        this.timeStyle_ = timeStyle;
        this.locale_ = locale;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript("eXo.ks.UIDateTimePicker", "/ksResources/javascript/");
        Writer w = context.getWriter();
        w.write("<input type='text' class='DateTimeInput'");
        w.write("name='");
        w.write(this.getName());
        w.write(39);
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            w.write(" value='");
            w.write(((String)this.value_).toString());
            w.write(39);
        }
        w.write("/>");
        w.write("<div class='CalendarIcons' lang='" + this.getLang() + "' format='" + this.getFormatStyle() + "' onclick='eXo.ks.UIDateTimePicker.init(this,");
        w.write(String.valueOf(this.isDisplayTime_) + ");' title='" + this.titleShowCalendar + "'><span></span></div>");
    }
}

