/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumModerator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UIPostRules;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/forum/webui/UIForumInfos.gtmpl")
public class UIForumInfos
extends UIContainer {
    private UserProfile userProfile;

    public UIForumInfos() throws Exception {
        this.addChild(UIPostRules.class, null, null);
        this.addChild(UIForumModerator.class, null, null);
    }

    public void setForum(Forum forum) throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        List moderators = ForumServiceUtils.getUserPermission((String[])forum.getModerators());
        UIPostRules postRules = (UIPostRules)this.getChild(UIPostRules.class);
        boolean isShowRule = forumPortlet.isShowRules();
        postRules.setRendered(isShowRule);
        if (isShowRule) {
            boolean isLock = forum.getIsClosed();
            if (!isLock) {
                isLock = forum.getIsLock();
            }
            if (!isLock && this.userProfile.getUserRole() != 0L && !moderators.contains(this.userProfile.getUserId())) {
                ForumService forumService;
                String[] listUser = forum.getCreateTopicRole();
                if (listUser != null && listUser.length > 0) {
                    boolean bl = isLock = !ForumServiceUtils.hasPermission((String[])listUser, (String)this.userProfile.getUserId());
                }
                if ((isLock || listUser == null || listUser.length == 0 || listUser[0].equals(" ")) && (listUser = (forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getPermissionTopicByCategory(forum.getCategoryId(), "createTopic")) != null && listUser.length > 0 && !listUser[0].equals(" ")) {
                    isLock = !ForumServiceUtils.hasPermission((String[])listUser, (String)this.userProfile.getUserId());
                }
            }
            postRules.setLock(isLock);
            postRules.setUserProfile(this.userProfile);
        }
        UIForumModerator forumModerator = (UIForumModerator)this.getChild(UIForumModerator.class);
        if (forumPortlet.isShowModerators()) {
            forumModerator.setModeratorsForum(moderators);
            forumModerator.setUserRole(this.userProfile.getUserRole().longValue());
        }
        forumModerator.setRendered(forumPortlet.isShowModerators());
    }
}

