/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.BBCodeData;
import org.exoplatform.forum.service.BBCode;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.webui.popup.UIAddBBCodeForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIAddBBCodeForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={PreviewActionListener.class}), @EventConfig(listeners={ApplyActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddBBCodeForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TAGNAME_INPUT = "TagName";
    public static final String FIELD_REPLACEMENT_TEXTARE = "Replacement";
    public static final String FIELD_DESCRIPTION_TEXTARE = "Description";
    public static final String FIELD_EXAMPLE_TEXTARE = "Example";
    public static final String FIELD_USEOPTION_CHECKBOX = "UseOption";
    public static final String PREVIEW = "priview";
    private boolean isPriview = false;
    private boolean isEdit = false;
    private ForumService forumService;
    private String example = "";
    private List<BBCode> listBBCode = new ArrayList();
    private BBCode bbcode = new BBCode();

    public UIAddBBCodeForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        UIFormStringInput tagNameInput = new UIFormStringInput(FIELD_TAGNAME_INPUT, FIELD_TAGNAME_INPUT, null);
        tagNameInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormTextAreaInput replacementInput = new UIFormTextAreaInput(FIELD_REPLACEMENT_TEXTARE, FIELD_REPLACEMENT_TEXTARE, null);
        replacementInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_DESCRIPTION_TEXTARE, FIELD_DESCRIPTION_TEXTARE, null);
        UIFormTextAreaInput example = new UIFormTextAreaInput(FIELD_EXAMPLE_TEXTARE, FIELD_EXAMPLE_TEXTARE, null);
        example.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormCheckBoxInput isOption = new UIFormCheckBoxInput(FIELD_USEOPTION_CHECKBOX, FIELD_USEOPTION_CHECKBOX, (Object)false);
        this.addUIFormInput((UIFormInput)tagNameInput);
        this.addUIFormInput((UIFormInput)replacementInput);
        this.addUIFormInput((UIFormInput)description);
        this.addUIFormInput((UIFormInput)example);
        this.addUIFormInput((UIFormInput)isOption);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getPriview() {
        return this.isPriview;
    }

    public void setEditBBcode(BBCode bbcode) throws Exception {
        this.bbcode = bbcode;
        this.isEdit = true;
        this.getUIStringInput(FIELD_TAGNAME_INPUT).setValue((Object)bbcode.getTagName());
        UIFormTextAreaInput replacement = this.getUIFormTextAreaInput(FIELD_REPLACEMENT_TEXTARE);
        replacement.setValue((Object)bbcode.getReplacement());
        if (bbcode.getTagName().equalsIgnoreCase("list")) {
            replacement.setEditable(false);
        }
        this.getUIFormTextAreaInput(FIELD_DESCRIPTION_TEXTARE).setValue((Object)bbcode.getDescription());
        this.getUIFormTextAreaInput(FIELD_EXAMPLE_TEXTARE).setValue((Object)bbcode.getExample());
        this.getUIFormCheckBoxInput(FIELD_USEOPTION_CHECKBOX).setChecked(bbcode.isOption());
    }

    private String getReplaceByBBCode() throws Exception {
        return BBCodeData.getReplacementByBBcode((String)this.example, (List)this.listBBCode, null);
    }

    static /* synthetic */ BBCode access$000(UIAddBBCodeForm x0) {
        return x0.bbcode;
    }

    static /* synthetic */ List access$102(UIAddBBCodeForm x0, List x1) {
        x0.listBBCode = x1;
        return x0.listBBCode;
    }

    static /* synthetic */ ForumService access$200(UIAddBBCodeForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ List access$100(UIAddBBCodeForm x0) {
        return x0.listBBCode;
    }

    static /* synthetic */ boolean access$302(UIAddBBCodeForm x0, boolean x1) {
        x0.isPriview = x1;
        return x0.isPriview;
    }

    static /* synthetic */ boolean access$400(UIAddBBCodeForm x0) {
        return x0.isEdit;
    }

    static /* synthetic */ String access$502(UIAddBBCodeForm x0, String x1) {
        x0.example = x1;
        return x0.example;
    }
}

