/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.BBCode;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIForumAdministrationForm;
import org.exoplatform.forum.webui.popup.UIListTopicOld;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIForumAdministrationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddIpActionListener.class}), @EventConfig(listeners={PostsActionListener.class}), @EventConfig(listeners={UnBanActionListener.class}, confirm="UIForumAdministrationForm.msg.confirm-delete-ipban"), @EventConfig(listeners={GetDefaultMailActionListener.class}), @EventConfig(listeners={AddNewBBCodeActionListener.class}), @EventConfig(listeners={EditBBCodeActionListener.class}), @EventConfig(listeners={DeleteBBCodeActionListener.class}), @EventConfig(listeners={AddTopicTypeActionListener.class}), @EventConfig(listeners={EditTopicTypeActionListener.class}), @EventConfig(listeners={DeleteTopicTypeActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={PruneSettingActionListener.class}), @EventConfig(listeners={RunPruneActionListener.class}), @EventConfig(listeners={ActivatePruneActionListener.class})})
public class UIForumAdministrationForm
extends UIForm
implements UIPopupComponent {
    private ForumService forumService;
    private ForumAdministration administration;
    private int id = 0;
    private boolean isRenderListTopic = false;
    public static final String FIELD_FORUMSORT_TAB = "forumSortTab";
    public static final String FIELD_CENSOREDKEYWORD_TAB = "forumCensorTab";
    public static final String FIELD_ACTIVETOPIC_TAB = "activeTopicTab";
    public static final String FIELD_NOTIFYEMAIL_TAB = "notifyEmailTab";
    public static final String FIELD_AUTOPRUNE_TAB = "autoPruneTab";
    public static final String FIELD_TOPICTYPEMANAGER_TAB = "topicTypeManagerTab";
    public static final String FIELD_BBCODE_TAB = "bbcodesTab";
    public static final String IP_BAN_TAB = "ipBanTab";
    public static final String NEW_IP_BAN_INPUT1 = "newIpBan1";
    public static final String NEW_IP_BAN_INPUT2 = "newIpBan2";
    public static final String NEW_IP_BAN_INPUT3 = "newIpBan3";
    public static final String NEW_IP_BAN_INPUT4 = "newIpBan4";
    public static final String SEARCH_IP_BAN = "searchIpBan";
    public static final String FIELD_FORUMSORTBY_INPUT = "forumSortBy";
    public static final String FIELD_FORUMSORTBYTYPE_INPUT = "forumSortByType";
    public static final String FIELD_TOPICSORTBY_INPUT = "topicSortBy";
    public static final String FIELD_TOPICSORTBYTYPE_INPUT = "topicSortByType";
    public static final String FIELD_CENSOREDKEYWORD_TEXTAREA = "censorKeyword";
    public static final String FIELD_ENABLEHEADERSUBJECT_CHECKBOX = "enableHeaderSubject";
    public static final String FIELD_HEADERSUBJECT_INPUT = "headerSubject";
    public static final String FIELD_NOTIFYEMAIL_TEXTAREA = "notifyEmail";
    public static final String FIELD_NOTIFYEMAILMOVED_TEXTAREA = "notifyEmailMoved";
    public static final String FIELD_ACTIVEABOUT_INPUT = "activeAbout";
    public static final String FIELD_SETACTIVE_INPUT = "setActive";
    public static final String BAN_IP_PAGE_ITERATOR = "IpBanPageIterator";
    private JCRPageList pageList;
    private List<String> listIpBan = new ArrayList();
    private List<BBCode> listBBCode = new ArrayList();
    private List<TopicType> listTT = new ArrayList();
    List<PruneSetting> listPruneSetting = new ArrayList();
    private UIForumPageIterator pageIterator;

    public UIForumAdministrationForm() throws Exception {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        this.addChild(UIListTopicOld.class, null, null);
        this.setActions(new String[]{"Save", "Cancel"});
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, BAN_IP_PAGE_ITERATOR);
    }

    public void setInit() throws Exception {
        this.getPruneSettings();
        this.administration = this.forumService.getForumAdministration();
        UIFormInputWithActions forumSortTab = new UIFormInputWithActions(FIELD_FORUMSORT_TAB);
        UIFormInputWithActions forumCensorTab = new UIFormInputWithActions(FIELD_CENSOREDKEYWORD_TAB);
        UIFormInputWithActions notifyEmailTab = new UIFormInputWithActions(FIELD_NOTIFYEMAIL_TAB);
        UIFormInputWithActions ipBanTab = new UIFormInputWithActions(IP_BAN_TAB);
        UIFormInputWithActions bbcodeTab = new UIFormInputWithActions(FIELD_BBCODE_TAB);
        UIFormInputWithActions autoPruneTab = new UIFormInputWithActions(FIELD_AUTOPRUNE_TAB);
        UIFormInputWithActions topicTypeManagerTag = new UIFormInputWithActions(FIELD_TOPICTYPEMANAGER_TAB);
        String[] idLables = new String[]{"forumOrder", "isLock", "createdDate", "modifiedDate", "topicCount", "postCount"};
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption(this.getLabel("forumName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox forumSortBy = new UIFormSelectBox(FIELD_FORUMSORTBY_INPUT, FIELD_FORUMSORTBY_INPUT, ls);
        forumSortBy.setValue(this.administration.getForumSortBy());
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox forumSortByType = new UIFormSelectBox(FIELD_FORUMSORTBYTYPE_INPUT, FIELD_FORUMSORTBYTYPE_INPUT, ls);
        forumSortByType.setValue(this.administration.getForumSortByType());
        idLables = new String[]{"isLock", "createdDate", "modifiedDate", "lastPostDate", "postCount", "viewCount", "numberAttachments"};
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("threadName"), (Object)"name"));
        for (String string : idLables) {
            ls.add(new SelectItemOption(this.getLabel(string), (Object)string));
        }
        UIFormSelectBox topicSortBy = new UIFormSelectBox(FIELD_TOPICSORTBY_INPUT, FIELD_TOPICSORTBY_INPUT, ls);
        topicSortBy.setValue(this.administration.getTopicSortBy());
        ls = new ArrayList();
        ls.add(new SelectItemOption(this.getLabel("ascending"), (Object)"ascending"));
        ls.add(new SelectItemOption(this.getLabel("descending"), (Object)"descending"));
        UIFormSelectBox topicSortByType = new UIFormSelectBox(FIELD_TOPICSORTBYTYPE_INPUT, FIELD_TOPICSORTBYTYPE_INPUT, ls);
        topicSortByType.setValue(this.administration.getTopicSortByType());
        UIFormTextAreaInput censorKeyword = new UIFormTextAreaInput(FIELD_CENSOREDKEYWORD_TEXTAREA, FIELD_CENSOREDKEYWORD_TEXTAREA, null);
        censorKeyword.setValue((Object)this.administration.getCensoredKeyword());
        UIFormStringInput activeAbout = new UIFormStringInput(FIELD_ACTIVEABOUT_INPUT, FIELD_ACTIVEABOUT_INPUT, null);
        activeAbout.setValue((Object)"0");
        activeAbout.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption("true", (Object)"true"));
        options.add(new SelectItemOption("false", (Object)"false"));
        UIFormRadioBoxInput setActive = new UIFormRadioBoxInput(FIELD_SETACTIVE_INPUT, FIELD_SETACTIVE_INPUT, options);
        setActive.setValue((Object)"false");
        String value = this.administration.getNotifyEmailContent();
        if (ForumUtils.isEmpty((String)value)) {
            value = this.getLabel("notifyEmailContentDefault");
        }
        UIFormWYSIWYGInput notifyEmail = new UIFormWYSIWYGInput(FIELD_NOTIFYEMAIL_TEXTAREA, FIELD_NOTIFYEMAIL_TEXTAREA, "");
        notifyEmail.setValue((Object)value);
        value = this.administration.getNotifyEmailMoved();
        if (ForumUtils.isEmpty((String)value)) {
            value = this.getLabel("EmailToAuthorMoved");
        }
        UIFormWYSIWYGInput notifyEmailMoved = new UIFormWYSIWYGInput(FIELD_NOTIFYEMAILMOVED_TEXTAREA, FIELD_NOTIFYEMAILMOVED_TEXTAREA, "");
        notifyEmailMoved.setValue((Object)value);
        UIFormCheckBoxInput enableHeaderSubject = new UIFormCheckBoxInput(FIELD_ENABLEHEADERSUBJECT_CHECKBOX, FIELD_ENABLEHEADERSUBJECT_CHECKBOX, (Object)false);
        enableHeaderSubject.setChecked(this.administration.getEnableHeaderSubject());
        UIFormStringInput headerSubject = new UIFormStringInput(FIELD_HEADERSUBJECT_INPUT, FIELD_HEADERSUBJECT_INPUT, null);
        String headerSubject_ = this.administration.getHeaderSubject();
        if (ForumUtils.isEmpty((String)headerSubject_)) {
            headerSubject_ = this.getLabel("notifyEmailHeaderSubjectDefault");
        }
        headerSubject.setValue((Object)headerSubject_);
        this.setListBBcode();
        for (BBCode bbc : this.listBBCode) {
            UIFormCheckBoxInput isActiveBBcode = new UIFormCheckBoxInput(bbc.getId(), bbc.getId(), (Object)false);
            isActiveBBcode.setChecked(bbc.isActive());
            bbcodeTab.addChild((UIComponent)isActiveBBcode);
        }
        forumSortTab.addUIFormInput((UIFormInput)forumSortBy);
        forumSortTab.addUIFormInput((UIFormInput)forumSortByType);
        forumSortTab.addUIFormInput((UIFormInput)topicSortBy);
        forumSortTab.addUIFormInput((UIFormInput)topicSortByType);
        notifyEmailTab.addUIFormInput((UIFormInput)enableHeaderSubject);
        notifyEmailTab.addUIFormInput((UIFormInput)headerSubject);
        notifyEmailTab.addUIFormInput((UIFormInput)notifyEmail);
        notifyEmailTab.addUIFormInput((UIFormInput)notifyEmailMoved);
        forumCensorTab.addUIFormInput((UIFormInput)censorKeyword);
        this.addUIFormInput((UIFormInput)activeAbout);
        this.addUIFormInput((UIFormInput)setActive);
        this.addUIFormInput((UIFormInputSet)forumSortTab);
        this.addUIFormInput((UIFormInputSet)forumCensorTab);
        this.addUIFormInput((UIFormInputSet)notifyEmailTab);
        this.addUIFormInput((UIFormInputSet)bbcodeTab);
        this.addUIFormInput((UIFormInputSet)autoPruneTab);
        this.addUIFormInput((UIFormInputSet)topicTypeManagerTag);
        if (ForumUtils.enableIPLogging()) {
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_IP_BAN, null));
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT1, null).setMaxLength(3));
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT2, null).setMaxLength(3));
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT3, null).setMaxLength(3));
            ipBanTab.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT4, null).setMaxLength(3));
            this.addUIFormInput((UIFormInputSet)ipBanTab);
        }
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData ad = new UIFormInputWithActions.ActionData();
        ad.setActionListener("GetDefaultMail");
        ad.setActionParameter(FIELD_NOTIFYEMAIL_TEXTAREA);
        ad.setCssIconClass("Refresh");
        ad.setActionName("TitleResetMail");
        actions.add(ad);
        notifyEmailTab.setActionField(FIELD_NOTIFYEMAIL_TEXTAREA, actions);
        actions = new ArrayList();
        ad = new UIFormInputWithActions.ActionData();
        ad.setActionListener("GetDefaultMail");
        ad.setActionParameter(FIELD_NOTIFYEMAILMOVED_TEXTAREA);
        ad.setCssIconClass("Refresh");
        ad.setActionName("TitleResetMail");
        actions.add(ad);
        notifyEmailTab.setActionField(FIELD_NOTIFYEMAILMOVED_TEXTAREA, actions);
    }

    public void setListBBcode() throws Exception {
        this.listBBCode = new ArrayList();
        try {
            this.listBBCode.addAll(this.forumService.getAllBBCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<PruneSetting> getPruneSettings() throws Exception {
        this.listPruneSetting = new ArrayList();
        try {
            this.listPruneSetting.addAll(this.forumService.getAllPruneSetting());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.listPruneSetting;
    }

    private PruneSetting getPruneSetting(String pruneId) throws Exception {
        for (PruneSetting prune : this.listPruneSetting) {
            if (!prune.getId().equals(pruneId)) continue;
            return prune;
        }
        return new PruneSetting();
    }

    private List<TopicType> getTopicTypes() throws Exception {
        this.listTT = new ArrayList();
        this.listTT.addAll(this.forumService.getTopicTypes());
        return this.listTT;
    }

    private TopicType getTopicType(String topicTId) throws Exception {
        for (TopicType topicT : this.listTT) {
            if (!topicT.getId().equals(topicTId)) continue;
            return topicT;
        }
        return new TopicType();
    }

    private List<BBCode> getListBBcode() throws Exception {
        return this.listBBCode;
    }

    private BBCode getBBCode(String bbcId) {
        for (BBCode bbCode : this.listBBCode) {
            if (!bbCode.getId().equals(bbcId)) continue;
            return bbCode;
        }
        return new BBCode();
    }

    private List<String> getListIpBan() throws Exception {
        this.listIpBan = new ArrayList();
        try {
            this.listIpBan.addAll(this.forumService.getBanList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pageList = new ForumPageList(8, this.listIpBan.size());
        this.pageList.setPageSize(8);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList((long)this.pageIterator.getPageSelected(), this.listIpBan));
        this.pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1) {
                this.pageIterator.setRendered(false);
            } else {
                this.pageIterator.setRendered(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean isRenderListTopic() {
        return this.isRenderListTopic;
    }

    public void setRenderListTopic(boolean isRenderListTopic) {
        this.isRenderListTopic = isRenderListTopic;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getIsSelected(int id) {
        return this.id == id;
    }

    private String checkIpAddress(String[] ipAdd) {
        String ip = "";
        try {
            int[] ips = new int[4];
            for (int t = 0; t < ipAdd.length; ++t) {
                if (t > 0) {
                    ip = ip + ".";
                }
                ip = ip + ipAdd[t];
                ips[t] = Integer.parseInt(ipAdd[t]);
            }
            for (int i = 0; i < 4; ++i) {
                if (ips[i] >= 0 && ips[i] <= 255) continue;
                return null;
            }
            if (ips[0] == 255 && ips[1] == 255 && ips[2] == 255 && ips[3] == 255) {
                return null;
            }
            return ip;
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ ForumService access$000(UIForumAdministrationForm x0) {
        return x0.forumService;
    }

    static /* synthetic */ ForumAdministration access$100(UIForumAdministrationForm x0) {
        return x0.administration;
    }

    static /* synthetic */ List access$200(UIForumAdministrationForm x0) {
        return x0.listBBCode;
    }

    static /* synthetic */ PruneSetting access$300(UIForumAdministrationForm x0, String x1) throws Exception {
        return x0.getPruneSetting(x1);
    }

    static /* synthetic */ int access$402(UIForumAdministrationForm x0, int x1) {
        x0.id = x1;
        return x0.id;
    }

    static /* synthetic */ int access$400(UIForumAdministrationForm x0) {
        return x0.id;
    }

    static /* synthetic */ BBCode access$500(UIForumAdministrationForm x0, String x1) {
        return x0.getBBCode(x1);
    }

    static /* synthetic */ TopicType access$600(UIForumAdministrationForm x0, String x1) throws Exception {
        return x0.getTopicType(x1);
    }

    static /* synthetic */ String access$700(UIForumAdministrationForm x0, String[] x1) {
        return x0.checkIpAddress(x1);
    }
}

