/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.popup.UIBanIPForumManagerForm;
import org.exoplatform.forum.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIBanIPForumManagerForm.gtmpl", events={@EventConfig(listeners={AddIpActionListener.class}), @EventConfig(listeners={OpenPostsActionListener.class}), @EventConfig(listeners={UnBanActionListener.class}, confirm="UIBanIPForumManagerForm.confirm.UnBanIP"), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIBanIPForumManagerForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String SEARCH_IP_BAN = "searchIpBan";
    public static final String NEW_IP_BAN_INPUT1 = "newIpBan1";
    public static final String NEW_IP_BAN_INPUT2 = "newIpBan2";
    public static final String NEW_IP_BAN_INPUT3 = "newIpBan3";
    public static final String NEW_IP_BAN_INPUT4 = "newIpBan4";
    public static final String BAN_IP_PAGE_ITERATOR = "IpBanPageIterator";
    private String forumId;
    private JCRPageList pageList;
    private UIForumPageIterator pageIterator;

    public UIBanIPForumManagerForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH_IP_BAN, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT1, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT2, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT3, null).setMaxLength(3));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NEW_IP_BAN_INPUT4, null).setMaxLength(3));
        this.setActions(new String[]{"Cancel"});
        this.pageIterator = (UIForumPageIterator)this.addChild(UIForumPageIterator.class, null, BAN_IP_PAGE_ITERATOR);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setForumId(String forumId) {
        this.forumId = forumId;
    }

    private List<String> getListIpBan() throws Exception {
        List listIpBan = this.getForumService().getForumBanList(this.forumId);
        this.pageList = new ForumPageList(8, listIpBan.size());
        this.pageList.setPageSize(8);
        this.pageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        this.pageIterator.updatePageList(this.pageList);
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pageList.getPageList((long)this.pageIterator.getPageSelected(), listIpBan));
        this.pageIterator.setSelectPage((long)this.pageList.getCurrentPage());
        try {
            if (this.pageList.getAvailablePage() <= 1) {
                this.pageIterator.setRendered(false);
            } else {
                this.pageIterator.setRendered(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    protected String checkIpAddress(String[] ipAdd) {
        StringBuffer sbip = new StringBuffer();
        try {
            if (ipAdd.length != 4) {
                return null;
            }
            int[] ips = new int[4];
            for (int t = 0; t < ipAdd.length; ++t) {
                if (t > 0) {
                    sbip.append(".");
                }
                sbip.append(ipAdd[t]);
                ips[t] = Integer.parseInt(ipAdd[t]);
            }
            for (int i = 0; i < 4; ++i) {
                if (ips[i] >= 0 && ips[i] <= 255) continue;
                return null;
            }
            if (ips[0] == 255 && ips[1] == 255 && ips[2] == 255 && ips[3] == 255) {
                return null;
            }
            return sbip.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ String access$000(UIBanIPForumManagerForm x0) {
        return x0.forumId;
    }

    static /* synthetic */ ForumService access$100(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$200(UIBanIPForumManagerForm x0) {
        return x0.getForumService();
    }
}

