/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumCheckBoxInput;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UITopicDetail;
import org.exoplatform.forum.webui.UITopicDetailContainer;
import org.exoplatform.forum.webui.UITopicPoll;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/UITopicPoll.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={RemovePollActionListener.class}, confirm="UITopicPoll.msg.confirm-RemovePoll"), @EventConfig(listeners={ClosedPollActionListener.class}), @EventConfig(listeners={VoteAgainPollActionListener.class})})
public class UITopicPoll
extends BaseForumForm {
    private Poll poll_;
    private String categoryId;
    private String forumId;
    private String topicId;
    private boolean isAgainVote = false;
    private boolean isEditPoll = false;
    private boolean canViewEditMenu = false;
    private boolean userIsBanned = false;
    private Forum forum;
    private UserProfile userProfile;
    private PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);

    private UserProfile getUserProfile() throws Exception {
        this.userProfile = new UserProfile();
        try {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
        catch (Exception e) {
            try {
                this.userProfile = this.getForumService().getDefaultUserProfile(UserHelper.getCurrentUser(), "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.userProfile;
    }

    public void setForum(Forum forum) {
        if (forum == null) {
            try {
                this.forum = this.getForumService().getForum(this.categoryId, this.forumId);
            }
            catch (Exception exception) {}
        } else {
            this.forum = forum;
        }
    }

    public void updateFormPoll(String categoryId, String forumId, String topicId) throws Exception {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.isEditPoll = true;
        this.isAgainVote = false;
    }

    private void init() throws Exception {
        if (this.hasChildren()) {
            this.removeChild(UIFormRadioBoxInput.class);
            for (int i = 0; i < 10 && this.hasChildren(); ++i) {
                this.removeChild(UIForumCheckBoxInput.class);
            }
        }
        if (this.poll_ != null) {
            if (!this.poll_.getIsMultiCheck()) {
                ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                for (String s : this.poll_.getOption()) {
                    options.add(new SelectItemOption(s, (Object)s));
                }
                UIFormRadioBoxInput input = new UIFormRadioBoxInput("vote", "vote", options);
                input.setAlign(1);
                this.addUIFormInput((UIFormInput)input);
            } else {
                for (String s : this.poll_.getOption()) {
                    this.addUIFormInput((UIFormInput)new UIForumCheckBoxInput(s, s, (Object)false));
                }
            }
        }
    }

    private Poll getPoll() throws Exception {
        if (!ForumUtils.isEmpty((String)this.categoryId)) {
            this.canViewEditMenu = this.userProfile.getUserRole() == 0L || ForumServiceUtils.hasPermission((String[])this.forum.getModerators(), (String)this.userProfile.getUserId());
            String pollId = this.forum.getPath() + "/" + this.topicId + "/" + this.topicId.replace(Utils.TOPIC, Utils.POLL);
            try {
                this.poll_ = this.pollService.getPoll(pollId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.init();
            return this.poll_;
        }
        return null;
    }

    private boolean getIsEditPoll() {
        return this.isEditPoll;
    }

    public void setEditPoll(boolean isEditPoll) {
        this.isEditPoll = isEditPoll;
    }

    private boolean getCanViewEditMenu() {
        return this.canViewEditMenu;
    }

    private boolean isGuestPermission() throws Exception {
        String[] userVotes;
        Date today;
        if (this.poll_.getIsClosed()) {
            return true;
        }
        String userVote = this.userProfile.getUserId();
        this.userIsBanned = this.userProfile.getIsBanned();
        if (this.userIsBanned || this.userProfile.getUserRole() > 2L) {
            return true;
        }
        if (ForumUtils.isEmpty((String)userVote)) {
            return true;
        }
        if (this.poll_.getTimeOut() > 0L && (today = new Date()).getTime() - this.poll_.getCreatedDate().getTime() >= this.poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (this.isAgainVote) {
            return false;
        }
        for (String string : userVotes = this.poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(":"))).equalsIgnoreCase(userVote)) continue;
            return true;
        }
        return false;
    }

    private String[] getInfoVote() throws Exception {
        Poll poll = this.poll_;
        String[] voteNumber = poll.getVote();
        String[] userVotes = poll.getUserVote();
        long size = 0L;
        long temp = 1L;
        if (!poll.getIsMultiCheck()) {
            size = userVotes.length;
        } else {
            for (int i = 0; i < userVotes.length; ++i) {
                size += (long)(userVotes[i].split(":").length - 1);
            }
        }
        temp = size;
        if (size == 0L) {
            size = 1L;
        }
        int l = voteNumber.length;
        String[] infoVote = new String[l + 1];
        for (int j = 0; j < l; ++j) {
            String string = voteNumber[j];
            double tmp = Double.parseDouble(string);
            double k = tmp * (double)size / 100.0;
            int t = (int)Math.round(k);
            string = "" + (double)t * 100.0 / (double)size;
            infoVote[j] = string + ":" + t;
        }
        infoVote[l] = "" + temp;
        if (poll.getIsMultiCheck()) {
            infoVote[l] = String.valueOf(userVotes.length);
        }
        return infoVote;
    }

    private void reloadTopicDetail() {
        UITopicDetailContainer topicDetailContainer = (UITopicDetailContainer)this.getParent();
        ((UITopicDetail)topicDetailContainer.getChild(UITopicDetail.class)).setIsEditTopic(true);
    }

    static /* synthetic */ Poll access$000(UITopicPoll x0) {
        return x0.poll_;
    }

    static /* synthetic */ UserProfile access$100(UITopicPoll x0) {
        return x0.userProfile;
    }

    static /* synthetic */ void access$200(UITopicPoll x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ boolean access$300(UITopicPoll x0) {
        return x0.isAgainVote;
    }

    static /* synthetic */ void access$400(UITopicPoll x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ PollService access$500(UITopicPoll x0) {
        return x0.pollService;
    }

    static /* synthetic */ boolean access$302(UITopicPoll x0, boolean x1) {
        x0.isAgainVote = x1;
        return x0.isAgainVote;
    }

    static /* synthetic */ String access$600(UITopicPoll x0) {
        return x0.categoryId;
    }

    static /* synthetic */ String access$700(UITopicPoll x0) {
        return x0.forumId;
    }

    static /* synthetic */ String access$800(UITopicPoll x0) {
        return x0.topicId;
    }

    static /* synthetic */ Poll access$002(UITopicPoll x0, Poll x1) {
        x0.poll_ = x1;
        return x0.poll_;
    }

    static /* synthetic */ Poll access$900(UITopicPoll x0) throws Exception {
        return x0.getPoll();
    }

    static /* synthetic */ boolean access$1002(UITopicPoll x0, boolean x1) {
        x0.isEditPoll = x1;
        return x0.isEditPoll;
    }

    static /* synthetic */ void access$1100(UITopicPoll x0) throws Exception {
        x0.init();
    }
}

