/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.download.DownloadService;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.popup.UIViewUserProfile;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewMemberProfile.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewUserProfile
extends BaseUIForm
implements UIPopupComponent {
    private UserProfile userProfile;
    private UserProfile userProfileLogin;
    private CommonContact contact = null;
    private ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    private boolean isGetContact = true;

    public CommonContact getContact(String userId) throws Exception {
        if (this.contact == null || this.isGetContact) {
            this.contact = this.getPersonalContact(userId);
        }
        return this.contact;
    }

    public void setContact(CommonContact contact) {
        this.isGetContact = false;
        this.contact = contact;
    }

    private boolean isAdmin(String userId) throws Exception {
        return this.forumService.isAdminRole(userId);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.forumService.isOnline(userId);
    }

    private String getScreenName(String userName) throws Exception {
        return this.forumService.getScreenName(userName);
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfileLogin(UserProfile userProfile) {
        this.userProfileLogin = userProfile;
    }

    public UserProfile getUserProfileLogin() {
        return this.userProfileLogin;
    }

    private CommonContact getPersonalContact(String userId) throws Exception {
        CommonContact contact = ForumSessionUtils.getPersonalContact((String)userId);
        if (contact == null) {
            contact = new CommonContact();
        }
        return contact;
    }

    private String getAvatarUrl(CommonContact contact) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        String url = ForumSessionUtils.getUserAvatarURL((String)this.getUserProfile().getUserId(), (ForumService)this.forumService, (DownloadService)dservice);
        return url;
    }

    private String[] getLabelProfile() {
        return new String[]{"userName", "firstName", "lastName", "birthDay", "gender", "email", "jobTitle", "location", "workPhone", "mobilePhone", "website"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

