/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.TopicType;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIFormDateTimePicker;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UISearchForm;
import org.exoplatform.forum.webui.UISliderControl;
import org.exoplatform.forum.webui.popup.UISelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetFieldActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddValuesUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIUserSearchPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UISearchForm
extends UIForm
implements UISelector {
    private static final String FIELD_SEARCHVALUE_INPUT = "SearchValue";
    private static final String FIELD_SCOPE_RADIOBOX = "Scope";
    private static final String FIELD_SEARCHUSER_INPUT = "SearchUser";
    private static final String FIELD_SEARCHTYPE_SELECTBOX = "SearchType";
    private static final String FIELD_TOPICTYPE_SELECTBOX = "TopicType";
    private static final String FIELD_TOPICCOUNTMIN_SLIDER = "TopicCountMax";
    private static final String FIELD_POSTCOUNTMIN_SLIDER = "PostCountMax";
    private static final String FIELD_VIEWCOUNTMIN_SLIDER = "ViewCountMax";
    private static final String FIELD_ISLOCK_CHECKBOX = "IsLock";
    private static final String FIELD_ISUNLOCK_CHECKBOX = "IsUnLock";
    private static final String FIELD_ISCLOSED_CHECKBOX = "IsClosed";
    private static final String FIELD_ISOPEN_CHECKBOX = "IsOpen";
    private static final String FIELD_MODERATOR_INPUT = "Moderator";
    private static final String FROMDATECREATED = "FromDateCreated";
    private static final String TODATECREATED = "ToDateCreated";
    private static final String FROMDATECREATEDLASTPOST = "FromDateCreatedLastPost";
    private static final String TODATECREATEDLASTPOST = "ToDateCreatedLastPost";
    private UserProfile userProfile = null;
    private boolean isSearchForum = false;
    private boolean isSearchCate = false;
    private boolean isSearchTopic = false;
    private String path = "";
    private ForumService forumService;
    private List<TopicType> listTT = new ArrayList();

    public UISearchForm() throws Exception {
        if (this.getId() == null) {
            this.setId("UISearchForm");
        }
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        UIFormStringInput searchValue = new UIFormStringInput(FIELD_SEARCHVALUE_INPUT, FIELD_SEARCHVALUE_INPUT, null);
        UIFormStringInput searchUser = new UIFormStringInput(FIELD_SEARCHUSER_INPUT, FIELD_SEARCHUSER_INPUT, null);
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(this.getLabel("Category"), (Object)Utils.CATEGORY));
        list.add(new SelectItemOption(this.getLabel("Forum"), (Object)Utils.FORUM));
        list.add(new SelectItemOption(this.getLabel("Topic"), (Object)Utils.TOPIC));
        list.add(new SelectItemOption(this.getLabel("Post"), (Object)Utils.POST));
        UIFormSelectBox searchType = new UIFormSelectBox(FIELD_SEARCHTYPE_SELECTBOX, FIELD_SEARCHTYPE_SELECTBOX, list);
        searchType.setOnChange("Onchange");
        list = new ArrayList();
        list.add(new SelectItemOption(this.getLabel("All"), (Object)"all"));
        for (TopicType topicType : this.listTT) {
            list.add(new SelectItemOption(topicType.getName(), (Object)topicType.getId()));
        }
        UIFormSelectBox topicType = new UIFormSelectBox(FIELD_TOPICTYPE_SELECTBOX, FIELD_TOPICTYPE_SELECTBOX, list);
        topicType.setValue(TopicType.DEFAULT_ID);
        list = new ArrayList();
        list.add(new SelectItemOption(this.getLabel("Full"), (Object)"entire"));
        list.add(new SelectItemOption(this.getLabel("Titles"), (Object)"title"));
        UIFormRadioBoxInput boxInput = new UIFormRadioBoxInput(FIELD_SCOPE_RADIOBOX, FIELD_SCOPE_RADIOBOX, list);
        boxInput.setValue((Object)"entire");
        UIFormCheckBoxInput isLock = new UIFormCheckBoxInput(FIELD_ISLOCK_CHECKBOX, FIELD_ISLOCK_CHECKBOX, (Object)false);
        UIFormCheckBoxInput isUnLock = new UIFormCheckBoxInput(FIELD_ISUNLOCK_CHECKBOX, FIELD_ISUNLOCK_CHECKBOX, (Object)false);
        UIFormCheckBoxInput isClosed = new UIFormCheckBoxInput(FIELD_ISCLOSED_CHECKBOX, FIELD_ISCLOSED_CHECKBOX, (Object)false);
        UIFormCheckBoxInput isOpent = new UIFormCheckBoxInput(FIELD_ISOPEN_CHECKBOX, FIELD_ISOPEN_CHECKBOX, (Object)false);
        String showCalendar = this.getLabel("ShowCalendar");
        UIFormDateTimePicker FromDateCreated = new UIFormDateTimePicker(FROMDATECREATED, FROMDATECREATED, null, false, showCalendar);
        UIFormDateTimePicker ToDateCreated = new UIFormDateTimePicker(TODATECREATED, TODATECREATED, null, false, showCalendar);
        UIFormDateTimePicker FromDateCreatedLastPost = new UIFormDateTimePicker(FROMDATECREATEDLASTPOST, FROMDATECREATEDLASTPOST, null, false, showCalendar);
        UIFormDateTimePicker ToDateCreatedLastPost = new UIFormDateTimePicker(TODATECREATEDLASTPOST, TODATECREATEDLASTPOST, null, false, showCalendar);
        UISliderControl topicCountMin = new UISliderControl(FIELD_TOPICCOUNTMIN_SLIDER, FIELD_TOPICCOUNTMIN_SLIDER, "0");
        UISliderControl postCountMin = new UISliderControl(FIELD_POSTCOUNTMIN_SLIDER, FIELD_POSTCOUNTMIN_SLIDER, "0");
        UISliderControl viewCountMin = new UISliderControl(FIELD_VIEWCOUNTMIN_SLIDER, FIELD_VIEWCOUNTMIN_SLIDER, "0");
        UIFormStringInput moderator = new UIFormStringInput(FIELD_MODERATOR_INPUT, FIELD_MODERATOR_INPUT, null);
        this.addUIFormInput((UIFormInput)searchValue);
        this.addUIFormInput((UIFormInput)searchType);
        this.addUIFormInput((UIFormInput)topicType);
        this.addUIFormInput((UIFormInput)boxInput);
        this.addUIFormInput((UIFormInput)searchUser);
        this.addUIFormInput((UIFormInput)isLock);
        this.addUIFormInput((UIFormInput)isUnLock);
        this.addUIFormInput((UIFormInput)isClosed);
        this.addUIFormInput((UIFormInput)isOpent);
        this.addUIFormInput((UIFormInput)FromDateCreated);
        this.addUIFormInput((UIFormInput)ToDateCreated);
        this.addUIFormInput((UIFormInput)FromDateCreatedLastPost);
        this.addUIFormInput((UIFormInput)ToDateCreatedLastPost);
        this.addUIFormInput((UIFormInput)topicCountMin);
        this.addUIFormInput((UIFormInput)postCountMin);
        this.addUIFormInput((UIFormInput)viewCountMin);
        this.addUIFormInput((UIFormInput)moderator);
        this.setActions(new String[]{"Search", "ResetField", "Cancel"});
    }

    public boolean getIsSearchCate() {
        return this.isSearchCate;
    }

    public boolean getIsSearchForum() {
        return this.isSearchForum;
    }

    public void setIsSearchForum(boolean isSearchForum) {
        this.isSearchForum = isSearchForum;
    }

    public boolean getIsSearchTopic() {
        return this.isSearchTopic;
    }

    public void setIsSearchTopic(boolean isSearchTopic) {
        this.isSearchTopic = isSearchTopic;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private void setTopicType() throws Exception {
        this.listTT.clear();
        this.listTT.addAll(this.forumService.getTopicTypes());
    }

    public void setUserProfile(UserProfile userProfile) throws Exception {
        try {
            this.userProfile = userProfile;
        }
        catch (Exception e) {
            this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
        }
    }

    private boolean getIsMod() {
        return this.userProfile != null && this.userProfile.getUserRole() < 2L;
    }

    public void setSelectType(String type) throws Exception {
        this.getUIFormSelectBox(FIELD_SEARCHTYPE_SELECTBOX).setValue(type);
        if (type.equals(Utils.FORUM)) {
            this.isSearchForum = true;
            this.isSearchTopic = false;
            this.isSearchCate = false;
        } else if (type.equals(Utils.TOPIC)) {
            this.isSearchCate = false;
            this.isSearchForum = false;
            this.isSearchTopic = true;
            this.setTopicType();
            ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
            list.add(new SelectItemOption(this.getLabel("All"), (Object)"all"));
            for (TopicType topicType : this.listTT) {
                list.add(new SelectItemOption(topicType.getName(), (Object)topicType.getId()));
            }
            this.getUIFormSelectBox(FIELD_TOPICTYPE_SELECTBOX).setOptions(list);
        } else if (type.equals(Utils.CATEGORY)) {
            this.isSearchCate = true;
            this.isSearchForum = false;
            this.isSearchTopic = false;
        } else {
            this.isSearchCate = false;
            this.isSearchForum = false;
            this.isSearchTopic = false;
        }
        try {
            ((UIForumLinks)((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getChild(UIForumLinks.class)).setValueOption("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UIFormRadioBoxInput getUIFormRadioBoxInput(String name) {
        return (UIFormRadioBoxInput)this.findComponentById(name);
    }

    public String getLabel(ResourceBundle res, String id) throws Exception {
        String label = this.getId() + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (Exception e) {
            return id;
        }
    }

    private String checkValue(String input) throws Exception {
        if (!ForumUtils.isEmpty((String)input)) {
            try {
                Integer.parseInt(input.trim());
                return input.trim();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        String values = (String)fieldInput.getValue();
        if (!ForumUtils.isEmpty((String)values)) {
            if (!ForumUtils.isStringInStrings((String[])values.split(","), (String)value)) {
                if (values.trim().lastIndexOf(",") != values.length() - 1) {
                    values = values.trim() + ",";
                }
                values = values + value;
            }
        } else {
            values = value;
        }
        fieldInput.setValue((Object)values);
    }

    private Calendar getCalendar(UIFormDateTimePicker dateTimeInput, String faled) throws Exception {
        Calendar calendar = dateTimeInput.getCalendar();
        if (!ForumUtils.isEmpty((String)((String)dateTimeInput.getValue())) && calendar == null) {
            Object[] args = new Object[]{faled};
            throw new MessageException(new ApplicationMessage("NameValidator.msg.erro-format-date", args, 1));
        }
        return calendar;
    }

    public UIFormDateTimePicker getUIFormDateTimePicker(String name) {
        return (UIFormDateTimePicker)this.findComponentById(name);
    }

    static /* synthetic */ boolean access$000(UISearchForm x0) {
        return x0.getIsMod();
    }

    static /* synthetic */ Calendar access$100(UISearchForm x0, UIFormDateTimePicker x1, String x2) throws Exception {
        return x0.getCalendar(x1, x2);
    }

    static /* synthetic */ UserProfile access$200(UISearchForm x0) {
        return x0.userProfile;
    }

    static /* synthetic */ String access$300(UISearchForm x0) {
        return x0.path;
    }

    static /* synthetic */ String access$400(UISearchForm x0, String x1) throws Exception {
        return x0.checkValue(x1);
    }

    static /* synthetic */ ForumService access$500(UISearchForm x0) {
        return x0.forumService;
    }
}

