/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.webui.UICategories;
import org.exoplatform.forum.webui.UIForumListSearch;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.rss.RSS;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UICategories.gtmpl", events={@EventConfig(listeners={CollapCategoryActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={OpenForumLinkActionListener.class}), @EventConfig(listeners={AddBookMarkActionListener.class}), @EventConfig(listeners={AddWatchingActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={RSSActionListener.class}), @EventConfig(listeners={OpenLastTopicLinkActionListener.class}), @EventConfig(listeners={OpenLastReadTopicActionListener.class})})
public class UICategories
extends UIContainer {
    protected ForumService forumService;
    private Map<String, List<Forum>> mapListForum = new HashMap();
    private Map<String, Topic> maptopicLast = new HashMap();
    private List<Category> categoryList = new ArrayList();
    private Map<String, Forum> AllForum = new HashMap();
    public final String FORUM_LIST_SEARCH = "forumListSearch";
    private boolean isGetForumList = false;
    private boolean isRenderChild = false;
    private boolean useAjax = true;
    private int dayForumNewPost = 0;
    private UserProfile userProfile;
    private List<String> collapCategories = null;
    private List<Watch> listWatches = new ArrayList();
    private String linkUserInfo = "";
    private Log log = ExoLogger.getLogger(this.getClass());

    public UICategories() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        ((UIForumListSearch)this.addChild(UIForumListSearch.class, null, null)).setRendered(this.isRenderChild);
    }

    public void setIsRenderChild(boolean isRenderChild) {
        ((UIForumListSearch)this.getChild(UIForumListSearch.class)).setRendered(isRenderChild);
        this.isRenderChild = isRenderChild;
    }

    public boolean getIsRendered() throws Exception {
        return this.isRenderChild;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRSSLink(String cateId) {
        return RSS.getRSSLink((String)"forum", (String)this.getPortalName(), (String)cateId);
    }

    private String getScreenName(String userName) throws Exception {
        return this.forumService.getScreenName(userName);
    }

    private UserProfile getUserProfile() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.useAjax = forumPortlet.isUseAjax();
        this.dayForumNewPost = forumPortlet.getDayForumNewPost();
        this.userProfile = forumPortlet.getUserProfile();
        if (!this.userProfile.getUserId().equals("user_gest_uoom")) {
            this.collapCategories = new ArrayList();
            this.collapCategories.addAll(Arrays.asList(this.userProfile.getCollapCategories()));
        } else if (this.collapCategories == null) {
            this.collapCategories = new ArrayList();
        }
        this.listWatches = forumPortlet.getWatchingByCurrentUser();
        this.linkUserInfo = forumPortlet.getPortletLink();
        return this.userProfile;
    }

    private String getActionViewInfoUser(String linkType, String userName) {
        String link = this.linkUserInfo.replace("ViewPublicUserInfo", linkType).replace("userName", userName);
        return link;
    }

    private boolean isWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            if (!path.equals(watch.getNodePath()) || !watch.isAddWatchByEmail()) continue;
            return true;
        }
        return false;
    }

    private String getEmailWatching(String path) throws Exception {
        for (Watch watch : this.listWatches) {
            try {
                if (!watch.getNodePath().endsWith(path)) continue;
                return watch.getEmail();
            }
            catch (Exception e) {
            }
        }
        return "";
    }

    private int getDayForumNewPost() {
        return this.dayForumNewPost;
    }

    public boolean getUseAjax() {
        return this.useAjax;
    }

    private String getLastReadPostOfForum(String forumId) throws Exception {
        return this.userProfile.getLastPostIdReadOfForum(forumId);
    }

    private boolean isCollapCategories(String categoryId) {
        return this.collapCategories.contains(categoryId);
    }

    public List<Category> getCategorys() {
        return this.categoryList;
    }

    public List<Category> getPrivateCategories() {
        ArrayList<Category> list = new ArrayList<Category>();
        for (Category cate : this.categoryList) {
            if (cate.getUserPrivate() == null || cate.getUserPrivate().length <= 0) continue;
            list.add(cate);
        }
        return list;
    }

    public List<Forum> getForums(String categoryId) {
        return (List)this.mapListForum.get(categoryId);
    }

    public Map<String, Forum> getAllForum() {
        return this.AllForum;
    }

    private boolean isShowCategory(String id) {
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleCategories());
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(id);
    }

    private boolean isShowForum(String id) {
        if (((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleCategories().isEmpty()) {
            return true;
        }
        ArrayList list = new ArrayList();
        list.addAll(((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getInvisibleForums());
        return list.contains(id);
    }

    private List<Category> getCategoryList() throws Exception {
        try {
            this.categoryList = this.forumService.getCategories();
        }
        catch (Exception e) {
            this.categoryList = new ArrayList();
        }
        return this.categoryList;
    }

    public void setIsgetForumList(boolean isGetForumList) {
        this.isGetForumList = isGetForumList;
    }

    private List<Forum> getForumList(String categoryId) throws Exception {
        if (this.isCollapCategories(categoryId)) {
            return new ArrayList<Forum>();
        }
        List forumList = new ArrayList();
        String strQuery = "";
        if (this.userProfile.getUserRole() > 0L) {
            strQuery = "(@exo:isClosed='false') or (exo:moderators='" + this.userProfile.getUserId() + "')";
        }
        forumList = this.forumService.getForumSummaries(categoryId, strQuery);
        if (this.mapListForum.containsKey(categoryId)) {
            this.mapListForum.remove(categoryId);
        }
        this.mapListForum.put(categoryId, forumList);
        ArrayList<Forum> listForum = new ArrayList<Forum>();
        for (Forum forum : forumList) {
            String forumId = forum.getId();
            if (this.AllForum.containsKey(forumId)) {
                this.AllForum.remove(forumId);
            }
            this.AllForum.put(forumId, forum);
            if (!this.isShowForum(forumId)) continue;
            listForum.add(forum);
        }
        return listForum;
    }

    private Forum getForumById(String categoryId, String forumId) throws Exception {
        Forum forum_ = new Forum();
        if (!this.mapListForum.isEmpty() && !this.isGetForumList) {
            for (Forum forum : (List)this.mapListForum.get(categoryId)) {
                if (!forum.getId().equals(forumId)) continue;
                forum_ = forum;
                break;
            }
        }
        if (forum_ == null) {
            forum_ = this.forumService.getForum(categoryId, forumId);
        }
        return forum_;
    }

    private Topic getLastTopic(Category cate, Forum forum) throws Exception {
        Topic topic = null;
        String topicPath = forum.getLastTopicPath();
        if (!ForumUtils.isEmpty((String)topicPath)) {
            String topicId = topicPath;
            if (topicId.indexOf("/") >= 0) {
                topicId = topicId.substring(topicPath.lastIndexOf("/") + 1);
            }
            if ((topic = (Topic)this.maptopicLast.get(topicId)) == null) {
                try {
                    topic = this.forumService.getTopicSummary(topicPath);
                }
                catch (Exception e) {
                    this.log.warn((Object)e);
                }
            }
            if (topic != null) {
                if (((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).checkCanView(cate, forum, topic)) {
                    this.maptopicLast.put(topic.getId(), topic);
                } else {
                    if (this.maptopicLast.containsKey(topicId)) {
                        this.maptopicLast.remove(topicId);
                    }
                    return null;
                }
            }
        }
        return topic;
    }

    private Category getCategory(String categoryId) throws Exception {
        for (Category category : this.getCategoryList()) {
            if (!category.getId().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    private boolean getIsPrivate(String[] uesrs) throws Exception {
        if (uesrs != null && uesrs.length > 0 && !uesrs[0].equals(" ")) {
            return ForumServiceUtils.hasPermission((String[])uesrs, (String)this.userProfile.getUserId());
        }
        return true;
    }

    static /* synthetic */ UserProfile access$000(UICategories x0) {
        return x0.userProfile;
    }

    static /* synthetic */ List access$100(UICategories x0) {
        return x0.collapCategories;
    }

    static /* synthetic */ List access$200(UICategories x0, String x1) throws Exception {
        return x0.getForumList(x1);
    }

    static /* synthetic */ Category access$300(UICategories x0, String x1) throws Exception {
        return x0.getCategory(x1);
    }

    static /* synthetic */ Map access$400(UICategories x0) {
        return x0.maptopicLast;
    }

    static /* synthetic */ Forum access$500(UICategories x0, String x1, String x2) throws Exception {
        return x0.getForumById(x1, x2);
    }

    static /* synthetic */ String access$600(UICategories x0, String x1) throws Exception {
        return x0.getEmailWatching(x1);
    }
}

