/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIViewUserProfile;
import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIViewMemberProfile.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIViewUserProfile
extends BaseForumForm
implements UIPopupComponent {
    private UserProfile userProfileViewer;
    private CommonContact contact = null;
    private boolean isGetContact = true;

    public CommonContact getContact(String userId) throws Exception {
        if (this.contact == null || this.isGetContact) {
            this.contact = this.getPersonalContact(userId);
        }
        return this.contact;
    }

    public void setContact(CommonContact contact) {
        this.isGetContact = false;
        this.contact = contact;
    }

    private boolean isAdmin(String userId) throws Exception {
        return this.getForumService().isAdminRole(userId);
    }

    private boolean isOnline(String userId) throws Exception {
        return this.getForumService().isOnline(userId);
    }

    public void setUserProfileViewer(UserProfile userProfileViewer) {
        this.userProfileViewer = userProfileViewer;
    }

    public UserProfile getUserProfileViewer() {
        return this.userProfileViewer;
    }

    private CommonContact getPersonalContact(String userId) throws Exception {
        CommonContact contact = ForumSessionUtils.getPersonalContact((String)userId);
        if (contact == null) {
            contact = new CommonContact();
        }
        return contact;
    }

    private String getAvatarUrl() throws Exception {
        return ForumSessionUtils.getUserAvatarURL((String)this.userProfileViewer.getUserId(), (ForumService)this.getForumService());
    }

    private String[] getLabelProfile() {
        return new String[]{"userName", "firstName", "lastName", "birthDay", "gender", "email", "jobTitle", "location", "workPhone", "mobilePhone", "website"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

