/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/forum/webui/UIPostRules.gtmpl")
public class UIPostRules
extends UIContainer {
    private UserProfile userProfile;
    private boolean canCreateNewThread = false;
    private boolean canAddPost = false;

    public boolean isCanCreateNewThread() {
        return this.canCreateNewThread;
    }

    public boolean isCanAddPost() {
        return this.canAddPost;
    }

    private UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            try {
                this.userProfile = ((UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class)).getUserProfile();
            }
            catch (Exception e) {
                ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
                this.userProfile = forumService.getDefaultUserProfile(UserHelper.getCurrentUser(), ForumUtils.EMPTY_STR);
            }
        }
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public void setLock(boolean isLock) {
        this.canCreateNewThread = !isLock;
        this.canAddPost = !isLock;
    }

    public void setCanAddPost(boolean canAddPost) {
        this.canAddPost = canAddPost;
    }

    public void setCanCreateNewThread(boolean canCreatThread) {
        this.canCreateNewThread = canCreatThread;
    }
}

