/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Locale;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIAutoPruneSettingForm;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIAutoPruneSettingForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RunActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAutoPruneSettingForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_INACTIVEDAY_INPUT = "inActiveDay";
    public static final String FIELD_INACTIVEDAY_SELECTBOX = "inActiveDayType";
    public static final String FIELD_JOBDAY_INPUT = "jobDay";
    public static final String FIELD_JOBDAY_SELECTBOX = "jobDayType";
    public static final String FIELD_VALUEDAY = "Day";
    public static final String FIELD_VALUEWEEKS = "Weeks";
    public static final String FIELD_VALUEMONTHS = "Months";
    private PruneSetting pruneSetting;
    private Locale locale;
    private long topicOld = 0L;
    private boolean isTest = false;
    private boolean isActivate = false;

    public UIAutoPruneSettingForm() throws Exception {
        if (this.getId() == null) {
            this.setId("UIAutoPruneSettingForm");
        }
        UIFormStringInput inActiveDay = new UIFormStringInput(FIELD_INACTIVEDAY_INPUT, FIELD_INACTIVEDAY_INPUT, null);
        inActiveDay.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        inActiveDay.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormStringInput jobDay = new UIFormStringInput(FIELD_JOBDAY_INPUT, FIELD_JOBDAY_INPUT, null);
        jobDay.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        inActiveDay.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormSelectBox inActiveDayType = this.getSelectBox(FIELD_INACTIVEDAY_SELECTBOX, false);
        UIFormSelectBox jobDayType = this.getSelectBox(FIELD_JOBDAY_SELECTBOX, true);
        this.addUIFormInput((UIFormInput)inActiveDay);
        this.addUIFormInput((UIFormInput)inActiveDayType);
        this.addUIFormInput((UIFormInput)jobDay);
        this.addUIFormInput((UIFormInput)jobDayType);
        this.setActions(new String[]{"Save", "Close"});
    }

    private void setLocale() throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        Locale locale = portalContext.getLocale();
        if (this.locale == null || !locale.getLanguage().equals(this.locale.getLanguage())) {
            this.getSelectBox(FIELD_INACTIVEDAY_SELECTBOX, false);
            this.getSelectBox(FIELD_JOBDAY_SELECTBOX, true);
            this.locale = locale;
        }
    }

    private UIFormSelectBox getSelectBox(String field, boolean isJobDay) {
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        list.add(new SelectItemOption(this.getLabel(FIELD_VALUEDAY), (Object)(FIELD_VALUEDAY + (isJobDay ? "_Id" : ForumUtils.EMPTY_STR))));
        list.add(new SelectItemOption(this.getLabel(FIELD_VALUEWEEKS), (Object)(FIELD_VALUEWEEKS + (isJobDay ? "_Id" : ForumUtils.EMPTY_STR))));
        list.add(new SelectItemOption(this.getLabel(FIELD_VALUEMONTHS), (Object)(FIELD_VALUEMONTHS + (isJobDay ? "_Id" : ForumUtils.EMPTY_STR))));
        UIFormSelectBox selectBox = this.getUIFormSelectBox(field);
        if (selectBox == null) {
            selectBox = new UIFormSelectBox(field, field, list);
            selectBox.setDefaultValue((Object)(FIELD_VALUEDAY + (isJobDay ? "_Id" : ForumUtils.EMPTY_STR)));
        } else {
            selectBox.setOptions(list);
        }
        selectBox.setHTMLAttribute("title", this.getLabel("SelectDateTime"));
        return selectBox;
    }

    public boolean isActivate() {
        return this.isActivate;
    }

    public void setActivate(boolean isActivate) {
        this.isActivate = isActivate;
    }

    protected void setInitForm() throws Exception {
        if (!this.isTest) {
            long i = this.pruneSetting.getInActiveDay();
            String type = FIELD_VALUEDAY;
            if (i != 0L) {
                if (i % 7L == 0L) {
                    i /= 7L;
                    type = FIELD_VALUEWEEKS;
                } else if (i % 30L == 0L) {
                    i /= 30L;
                    type = FIELD_VALUEMONTHS;
                }
            }
            this.getUIStringInput(FIELD_INACTIVEDAY_INPUT).setValue((Object)String.valueOf(i));
            this.getSelectBox(FIELD_INACTIVEDAY_SELECTBOX, false).setValue(type);
            i = this.pruneSetting.getPeriodTime();
            type = FIELD_VALUEDAY;
            if (i != 0L) {
                if (i % 7L == 0L) {
                    i /= 7L;
                    type = FIELD_VALUEWEEKS;
                } else if (i % 30L == 0L) {
                    i /= 30L;
                    type = FIELD_VALUEMONTHS;
                }
            }
            type = type + "_Id";
            this.getUIStringInput(FIELD_JOBDAY_INPUT).setValue((Object)String.valueOf(i));
            this.getSelectBox(FIELD_JOBDAY_SELECTBOX, true).setValue(type);
            this.isTest = false;
        } else {
            this.setLocale();
        }
    }

    public void setPruneSetting(PruneSetting pruneSetting) {
        this.pruneSetting = pruneSetting;
    }

    public long getTopicOld() {
        return this.topicOld;
    }

    public void setTopicOld(long topicOld) {
        this.topicOld = topicOld;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private long convertDay(String type, long date) throws Exception {
        if (type.equals(FIELD_VALUEMONTHS) || type.equals("Months_Id")) {
            date *= 30L;
        } else if (type.equals(FIELD_VALUEWEEKS) || type.equals("Weeks_Id")) {
            date *= 7L;
        }
        return date;
    }

    static /* synthetic */ long access$000(UIAutoPruneSettingForm x0, String x1, long x2) throws Exception {
        return x0.convertDay(x1, x2);
    }

    static /* synthetic */ PruneSetting access$100(UIAutoPruneSettingForm x0) {
        return x0.pruneSetting;
    }

    static /* synthetic */ boolean access$200(UIAutoPruneSettingForm x0) {
        return x0.isActivate;
    }

    static /* synthetic */ boolean access$202(UIAutoPruneSettingForm x0, boolean x1) {
        x0.isActivate = x1;
        return x0.isActivate;
    }

    static /* synthetic */ ForumService access$300(UIAutoPruneSettingForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ void access$400(UIAutoPruneSettingForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ void access$500(UIAutoPruneSettingForm x0, String x1, String[] x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ long access$602(UIAutoPruneSettingForm x0, long x1) {
        x0.topicOld = x1;
        return x0.topicOld;
    }

    static /* synthetic */ ForumService access$700(UIAutoPruneSettingForm x0) {
        return x0.getForumService();
    }

    static /* synthetic */ boolean access$802(UIAutoPruneSettingForm x0, boolean x1) {
        x0.isTest = x1;
        return x0.isTest;
    }

    static /* synthetic */ void access$900(UIAutoPruneSettingForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

