/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumSessionUtils;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.webui.BaseForumForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDataForm
extends BaseForumForm {
    public String topicId;
    public String forumId;
    public boolean isMoveTopic = false;
    public boolean isMovePost = false;
    public String pathTopic = ForumUtils.EMPTY_STR;
    public String pathPost = ForumUtils.EMPTY_STR;
    public List<String> canAddTopics = new ArrayList();
    public List<String> canAddPosts = new ArrayList();
    public List<String> canViewPosts = new ArrayList();

    public List<Category> getCategories() throws Exception {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (Category category : this.getForumService().getCategories()) {
            if (this.getUserProfile().getUserRole() == 1L) {
                if (!ForumUtils.isArrayEmpty((String[])category.getUserPrivate()) && !ForumServiceUtils.hasPermission((String[])category.getUserPrivate(), (String)this.userProfile.getUserId())) continue;
                if (this.isMoveTopic && ForumServiceUtils.hasPermission((String[])category.getCreateTopicRole(), (String)this.userProfile.getUserId())) {
                    this.canAddTopics.add(category.getId());
                }
                if (this.isMovePost && ForumServiceUtils.hasPermission((String[])category.getPoster(), (String)this.userProfile.getUserId())) {
                    this.canAddPosts.add(category.getId());
                }
                if (this.isMovePost && ForumServiceUtils.hasPermission((String[])category.getViewer(), (String)this.userProfile.getUserId())) {
                    this.canViewPosts.add(category.getId());
                }
            }
            categories.add(category);
        }
        return categories;
    }

    public List<Forum> getForums(String categoryId) throws Exception {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        String strQueryForum = ForumUtils.EMPTY_STR;
        if (categoryId.indexOf(ForumUtils.SPACE_GROUP_ID) > 0) {
            strQueryForum = ForumSessionUtils.getQueryForumInSpace((String)this.getUserProfile().getUserId());
        }
        for (Forum forum : this.getForumService().getForumSummaries(categoryId, strQueryForum)) {
            if (forum.getId().equals(this.forumId) && this.pathTopic.indexOf(categoryId) >= 0) continue;
            if (this.getUserProfile().getUserRole() == 1L) {
                if (forum.getIsClosed() || !ForumServiceUtils.hasPermission((String[])forum.getModerators(), (String)this.userProfile.getUserId()) && (forum.getIsLock() || this.isMoveTopic && !this.canAddTopics.contains(categoryId) && !ForumUtils.isArrayEmpty((String[])forum.getCreateTopicRole()) && !ForumServiceUtils.hasPermission((String[])forum.getCreateTopicRole(), (String)this.userProfile.getUserId()))) continue;
                if (this.isMovePost && ForumServiceUtils.hasPermission((String[])forum.getPoster(), (String)this.userProfile.getUserId())) {
                    this.canAddPosts.add(forum.getId());
                }
                if (this.isMovePost && ForumServiceUtils.hasPermission((String[])forum.getViewer(), (String)this.userProfile.getUserId())) {
                    this.canViewPosts.add(forum.getId());
                }
            } else if (this.userProfile.getUserRole() > 1L) continue;
            forums.add(forum);
        }
        return forums;
    }

    public List<Topic> getTopics(String categoryId, String forumId, boolean isMode) throws Exception {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (Topic topic : this.getForumService().getTopics(categoryId, forumId)) {
            if (topic.getId().equalsIgnoreCase(this.topicId) && this.pathPost.indexOf(categoryId) >= 0 && this.pathPost.indexOf(forumId) > 0 || this.getUserProfile().getUserRole() == 1L && !isMode && (!topic.getIsActive() || !topic.getIsActiveByForum() || !topic.getIsApproved() || topic.getIsClosed() || topic.getIsLock() || topic.getIsWaiting() || !this.canViewPosts.contains(categoryId) && this.canViewPosts.contains(forumId) && topic.getCanView().length > 0 && !ForumServiceUtils.hasPermission((String[])topic.getCanView(), (String)this.userProfile.getUserId()) || !this.canAddPosts.contains(categoryId) && this.canAddPosts.contains(forumId) && topic.getCanPost().length > 0 && !ForumServiceUtils.hasPermission((String[])topic.getCanPost(), (String)this.userProfile.getUserId()))) continue;
            topics.add(topic);
        }
        return topics;
    }
}

