/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumLinks;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UISelectItemForum;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.services.organization.Group;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UISelectItemForumForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectItemForum
extends BaseForumForm
implements UIPopupComponent {
    List<ForumLinkData> forumLinks = null;
    private Map<String, List<ForumLinkData>> mapListForum = new HashMap();
    private Map<String, List<ForumLinkData>> mapListTopic = new HashMap();
    private List<String> listIdIsSelected = new ArrayList();
    private String userId = null;
    private String categorySpId = "forumCategoryspaces";

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setForumLinks(List<String> listIds) throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        UIForumLinks uiForumLinks = (UIForumLinks)forumPortlet.getChild(UIForumLinks.class);
        this.listIdIsSelected = new ArrayList();
        this.listIdIsSelected.addAll(listIds);
        if (ForumUtils.isEmpty((String)forumPortlet.getCategorySpaceId()) && uiForumLinks != null) {
            this.forumLinks = uiForumLinks.getForumLinks();
        } else {
            this.categorySpId = forumPortlet.getCategorySpaceId();
        }
        if (this.forumLinks == null || this.forumLinks.size() <= 0) {
            if (this.getForumService().getCategory(this.categorySpId) != null) {
                this.forumLinks = new ArrayList();
                StringBuilder strQueryCate = new StringBuilder();
                strQueryCate.append("[").append("exo:id").append("!='").append(this.categorySpId).append("']");
                this.forumLinks.addAll(this.getForumService().getAllLink(strQueryCate.toString(), ForumUtils.EMPTY_STR));
                String strQuryForum = this.getQueryForum();
                if (!ForumUtils.isEmpty((String)strQuryForum)) {
                    strQueryCate = new StringBuilder();
                    strQueryCate.append("[").append("exo:id").append("='").append(this.categorySpId).append("']");
                    this.forumLinks.addAll(this.getForumService().getAllLink(strQueryCate.toString(), strQuryForum));
                }
            } else {
                this.forumLinks.addAll(this.getForumService().getAllLink(ForumUtils.EMPTY_STR, ForumUtils.EMPTY_STR));
            }
        }
    }

    private List<String> getGroupSpaceOfUser(String userId) {
        ArrayList<String> groupId = new ArrayList<String>();
        try {
            Collection groups = UserHelper.getOrganizationService().getGroupHandler().findGroupsOfUser(userId);
            for (Group group : groups) {
                if (group.getId().indexOf("/spaces") < 0) continue;
                groupId.add(group.getGroupName());
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"The method findGroupsOfUser() cannot access the database.");
        }
        return groupId;
    }

    private String getQueryForum() {
        if (!ForumUtils.isEmpty((String)this.userId)) {
            StringBuilder queryForum = new StringBuilder("[");
            List groupIds = this.getGroupSpaceOfUser(this.userId);
            for (String groupId : groupIds) {
                if (queryForum.length() > 10) {
                    queryForum.append(" or ");
                }
                queryForum.append("(jcr:like(@exo:id,'%" + groupId + "%'))");
            }
            queryForum.append("]");
            if (groupIds.size() > 0) {
                return queryForum.toString();
            }
        }
        return null;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    protected List<ForumLinkData> getForumLinks() throws Exception {
        ArrayList<ForumLinkData> linkForum = new ArrayList<ForumLinkData>();
        String cateId = ForumUtils.EMPTY_STR;
        for (ForumLinkData forumLink : this.forumLinks) {
            if (!forumLink.getType().equals(Utils.CATEGORY)) continue;
            cateId = forumLink.getId();
            for (ForumLinkData forumlist : this.forumLinks) {
                if (!forumlist.getType().equals(Utils.FORUM) || forumlist.getPath().indexOf(cateId) < 0) continue;
                linkForum.add(forumlist);
                if (this.getUICheckBoxInput(forumlist.getPath()) != null) continue;
                if (this.listIdIsSelected.contains(forumlist.getId())) {
                    this.addUIFormInput((UIFormInput)new UICheckBoxInput(forumlist.getPath(), forumlist.getPath(), Boolean.valueOf(false)).setChecked(true));
                    continue;
                }
                this.addUIFormInput((UIFormInput)new UICheckBoxInput(forumlist.getPath(), forumlist.getPath(), Boolean.valueOf(false)).setChecked(false));
            }
            this.mapListForum.put(cateId, linkForum);
            linkForum = new ArrayList();
        }
        return this.forumLinks;
    }

    protected List<ForumLinkData> getForums(String categoryId) {
        return (List)this.mapListForum.get(categoryId);
    }

    protected List<ForumLinkData> getTopics(String forumId) {
        return (List)this.mapListTopic.get(forumId);
    }

    private String getNameForumLinkData(String id) throws Exception {
        for (ForumLinkData linkData : this.forumLinks) {
            if (!linkData.getPath().equals(id)) continue;
            return linkData.getName();
        }
        return null;
    }

    static /* synthetic */ String access$000(UISelectItemForum x0, String x1) throws Exception {
        return x0.getNameForumLinkData(x1);
    }

    static /* synthetic */ void access$100(UISelectItemForum x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ void access$200(UISelectItemForum x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

