/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.info.ForumParameter;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.webui.UIBreadcumbs;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.UIQuickSearchForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/forum/webui/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={ChangePathActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}), @EventConfig(listeners={RssActionListener.class})})
public class UIBreadcumbs
extends UIContainer {
    private static Log log = ExoLogger.getExoLogger(UIBreadcumbs.class);
    private boolean useAjax = true;
    private ForumService forumService;
    private List<String> breadcumbs_ = new ArrayList();
    private List<String> path_ = new ArrayList();
    private String QUICK_SEARCH = "QuickSearchForm";
    public static final String FORUM_SERVICE = Utils.FORUM_SERVICE;
    private boolean isLink = false;
    private boolean isOpen = true;
    private String tooltipLink = Utils.FORUM_SERVICE;
    private UserProfile userProfile;

    public UIBreadcumbs() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
        this.path_.add(FORUM_SERVICE);
        this.addChild(UIQuickSearchForm.class, null, this.QUICK_SEARCH);
    }

    private void setIsUseAjax() throws Exception {
        UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
        this.userProfile = forumPortlet.getUserProfile();
        this.useAjax = forumPortlet.isUseAjax();
    }

    public void setUpdataPath(String path) throws Exception {
        this.isLink = false;
        this.setRenderForumLink(path);
        if (!ForumUtils.isEmpty((String)path) && !path.equals(FORUM_SERVICE)) {
            String[] temp = path.split(ForumUtils.SLASH);
            if (path.indexOf(ForumUtils.FIELD_EXOFORUM_LABEL) >= 0) {
                if (!ForumUtils.FIELD_EXOFORUM_LABEL.equals(path)) {
                    this.path_.clear();
                    this.breadcumbs_.clear();
                    this.path_.add(FORUM_SERVICE);
                    this.tooltipLink = FORUM_SERVICE;
                    this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
                }
                if (!this.breadcumbs_.contains(ForumUtils.FIELD_SEARCHFORUM_LABEL)) {
                    this.breadcumbs_.add(ForumUtils.FIELD_SEARCHFORUM_LABEL);
                    this.path_.add(ForumUtils.SLASH + ForumUtils.FIELD_EXOFORUM_LABEL);
                }
            } else {
                this.path_.clear();
                this.breadcumbs_.clear();
                this.path_.add(FORUM_SERVICE);
                this.tooltipLink = FORUM_SERVICE;
                this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
                String tempPath = ForumUtils.EMPTY_STR;
                int i = 0;
                try {
                    for (String string : temp) {
                        Object obj = this.forumService.getObjectNameByPath(tempPath = !ForumUtils.isEmpty((String)tempPath) ? tempPath + ForumUtils.SLASH + string : string);
                        if (obj == null) {
                            if (i != 0) break;
                            this.isLink = true;
                        }
                        if (obj instanceof Category) {
                            Category category = (Category)obj;
                            tempPath = string;
                            this.breadcumbs_.add(category.getCategoryName());
                            this.tooltipLink = ForumUtils.CATEGORY;
                        } else if (obj instanceof Forum) {
                            Forum forum = (Forum)obj;
                            this.breadcumbs_.add(forum.getForumName());
                            this.tooltipLink = ForumUtils.FORUM;
                        } else if (obj instanceof Topic) {
                            Topic topic = (Topic)obj;
                            this.breadcumbs_.add(topic.getTopicName());
                            this.tooltipLink = ForumUtils.TOPIC;
                        } else if (obj instanceof Tag) {
                            Tag tag = (Tag)obj;
                            this.breadcumbs_.add(tag.getName());
                            this.tooltipLink = ForumUtils.TAG;
                        }
                        this.path_.add(tempPath);
                        ++i;
                    }
                }
                catch (Exception e) {}
            }
        } else {
            this.path_.clear();
            this.breadcumbs_.clear();
            this.path_.add(FORUM_SERVICE);
            this.breadcumbs_.add(ForumUtils.FIELD_EXOFORUM_LABEL);
            this.tooltipLink = FORUM_SERVICE;
        }
    }

    private void setRenderForumLink(String path) throws Exception {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            ActionResponse actionRes = (ActionResponse)pcontext.getResponse();
            ForumParameter param = new ForumParameter();
            if (this.userProfile.getIsShowForumJump() && !path.equals(FORUM_SERVICE)) {
                if (path.indexOf(Utils.TOPIC) > 0) {
                    path = path.substring(0, path.lastIndexOf(ForumUtils.SLASH));
                }
                param.setRenderForumLink(true);
                param.setPath(path);
            } else {
                param.setRenderForumLink(false);
            }
            actionRes.setEvent(new QName("ForumLinkEvent"), (Serializable)param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    private String getToolTip() {
        return this.tooltipLink;
    }

    private boolean isLink() {
        return this.isLink;
    }

    public String getLastPath() {
        if (this.path_.size() > 0) {
            String str = (String)this.path_.get(this.path_.size() - 1);
            return (ForumUtils.SLASH + ForumUtils.FIELD_EXOFORUM_LABEL).equals(str) ? Utils.FORUM_SERVICE : str;
        }
        return Utils.FORUM_SERVICE;
    }

    private String getPath(int index) {
        return (String)this.path_.get(index);
    }

    private int getMaxPath() {
        return this.breadcumbs_.size();
    }

    private List<String> getBreadcumbs() throws Exception {
        return this.breadcumbs_;
    }

    private boolean isArrayNotNull(String[] strs) {
        return strs != null && strs.length > 0 && !strs[0].equals(" ");
    }

    private String getType(String id) {
        return id.indexOf(Utils.FORUM_SERVICE) >= 0 ? Utils.FORUM_SERVICE : (id.indexOf(Utils.CATEGORY) >= 0 ? ForumUtils.CATEGORY : (id.indexOf(Utils.FORUM) >= 0 ? ForumUtils.FORUM : (id.indexOf(Utils.TOPIC) >= 0 ? ForumUtils.TOPIC : ForumUtils.EMPTY_STR)));
    }

    private boolean checkLinkPrivate(String id) throws Exception {
        boolean isPrivate;
        block19: {
            isPrivate = false;
            if (id.indexOf(Utils.TOPIC) >= 0) {
                try {
                    Topic topic = (Topic)this.forumService.getObjectNameById(id, Utils.TOPIC);
                    if (topic == null) break block19;
                    if (topic.getIsClosed() || !topic.getIsActiveByForum() || !topic.getIsActive() || topic.getIsWaiting() || this.isArrayNotNull(topic.getCanView())) {
                        isPrivate = true;
                    }
                    if (!isPrivate) {
                        Category cate;
                        String path = topic.getPath();
                        id = path.substring(path.lastIndexOf(Utils.FORUM), path.indexOf(Utils.TOPIC) - 1);
                        Forum forum = (Forum)this.forumService.getObjectNameById(id, Utils.FORUM);
                        if (forum.getIsClosed()) {
                            isPrivate = true;
                        }
                        if (!isPrivate && this.isArrayNotNull((cate = (Category)this.forumService.getObjectNameById(id = path.substring(path.indexOf(Utils.CATEGORY), path.lastIndexOf(Utils.FORUM) - 1), Utils.CATEGORY)).getUserPrivate())) {
                            isPrivate = true;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\nThe " + id + " must exist: " + e.getMessage()), (Throwable)e);
                }
            } else if (id.indexOf(Utils.CATEGORY) == 0) {
                try {
                    Category cate = (Category)this.forumService.getObjectNameById(id, Utils.CATEGORY);
                    if (this.isArrayNotNull(cate.getUserPrivate())) {
                        isPrivate = true;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\nThe " + id + " must exist: " + e.getMessage()), (Throwable)e);
                }
            } else if (id.indexOf(Utils.FORUM) == 0) {
                try {
                    Forum forum = (Forum)this.forumService.getObjectNameById(id, Utils.FORUM);
                    if (forum.getIsClosed()) {
                        isPrivate = true;
                    }
                    if (!isPrivate) {
                        String path = forum.getPath();
                        Category cate = (Category)this.forumService.getObjectNameById(path = path.substring(path.indexOf(Utils.CATEGORY), path.lastIndexOf(Utils.FORUM) - 1), Utils.CATEGORY);
                        if (this.isArrayNotNull(cate.getUserPrivate())) {
                            isPrivate = true;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("\nThe " + id + " must exist: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return isPrivate;
    }

    static /* synthetic */ boolean access$002(UIBreadcumbs x0, boolean x1) {
        x0.isOpen = x1;
        return x0.isOpen;
    }
}

