/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIAddBBCodeForm;
import org.exoplatform.ks.bbcode.api.BBCode;
import org.exoplatform.ks.bbcode.api.BBCodeService;
import org.exoplatform.ks.bbcode.core.BBCodeRenderer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIAddBBCodeForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={PreviewActionListener.class}), @EventConfig(listeners={ApplyActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddBBCodeForm
extends BaseForumForm
implements UIPopupComponent {
    public static final String FIELD_TAGNAME_INPUT = "TagName";
    public static final String FIELD_REPLACEMENT_TEXTARE = "Replacement";
    public static final String FIELD_DESCRIPTION_TEXTARE = "Description";
    public static final String FIELD_EXAMPLE_TEXTARE = "Example";
    public static final String FIELD_USEOPTION_CHECKBOX = "UseOption";
    public static final String PREVIEW = "priview";
    private boolean isPriview = false;
    private BBCodeService bbCodeService;
    private String example = ForumUtils.EMPTY_STR;
    private List<BBCode> listBBCode = new ArrayList();
    private BBCode bbcode = new BBCode();
    private static Log log = ExoLogger.getLogger(UIAddBBCodeForm.class);

    public UIAddBBCodeForm() throws Exception {
        if (ForumUtils.isEmpty((String)this.getId())) {
            this.setId("UIAddBBCodeForm");
        }
        this.bbCodeService = (BBCodeService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(BBCodeService.class);
        UIFormStringInput tagNameInput = new UIFormStringInput(FIELD_TAGNAME_INPUT, FIELD_TAGNAME_INPUT, null);
        tagNameInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormTextAreaInput replacementInput = new UIFormTextAreaInput(FIELD_REPLACEMENT_TEXTARE, FIELD_REPLACEMENT_TEXTARE, null);
        replacementInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormTextAreaInput description = new UIFormTextAreaInput(FIELD_DESCRIPTION_TEXTARE, FIELD_DESCRIPTION_TEXTARE, null);
        UIFormTextAreaInput example = new UIFormTextAreaInput(FIELD_EXAMPLE_TEXTARE, FIELD_EXAMPLE_TEXTARE, null);
        example.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormCheckBoxInput isOption = new UIFormCheckBoxInput(FIELD_USEOPTION_CHECKBOX, FIELD_USEOPTION_CHECKBOX, (Object)false);
        this.addUIFormInput((UIFormInput)tagNameInput);
        this.addUIFormInput((UIFormInput)replacementInput);
        this.addUIFormInput((UIFormInput)description);
        this.addUIFormInput((UIFormInput)example);
        this.addUIFormInput((UIFormInput)isOption);
        this.setActions(new String[]{"Save", "ResetField", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private boolean getPriview() {
        return this.isPriview;
    }

    public void setEditBBcode(BBCode bbcode) throws Exception {
        this.bbcode.setId(bbcode.getId());
        this.getUIStringInput(FIELD_TAGNAME_INPUT).setValue((Object)bbcode.getTagName());
        UIFormTextAreaInput replacement = this.getUIFormTextAreaInput(FIELD_REPLACEMENT_TEXTARE);
        replacement.setValue((Object)bbcode.getReplacement());
        if (bbcode.getTagName().equalsIgnoreCase("list")) {
            replacement.setEditable(false);
        }
        this.getUIFormTextAreaInput(FIELD_DESCRIPTION_TEXTARE).setValue((Object)bbcode.getDescription());
        this.getUIFormTextAreaInput(FIELD_EXAMPLE_TEXTARE).setValue((Object)bbcode.getExample());
        this.getUIFormCheckBoxInput(FIELD_USEOPTION_CHECKBOX).setChecked(bbcode.isOption());
    }

    private void setBBcode() throws Exception {
        String tagName = (String)this.getUIStringInput(FIELD_TAGNAME_INPUT).getValue();
        String replacement = (String)this.getUIFormTextAreaInput(FIELD_REPLACEMENT_TEXTARE).getValue();
        String description = (String)this.getUIFormTextAreaInput(FIELD_DESCRIPTION_TEXTARE).getValue();
        String example = (String)this.getUIFormTextAreaInput(FIELD_EXAMPLE_TEXTARE).getValue();
        boolean isOption = (Boolean)this.getUIFormCheckBoxInput(FIELD_USEOPTION_CHECKBOX).getValue();
        if (ForumUtils.isEmpty((String)description)) {
            description = " ";
        }
        this.bbcode.setTagName(tagName.toUpperCase());
        this.bbcode.setReplacement(replacement);
        this.bbcode.setDescription(description);
        this.bbcode.setExample(example);
        this.bbcode.setOption(isOption);
        if (this.bbcode.getId() == null) {
            this.bbcode.setId(this.bbcode.getTagName() + (this.bbcode.isOption() ? "=" : ForumUtils.EMPTY_STR));
        }
        this.example = example;
    }

    private String getReplaceByBBCode() throws Exception {
        return new BBCodeRenderer().renderExample(this.example, this.bbcode);
    }

    static /* synthetic */ void access$000(UIAddBBCodeForm x0) throws Exception {
        x0.setBBcode();
    }

    static /* synthetic */ List access$102(UIAddBBCodeForm x0, List x1) {
        x0.listBBCode = x1;
        return x0.listBBCode;
    }

    static /* synthetic */ BBCodeService access$200(UIAddBBCodeForm x0) {
        return x0.bbCodeService;
    }

    static /* synthetic */ List access$100(UIAddBBCodeForm x0) {
        return x0.listBBCode;
    }

    static /* synthetic */ BBCode access$300(UIAddBBCodeForm x0) {
        return x0.bbcode;
    }

    static /* synthetic */ void access$400(UIAddBBCodeForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ Log access$500() {
        return log;
    }

    static /* synthetic */ void access$600(UIAddBBCodeForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }

    static /* synthetic */ boolean access$702(UIAddBBCodeForm x0, boolean x1) {
        x0.isPriview = x1;
        return x0.isPriview;
    }

    static /* synthetic */ String access$802(UIAddBBCodeForm x0, String x1) {
        x0.example = x1;
        return x0.example;
    }

    static /* synthetic */ void access$900(UIAddBBCodeForm x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

