/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormSelectBoxForum
extends UIFormStringInput {
    private boolean isMultiple_ = false;
    private int size_ = 1;
    private List<SelectItemOption<String>> options_;
    private String onchange_;

    public UIFormSelectBoxForum(String name, String bindingExpression, List<SelectItemOption<String>> options) {
        super(name, bindingExpression, null);
        this.setOptions(options);
    }

    public final UIFormSelectBoxForum setMultiple(boolean bl) {
        this.isMultiple_ = bl;
        return this;
    }

    public final UIFormSelectBoxForum setSize(int i) {
        this.size_ = i;
        return this;
    }

    public UIFormSelectBoxForum setValue(String value) {
        this.value_ = value;
        for (SelectItemOption option : this.options_) {
            if (((String)option.getValue()).equals(this.value_)) {
                option.setSelected(true);
                continue;
            }
            option.setSelected(false);
        }
        return this;
    }

    public String[] getSelectedValues() {
        if (this.isMultiple_) {
            ArrayList<Object> selectedValues = new ArrayList<Object>();
            for (int i = 0; i < this.options_.size(); ++i) {
                SelectItemOption item = (SelectItemOption)this.options_.get(i);
                if (!item.isSelected()) continue;
                selectedValues.add(item.getValue());
            }
            return selectedValues.toArray(new String[0]);
        }
        return new String[]{(String)this.value_};
    }

    public UIFormSelectBoxForum setSelectedValues(String[] values) {
        block0: for (SelectItemOption option : this.options_) {
            option.setSelected(false);
            for (String value : values) {
                if (!value.equals(option.getValue())) continue;
                option.setSelected(true);
                continue block0;
            }
        }
        return this;
    }

    public final List<SelectItemOption<String>> getOptions() {
        return this.options_;
    }

    public final UIFormSelectBoxForum setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        this.value_ = ((SelectItemOption)this.options_.get(0)).getValue();
        return this;
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public UIFormSelectBoxForum setDisabled(boolean disabled) {
        this.setEnable(!disabled);
        return this;
    }

    public void decode(Object input, WebuiRequestContext context) throws Exception {
        String[] values = context.getRequestParameterValues(this.getId());
        if (values == null) {
            this.value_ = null;
            for (SelectItemOption item : this.options_) {
                item.setSelected(false);
            }
            return;
        }
        int i = 0;
        this.value_ = values[0];
        for (SelectItemOption item : this.options_) {
            if (i > -1 && ((String)item.getValue()).equals(values[i])) {
                item.setSelected(true);
                if (values.length != ++i) continue;
                i = -1;
                continue;
            }
            item.setSelected(false);
        }
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String formId = null;
        formId = uiForm.getId().equals("UISearchForm") ? uiForm.getParent().getId() : uiForm.getId();
        Writer w = context.getWriter();
        w.write("<select class=\"selectbox\" name=\"");
        w.write(this.name);
        w.write("\"");
        if (this.onchange_ != null) {
            w.append(" onchange=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isMultiple_) {
            w.write(" multiple=\"true\"");
        }
        if (this.size_ > 1) {
            w.write(" size=\"" + this.size_ + "\"");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        w.write(">\n");
        for (SelectItemOption item : this.options_) {
            String labelAndCss = item.getLabel();
            String[] temp = labelAndCss.split(ForumUtils.SLASH);
            try {
                temp[0] = res.getString(formId + ".label.option." + (String)item.getValue());
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            String classCss = "optionNormal";
            if (temp.length > 1) {
                classCss = temp[1];
            }
            if (item.isSelected()) {
                w.write("<option selected=\"selected\" class=\"");
                w.write(classCss + " optionSelected");
                w.write("\" value=\"");
                w.write((String)item.getValue());
                w.write("\">");
            } else {
                w.write("<option class=\"");
                w.write(classCss);
                w.write("\" value=\"");
                w.write((String)item.getValue());
                w.write("\">");
            }
            w.write(temp[0]);
            w.write("</option>\n");
        }
        w.write("</select>\n");
    }
}

