/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.ForumTransformHTML;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.popup.UIMovePostForm;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIMovePostForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMovePostForm
extends BaseForumForm
implements UIPopupComponent {
    private String topicId;
    private List<Post> posts;
    private List<Category> categories;
    private String pathPost = ForumUtils.EMPTY_STR;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private String getTitleInHTMLCode(String s) {
        return ForumTransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void updatePost(String topicId, List<Post> posts) throws Exception {
        this.topicId = topicId;
        this.posts = posts;
        try {
            this.pathPost = posts.get(0).getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCategories();
    }

    private void setCategories() throws Exception {
        this.categories = new ArrayList();
        for (Category category : this.getForumService().getCategories()) {
            String[] list;
            if (this.getUserProfile().getUserRole() == 1L && (list = category.getUserPrivate()) != null && list.length > 0 && !list[0].equals(" ") && !ForumUtils.isStringInStrings((String[])list, (String)this.userProfile.getUserId())) continue;
            this.categories.add(category);
        }
    }

    private List<Category> getCategories() throws Exception {
        return this.categories;
    }

    private boolean getSelectForum(String forumId) throws Exception {
        return ((Post)this.posts.get(0)).getPath().contains(forumId);
    }

    private List<Forum> getForums(String categoryId) throws Exception {
        ArrayList<Forum> forums = new ArrayList<Forum>();
        for (Forum forum : this.getForumService().getForums(categoryId, ForumUtils.EMPTY_STR)) {
            String[] moderators;
            if (this.getUserProfile().getUserRole() == 1L && !ForumServiceUtils.hasPermission((String[])(moderators = forum.getModerators()), (String)this.userProfile.getUserId())) continue;
            forums.add(forum);
        }
        return forums;
    }

    private List<Topic> getTopics(String categoryId, String forumId, boolean isMode) throws Exception {
        ArrayList<Topic> topics = new ArrayList<Topic>();
        List topics_ = this.getForumService().getTopics(categoryId, forumId);
        for (Topic topic : topics_) {
            if (topic.getId().equalsIgnoreCase(this.topicId) && this.pathPost.indexOf(categoryId) >= 0 && this.pathPost.indexOf(forumId) > 0 || this.getUserProfile().getUserRole() == 1L && !isMode && (!topic.getIsActive() || !topic.getIsActiveByForum() || !topic.getIsApproved() || topic.getIsClosed() || topic.getIsLock() || topic.getIsWaiting() || topic.getCanPost().length > 0 && !ForumUtils.isStringInStrings((String[])topic.getCanPost(), (String)this.userProfile.getUserId()))) continue;
            topics.add(topic);
        }
        return topics;
    }

    static /* synthetic */ List access$000(UIMovePostForm x0) {
        return x0.posts;
    }

    static /* synthetic */ ForumService access$100(UIMovePostForm x0) {
        return x0.getForumService();
    }
}

