/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.webui.BaseForumForm;
import org.exoplatform.forum.webui.UIForumPageIterator;
import org.exoplatform.forum.webui.UIForumPortlet;
import org.exoplatform.forum.webui.popup.UIPageListPostByIP;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPageListPostByIP.gtmpl", events={@EventConfig(listeners={OpenPostLinkActionListener.class}), @EventConfig(listeners={SetOrderByActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={DeletePostLinkActionListener.class})})
public class UIPageListPostByIP
extends BaseForumForm
implements UIPopupComponent {
    private String userName = null;
    private String ip_ = null;
    private String strOrderBy = "createdDate descending";
    private boolean hasEnableIPLogging = true;
    private List<Post> posts = new ArrayList();

    public UIPageListPostByIP() throws Exception {
        this.addChild(UIForumPageIterator.class, null, "PageListPostByUser");
        this.setActions(new String[]{"Cancel"});
    }

    public boolean getHasEnableIPLogging() {
        return this.hasEnableIPLogging;
    }

    public UserProfile getUserProfile() throws Exception {
        if (this.userProfile == null) {
            UIForumPortlet forumPortlet = (UIForumPortlet)this.getAncestorOfType(UIForumPortlet.class);
            this.userProfile = forumPortlet.getUserProfile();
            this.hasEnableIPLogging = forumPortlet.isEnableIPLogging();
        }
        return this.userProfile;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userId) {
        this.userName = userId;
    }

    private String getTitleInHTMLCode(String s) {
        return TransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void setIp(String ip) {
        this.ip_ = ip;
        this.strOrderBy = "createdDate descending";
    }

    private List<Post> getPostsByUser() throws Exception {
        UIForumPageIterator forumPageIterator = (UIForumPageIterator)this.getChild(UIForumPageIterator.class);
        List<Object> posts = null;
        try {
            boolean isMod = false;
            if (this.userProfile.getUserRole() < 2L) {
                isMod = true;
            }
            JCRPageList pageList = this.getForumService().getListPostsByIP(this.ip_, this.strOrderBy);
            forumPageIterator.updatePageList(pageList);
            if (pageList != null) {
                pageList.setPageSize(6);
            }
            posts = pageList.getPage(forumPageIterator.getPageSelected());
            forumPageIterator.setSelectPage((long)pageList.getCurrentPage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (posts == null) {
            posts = new ArrayList<Post>();
        }
        this.posts = posts;
        return posts;
    }

    private Post getPostById(String postId) {
        for (Post post : this.posts) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return null;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ Post access$000(UIPageListPostByIP x0, String x1) {
        return x0.getPostById(x1);
    }

    static /* synthetic */ ForumService access$100(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$200(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$300(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$400(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$500(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ ForumService access$600(UIPageListPostByIP x0) {
        return x0.getForumService();
    }

    static /* synthetic */ String access$702(UIPageListPostByIP x0, String x1) {
        x0.strOrderBy = x1;
        return x0.strOrderBy;
    }

    static /* synthetic */ String access$700(UIPageListPostByIP x0) {
        return x0.strOrderBy;
    }

    static /* synthetic */ void access$800(UIPageListPostByIP x0) throws Exception {
        x0.cancelChildPopupAction();
    }
}

