/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.webui.UIForumKeepStickPageIterator;
import org.exoplatform.forum.webui.popup.UIPageListPostUnApprove;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.common.TransformHTML;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/forum/webui/popup/UIPageListPostUnApprove.gtmpl", events={@EventConfig(listeners={OpenPostLinkActionListener.class}), @EventConfig(listeners={UnApproveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIForumKeepStickPageIterator.GoPageActionListener.class})})
public class UIPageListPostUnApprove
extends UIForumKeepStickPageIterator
implements UIPopupComponent {
    private ForumService forumService;
    private String categoryId;
    private String forumId;
    private String topicId;
    private List<Post> listAllPost = new ArrayList();
    private boolean isApprove = true;

    public UIPageListPostUnApprove() throws Exception {
        this.forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        this.setActions(new String[]{"UnApprove", "Cancel"});
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    private String getTitleInHTMLCode(String s) {
        return TransformHTML.getTitleInHTMLCode((String)s, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
    }

    public void setUpdateContainer(String categoryId, String forumId, String topicId, boolean isApprove) {
        this.categoryId = categoryId;
        this.forumId = forumId;
        this.topicId = topicId;
        this.isApprove = isApprove;
    }

    private List<Post> getPosts() throws Exception {
        String app = "";
        String censer = "true";
        if (this.isApprove) {
            app = "false";
            censer = "";
        }
        this.pageList = this.forumService.getPosts(this.categoryId, this.forumId, this.topicId, app, ForumUtils.EMPTY_STR, censer, ForumUtils.EMPTY_STR);
        this.pageList.setPageSize(6);
        this.maxPage = this.pageList.getAvailablePage();
        ArrayList<Post> posts = this.pageList.getPage(this.pageSelect);
        this.pageSelect = this.pageList.getCurrentPage();
        if (posts == null) {
            posts = new ArrayList<Post>();
        }
        if (!posts.isEmpty()) {
            for (Post post : posts) {
                if (this.getUICheckBoxInput(post.getId()) != null) {
                    this.getUICheckBoxInput(post.getId()).setChecked(false);
                    continue;
                }
                this.addUIFormInput((UIFormInput)new UICheckBoxInput(post.getId(), post.getId(), Boolean.valueOf(false)));
            }
        }
        this.listAllPost = this.pageList.getPage(1);
        return posts;
    }

    private Post getPost(String postId) {
        for (Post post : this.listAllPost) {
            if (!post.getId().equals(postId)) continue;
            return post;
        }
        return null;
    }

    static /* synthetic */ Post access$000(UIPageListPostUnApprove x0, String x1) {
        return x0.getPost(x1);
    }

    static /* synthetic */ boolean access$100(UIPageListPostUnApprove x0) {
        return x0.isApprove;
    }

    static /* synthetic */ ForumService access$200(UIPageListPostUnApprove x0) {
        return x0.forumService;
    }

    static /* synthetic */ List access$300(UIPageListPostUnApprove x0) {
        return x0.listAllPost;
    }
}

